/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.hideshow;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.nebula.widgets.nattable.data.IRowDataProvider;
import org.eclipse.nebula.widgets.nattable.data.IRowIdAccessor;
import org.eclipse.nebula.widgets.nattable.data.convert.IDisplayConverter;
import org.eclipse.nebula.widgets.nattable.hideshow.AbstractRowHideShowLayer;
import org.eclipse.nebula.widgets.nattable.hideshow.IRowHideShowCommandLayer;
import org.eclipse.nebula.widgets.nattable.hideshow.IRowHideShowLayer;
import org.eclipse.nebula.widgets.nattable.hideshow.command.MultiRowHideCommandHandler;
import org.eclipse.nebula.widgets.nattable.hideshow.command.MultiRowShowCommandHandler;
import org.eclipse.nebula.widgets.nattable.hideshow.command.RowHideCommandHandler;
import org.eclipse.nebula.widgets.nattable.hideshow.command.RowPositionHideCommandHandler;
import org.eclipse.nebula.widgets.nattable.hideshow.command.RowShowCommandHandler;
import org.eclipse.nebula.widgets.nattable.hideshow.command.ShowAllRowsCommandHandler;
import org.eclipse.nebula.widgets.nattable.hideshow.event.HideRowPositionsEvent;
import org.eclipse.nebula.widgets.nattable.hideshow.event.ShowRowPositionsEvent;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.LabelStack;
import org.eclipse.nebula.widgets.nattable.sort.command.SortColumnCommand;

public class RowIdHideShowLayer<T>
extends AbstractRowHideShowLayer
implements IRowHideShowCommandLayer,
IRowHideShowLayer {
    public static final String PERSISTENCE_KEY_HIDDEN_ROW_IDS = ".hiddenRowIDs";
    protected final IRowDataProvider<T> rowDataProvider;
    protected final IRowIdAccessor<T> rowIdAccessor;
    protected Map<Serializable, T> hiddenRows = new HashMap<Serializable, T>();
    protected IDisplayConverter idConverter;

    public RowIdHideShowLayer(IUniqueIndexLayer underlyingLayer, IRowDataProvider<T> rowDataProvider, IRowIdAccessor<T> rowIdAccessor) {
        super(underlyingLayer);
        this.rowDataProvider = rowDataProvider;
        this.rowIdAccessor = rowIdAccessor;
        this.registerCommandHandler(new MultiRowHideCommandHandler(this));
        this.registerCommandHandler(new RowHideCommandHandler(this));
        this.registerCommandHandler(new ShowAllRowsCommandHandler(this));
        this.registerCommandHandler(new MultiRowShowCommandHandler(this));
        this.registerCommandHandler(new RowPositionHideCommandHandler(this));
        this.registerCommandHandler(new RowShowCommandHandler(this));
    }

    @Override
    public boolean doCommand(ILayerCommand command) {
        if (command instanceof SortColumnCommand) {
            this.invalidateCache();
        }
        return super.doCommand(command);
    }

    @Override
    public void saveState(String prefix, Properties properties) {
        if (this.hiddenRows.size() > 0) {
            StringBuilder strBuilder = new StringBuilder();
            for (Serializable id : this.hiddenRows.keySet()) {
                if (this.idConverter != null) {
                    strBuilder.append(this.idConverter.canonicalToDisplayValue(id));
                } else {
                    strBuilder.append(id.toString());
                }
                strBuilder.append(",");
            }
            properties.setProperty(String.valueOf(prefix) + PERSISTENCE_KEY_HIDDEN_ROW_IDS, strBuilder.toString());
        }
        super.saveState(prefix, properties);
    }

    @Override
    public void loadState(String prefix, Properties properties) {
        this.hiddenRows.clear();
        String property = properties.getProperty(String.valueOf(prefix) + PERSISTENCE_KEY_HIDDEN_ROW_IDS);
        if (property != null) {
            StringTokenizer tok = new StringTokenizer(property, ",");
            HashSet<Object> ids = new HashSet<Object>();
            while (tok.hasMoreTokens()) {
                String id = tok.nextToken();
                if (this.idConverter != null) {
                    ids.add((Serializable)this.idConverter.displayToCanonicalValue(id));
                    continue;
                }
                ids.add(id);
            }
            int row = 0;
            while (row < this.rowDataProvider.getRowCount()) {
                T rowObject = this.rowDataProvider.getRowObject(row);
                Serializable rowId = this.rowIdAccessor.getRowId(rowObject);
                if (ids.contains(rowId)) {
                    ids.remove(rowId);
                    this.hiddenRows.put(rowId, rowObject);
                }
                if (ids.isEmpty()) break;
                ++row;
            }
        }
        super.loadState(prefix, properties);
    }

    @Override
    public LabelStack getConfigLabelsByPosition(int columnPosition, int rowPosition) {
        int downRowIndex;
        LabelStack configLabels = super.getConfigLabelsByPosition(columnPosition, rowPosition);
        int underlyingPosition = this.localToUnderlyingRowPosition(rowPosition);
        int upRowIndex = this.underlyingLayer.getRowIndexByPosition(underlyingPosition - 1);
        if (this.isRowIndexHidden(upRowIndex)) {
            configLabels.addLabel("ROW_TOP_HIDDEN");
        }
        if (this.isRowIndexHidden(downRowIndex = this.underlyingLayer.getRowIndexByPosition(underlyingPosition + 1))) {
            configLabels.addLabel("ROW_BOTTOM_HIDDEN");
        }
        return configLabels;
    }

    @Override
    public boolean isRowIndexHidden(int rowIndex) {
        if (rowIndex >= 0) {
            T rowObject = this.getRowObjectByIndex(rowIndex);
            return this.hiddenRows.containsKey(this.rowIdAccessor.getRowId(rowObject));
        }
        return false;
    }

    @Override
    public Collection<Integer> getHiddenRowIndexes() {
        HashSet<Integer> result = new HashSet<Integer>();
        for (Map.Entry<Serializable, T> entry : this.hiddenRows.entrySet()) {
            result.add(this.getRowIndexById(entry.getKey()));
        }
        return result;
    }

    @Override
    public void hideRowPositions(Collection<Integer> rowPositions) {
        for (Integer rowPosition : rowPositions) {
            T rowObject = this.getRowObjectByPosition(rowPosition);
            this.hiddenRows.put(this.rowIdAccessor.getRowId(rowObject), rowObject);
        }
        this.invalidateCache();
        this.fireLayerEvent(new HideRowPositionsEvent((ILayer)this, rowPositions));
    }

    @Override
    public void hideRowIndexes(Collection<Integer> rowIndexes) {
        HashSet<Integer> rowPositions = new HashSet<Integer>();
        for (Integer rowIndex : rowIndexes) {
            rowPositions.add(this.getRowPositionByIndex(rowIndex));
            T rowObject = this.getRowObjectByIndex(rowIndex);
            this.hiddenRows.put(this.rowIdAccessor.getRowId(rowObject), rowObject);
        }
        this.invalidateCache();
        this.fireLayerEvent(new HideRowPositionsEvent((ILayer)this, (Collection<Integer>)rowPositions));
    }

    @Override
    public void showRowIndexes(Collection<Integer> rowIndexes) {
        for (Integer rowIndex : rowIndexes) {
            T rowObject = this.getRowObjectByIndex(rowIndex);
            this.hiddenRows.remove(this.rowIdAccessor.getRowId(rowObject));
        }
        this.invalidateCache();
        this.fireLayerEvent(new ShowRowPositionsEvent((ILayer)this, this.getRowPositionsByIndexes(rowIndexes)));
    }

    @Override
    public void showRowPosition(int rowPosition, boolean showToTop, boolean showAll) {
        HashSet<Integer> rowIndexes = new HashSet<Integer>();
        int underlyingPosition = this.localToUnderlyingRowPosition(rowPosition);
        if (showToTop) {
            int topRowIndex = this.underlyingLayer.getRowIndexByPosition(underlyingPosition - 1);
            if (showAll) {
                int move = 1;
                while (this.isRowIndexHidden(topRowIndex)) {
                    rowIndexes.add(topRowIndex);
                    topRowIndex = this.underlyingLayer.getRowIndexByPosition(underlyingPosition - ++move);
                }
            } else if (this.isRowIndexHidden(topRowIndex)) {
                rowIndexes.add(topRowIndex);
            }
        } else {
            int bottomRowIndex = this.underlyingLayer.getRowIndexByPosition(underlyingPosition + 1);
            if (showAll) {
                int move = 1;
                while (this.isRowIndexHidden(bottomRowIndex)) {
                    rowIndexes.add(bottomRowIndex);
                    bottomRowIndex = this.underlyingLayer.getRowIndexByPosition(underlyingPosition + ++move);
                }
            } else if (this.isRowIndexHidden(bottomRowIndex)) {
                rowIndexes.add(bottomRowIndex);
            }
        }
        if (!rowIndexes.isEmpty()) {
            this.showRowIndexes(rowIndexes);
        }
    }

    @Override
    public void showAllRows() {
        ArrayList<Integer> hiddenRows = new ArrayList<Integer>(this.getHiddenRowIndexes());
        this.hiddenRows.clear();
        this.invalidateCache();
        this.fireLayerEvent(new ShowRowPositionsEvent((ILayer)this, (Collection<Integer>)hiddenRows));
    }

    @Override
    public Collection<String> getProvidedLabels() {
        Collection<String> result = super.getProvidedLabels();
        result.add("ROW_TOP_HIDDEN");
        result.add("ROW_BOTTOM_HIDDEN");
        return result;
    }

    private T getRowObjectByPosition(int rowPosition) {
        int rowIndex = this.getRowIndexByPosition(rowPosition);
        return this.getRowObjectByIndex(rowIndex);
    }

    private T getRowObjectByIndex(int rowIndex) {
        if (rowIndex >= 0) {
            try {
                T rowObject = this.rowDataProvider.getRowObject(rowIndex);
                return rowObject;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private int getRowIndexById(Serializable rowId) {
        T rowObject = this.hiddenRows.get(rowId);
        int rowIndex = this.rowDataProvider.indexOfRowObject(rowObject);
        if (rowIndex == -1) {
            return -1;
        }
        return rowIndex;
    }

    public IDisplayConverter getIdConverter() {
        return this.idConverter;
    }

    public void setIdConverter(IDisplayConverter idConverter) {
        this.idConverter = idConverter;
    }
}

