/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.examples.fixtures;

import ca.odell.glazedlists.EventList;
import java.beans.PropertyChangeListener;
import org.eclipse.nebula.widgets.nattable.blink.BlinkLayer;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.IConfiguration;
import org.eclipse.nebula.widgets.nattable.data.IColumnAccessor;
import org.eclipse.nebula.widgets.nattable.data.IColumnPropertyResolver;
import org.eclipse.nebula.widgets.nattable.data.IRowIdAccessor;
import org.eclipse.nebula.widgets.nattable.data.ListDataProvider;
import org.eclipse.nebula.widgets.nattable.data.ReflectiveColumnPropertyAccessor;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.GlazedListsEventLayer;
import org.eclipse.nebula.widgets.nattable.freeze.CompositeFreezeLayer;
import org.eclipse.nebula.widgets.nattable.freeze.FreezeLayer;
import org.eclipse.nebula.widgets.nattable.group.ColumnGroupExpandCollapseLayer;
import org.eclipse.nebula.widgets.nattable.group.ColumnGroupModel;
import org.eclipse.nebula.widgets.nattable.group.ColumnGroupReorderLayer;
import org.eclipse.nebula.widgets.nattable.hideshow.ColumnHideShowLayer;
import org.eclipse.nebula.widgets.nattable.layer.AbstractLayer;
import org.eclipse.nebula.widgets.nattable.layer.AbstractLayerTransform;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.config.ColumnStyleChooserConfiguration;
import org.eclipse.nebula.widgets.nattable.reorder.ColumnReorderLayer;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.summaryrow.SummaryRowLayer;
import org.eclipse.nebula.widgets.nattable.util.IClientAreaProvider;
import org.eclipse.nebula.widgets.nattable.viewport.ViewportLayer;

public class FullFeaturedBodyLayerStack<T>
extends AbstractLayerTransform {
    private ColumnReorderLayer columnReorderLayer;
    private ColumnGroupReorderLayer columnGroupReorderLayer;
    private ColumnHideShowLayer columnHideShowLayer;
    private ColumnGroupExpandCollapseLayer columnGroupExpandCollapseLayer;
    private final SelectionLayer selectionLayer;
    private final ViewportLayer viewportLayer;
    private BlinkLayer<T> blinkingLayer;
    private DataLayer bodyDataLayer;
    private FreezeLayer freezeLayer;
    private CompositeFreezeLayer compositeFreezeLayer;
    private ListDataProvider<T> bodyDataProvider;
    private GlazedListsEventLayer<T> glazedListsEventLayer;

    public FullFeaturedBodyLayerStack(EventList<T> eventList, IRowIdAccessor<T> rowIdAccessor, String[] propertyNames, IConfigRegistry configRegistry, ColumnGroupModel columnGroupModel) {
        this(eventList, rowIdAccessor, propertyNames, configRegistry, columnGroupModel, true);
    }

    public FullFeaturedBodyLayerStack(EventList<T> eventList, IRowIdAccessor<T> rowIdAccessor, String[] propertyNames, IConfigRegistry configRegistry, ColumnGroupModel columnGroupModel, boolean useDefaultConfiguration) {
        ReflectiveColumnPropertyAccessor columnPropertyAccessor = new ReflectiveColumnPropertyAccessor(propertyNames);
        this.bodyDataProvider = new ListDataProvider(eventList, (IColumnAccessor)columnPropertyAccessor);
        this.bodyDataLayer = new DataLayer(this.bodyDataProvider);
        this.glazedListsEventLayer = new GlazedListsEventLayer((IUniqueIndexLayer)this.bodyDataLayer, eventList);
        this.blinkingLayer = new BlinkLayer(this.glazedListsEventLayer, this.bodyDataProvider, rowIdAccessor, (IColumnPropertyResolver)columnPropertyAccessor, configRegistry);
        SummaryRowLayer summaryRowLayer = new SummaryRowLayer(this.blinkingLayer, configRegistry);
        this.columnReorderLayer = new ColumnReorderLayer((IUniqueIndexLayer)summaryRowLayer);
        this.columnGroupReorderLayer = new ColumnGroupReorderLayer((IUniqueIndexLayer)this.columnReorderLayer, columnGroupModel);
        this.columnHideShowLayer = new ColumnHideShowLayer((IUniqueIndexLayer)this.columnGroupReorderLayer);
        this.columnGroupExpandCollapseLayer = new ColumnGroupExpandCollapseLayer((IUniqueIndexLayer)this.columnHideShowLayer, columnGroupModel);
        this.selectionLayer = new SelectionLayer((IUniqueIndexLayer)this.columnGroupExpandCollapseLayer);
        this.viewportLayer = new ViewportLayer((IUniqueIndexLayer)this.selectionLayer);
        this.freezeLayer = new FreezeLayer((IUniqueIndexLayer)this.selectionLayer);
        this.compositeFreezeLayer = new CompositeFreezeLayer(this.freezeLayer, this.viewportLayer, this.selectionLayer);
        this.setUnderlyingLayer((ILayer)this.compositeFreezeLayer);
        if (useDefaultConfiguration) {
            this.addConfiguration((IConfiguration)new ColumnStyleChooserConfiguration((AbstractLayer)this, this.selectionLayer));
        }
    }

    public void setClientAreaProvider(IClientAreaProvider clientAreaProvider) {
        super.setClientAreaProvider(clientAreaProvider);
    }

    public ColumnReorderLayer getColumnReorderLayer() {
        return this.columnReorderLayer;
    }

    public ColumnHideShowLayer getColumnHideShowLayer() {
        return this.columnHideShowLayer;
    }

    public SelectionLayer getSelectionLayer() {
        return this.selectionLayer;
    }

    public ViewportLayer getViewportLayer() {
        return this.viewportLayer;
    }

    public BlinkLayer<T> getBlinkingLayer() {
        return this.blinkingLayer;
    }

    public DataLayer getBodyDataLayer() {
        return this.bodyDataLayer;
    }

    public ListDataProvider<T> getBodyDataProvider() {
        return this.bodyDataProvider;
    }

    public ColumnGroupExpandCollapseLayer getColumnGroupExpandCollapseLayer() {
        return this.columnGroupExpandCollapseLayer;
    }

    public PropertyChangeListener getGlazedListEventsLayer() {
        return this.glazedListsEventLayer;
    }
}

