/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.examples.examples._130_Sorting;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.TransformedList;
import java.util.Collection;
import java.util.Comparator;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommandHandler;
import org.eclipse.nebula.widgets.nattable.config.AbstractRegistryConfiguration;
import org.eclipse.nebula.widgets.nattable.config.ConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.DefaultNatTableStyleConfiguration;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.IConfiguration;
import org.eclipse.nebula.widgets.nattable.config.NullComparator;
import org.eclipse.nebula.widgets.nattable.dataset.fixture.data.RowDataFixture;
import org.eclipse.nebula.widgets.nattable.dataset.fixture.data.RowDataListFixture;
import org.eclipse.nebula.widgets.nattable.examples.AbstractNatExample;
import org.eclipse.nebula.widgets.nattable.examples.PersistentNatExampleWrapper;
import org.eclipse.nebula.widgets.nattable.examples.fixtures.GlazedListsGridLayer;
import org.eclipse.nebula.widgets.nattable.examples.runner.StandaloneNatExampleRunner;
import org.eclipse.nebula.widgets.nattable.layer.AbstractLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.cell.ColumnOverrideLabelAccumulator;
import org.eclipse.nebula.widgets.nattable.layer.cell.IConfigLabelAccumulator;
import org.eclipse.nebula.widgets.nattable.persistence.command.DisplayPersistenceDialogCommandHandler;
import org.eclipse.nebula.widgets.nattable.selection.config.DefaultSelectionStyleConfiguration;
import org.eclipse.nebula.widgets.nattable.sort.SortConfigAttributes;
import org.eclipse.nebula.widgets.nattable.sort.config.SingleClickSortConfiguration;
import org.eclipse.nebula.widgets.nattable.ui.menu.HeaderMenuConfiguration;
import org.eclipse.nebula.widgets.nattable.ui.menu.PopupMenuBuilder;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class SortableGridExample
extends AbstractNatExample {
    private static final String CUSTOM_COMPARATOR_LABEL = "customComparatorLabel";
    protected static final String NO_SORT_LABEL = "noSortLabel";
    private TransformedList<RowDataFixture, RowDataFixture> rowObjectsGlazedList;
    private NatTable nattable;

    public static void main(String[] args) {
        StandaloneNatExampleRunner.run(700, 400, new PersistentNatExampleWrapper(new SortableGridExample()));
    }

    @Override
    public String getDescription() {
        return "Grid demonstrates sorting moving data.\n\nFeatures:\nThe contents of the grid are kept in sorted order as the rows are added/removed.\nCustom comparators can be applied to each column.\nIgnorecase comparator applied to the 'Rating' column.\nSorting can be turned off on the selective columns.\n'Ask price' field is not sortable.\n\nKey bindings:\nSort by left clicking on the column header.\nAdd columns to the existing sort by (Alt. + left click) on the column header\n\nTechnical information:\nThe default implementation uses GlazedLists to sort the backing data source.";
    }

    @Override
    public Control createExampleControl(Composite parent) {
        EventList eventList = GlazedLists.eventList((Collection)RowDataListFixture.getList());
        this.rowObjectsGlazedList = GlazedLists.threadSafeList((EventList)eventList);
        ConfigRegistry configRegistry = new ConfigRegistry();
        GlazedListsGridLayer glazedListsGridLayer = new GlazedListsGridLayer(this.rowObjectsGlazedList, RowDataListFixture.getPropertyNames(), RowDataListFixture.getPropertyToLabelMap(), (IConfigRegistry)configRegistry);
        this.nattable = new NatTable(parent, glazedListsGridLayer, false);
        this.nattable.setConfigRegistry((IConfigRegistry)configRegistry);
        this.nattable.addConfiguration((IConfiguration)new DefaultNatTableStyleConfiguration());
        this.nattable.addConfiguration((IConfiguration)new SingleClickSortConfiguration());
        this.nattable.addConfiguration(this.getCustomComparatorConfiguration((AbstractLayer)glazedListsGridLayer.getColumnHeaderLayerStack().getDataLayer()));
        this.nattable.addConfiguration((IConfiguration)new DefaultSelectionStyleConfiguration());
        this.nattable.addConfiguration((IConfiguration)new HeaderMenuConfiguration(this.nattable){

            protected PopupMenuBuilder createColumnHeaderMenu(NatTable natTable) {
                return super.createColumnHeaderMenu(natTable).withStateManagerMenuItemProvider();
            }
        });
        this.nattable.configure();
        glazedListsGridLayer.registerCommandHandler((ILayerCommandHandler)new DisplayPersistenceDialogCommandHandler(this.nattable));
        return this.nattable;
    }

    private IConfiguration getCustomComparatorConfiguration(final AbstractLayer columnHeaderDataLayer) {
        return new AbstractRegistryConfiguration(){

            public void configureRegistry(IConfigRegistry configRegistry) {
                ColumnOverrideLabelAccumulator labelAccumulator = new ColumnOverrideLabelAccumulator((ILayer)columnHeaderDataLayer);
                columnHeaderDataLayer.setConfigLabelAccumulator((IConfigLabelAccumulator)labelAccumulator);
                labelAccumulator.registerColumnOverrides(RowDataListFixture.getColumnIndexOfProperty((String)"rating"), new String[]{SortableGridExample.CUSTOM_COMPARATOR_LABEL});
                labelAccumulator.registerColumnOverrides(RowDataListFixture.getColumnIndexOfProperty((String)"ask_price"), new String[]{SortableGridExample.NO_SORT_LABEL});
                configRegistry.registerConfigAttribute(SortConfigAttributes.SORT_COMPARATOR, (Object)SortableGridExample.this.getCustomComparator(), "NORMAL", SortableGridExample.CUSTOM_COMPARATOR_LABEL);
                configRegistry.registerConfigAttribute(SortConfigAttributes.SORT_COMPARATOR, (Object)new NullComparator(), "NORMAL", SortableGridExample.NO_SORT_LABEL);
            }
        };
    }

    private Comparator<?> getCustomComparator() {
        return new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareToIgnoreCase(o2);
            }
        };
    }
}

