/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.examples.examples._120_Selection;

import java.io.Serializable;
import java.util.Collection;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.config.DefaultNatTableStyleConfiguration;
import org.eclipse.nebula.widgets.nattable.config.IConfiguration;
import org.eclipse.nebula.widgets.nattable.data.IRowIdAccessor;
import org.eclipse.nebula.widgets.nattable.dataset.fixture.data.RowDataFixture;
import org.eclipse.nebula.widgets.nattable.examples.AbstractNatExample;
import org.eclipse.nebula.widgets.nattable.examples.fixtures.SelectionExampleGridLayer;
import org.eclipse.nebula.widgets.nattable.examples.runner.StandaloneNatExampleRunner;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayerListener;
import org.eclipse.nebula.widgets.nattable.layer.event.ILayerEvent;
import org.eclipse.nebula.widgets.nattable.selection.ISelectionModel;
import org.eclipse.nebula.widgets.nattable.selection.RowSelectionModel;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.selection.config.DefaultSelectionStyleConfiguration;
import org.eclipse.nebula.widgets.nattable.selection.config.RowOnlySelectionBindings;
import org.eclipse.nebula.widgets.nattable.selection.config.RowOnlySelectionConfiguration;
import org.eclipse.nebula.widgets.nattable.selection.event.CellSelectionEvent;
import org.eclipse.nebula.widgets.nattable.selection.event.ColumnSelectionEvent;
import org.eclipse.nebula.widgets.nattable.selection.event.RowSelectionEvent;
import org.eclipse.nebula.widgets.nattable.ui.menu.HeaderMenuConfiguration;
import org.eclipse.nebula.widgets.nattable.util.ObjectUtils;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class Selection_events
extends AbstractNatExample {
    private NatTable nattable;
    private SelectionExampleGridLayer gridLayer;

    public static void main(String[] args) throws Exception {
        StandaloneNatExampleRunner.run(new Selection_events());
    }

    @Override
    public String getDescription() {
        return "Row, row header, column, column header and cell selection is built into the table by default. Events are fired by the tables when any selection occurs. These can be hooked up to trigger business actions as required.";
    }

    @Override
    public Control createExampleControl(Composite parent) {
        this.gridLayer = new SelectionExampleGridLayer();
        this.nattable = new NatTable(parent, (ILayer)this.gridLayer, false);
        this.nattable.addConfiguration((IConfiguration)new DefaultNatTableStyleConfiguration());
        this.nattable.addConfiguration((IConfiguration)new HeaderMenuConfiguration(this.nattable));
        this.nattable.addConfiguration((IConfiguration)new DefaultSelectionStyleConfiguration());
        SelectionLayer selectionLayer = this.gridLayer.getSelectionLayer();
        selectionLayer.setSelectionModel((ISelectionModel)new RowSelectionModel(selectionLayer, this.gridLayer.getBodyDataProvider(), (IRowIdAccessor)new IRowIdAccessor<RowDataFixture>(){

            public Serializable getRowId(RowDataFixture rowObject) {
                return rowObject.getSecurity_id();
            }
        }));
        selectionLayer.addConfiguration((IConfiguration)new RowOnlySelectionConfiguration());
        this.nattable.addConfiguration((IConfiguration)new RowOnlySelectionBindings());
        this.nattable.configure();
        this.addCustomSelectionBehaviour();
        parent.setLayout((Layout)new GridLayout(1, true));
        this.nattable.setLayoutData((Object)new GridData(4, 4, true, true));
        this.setupTextArea(parent);
        return this.nattable;
    }

    private void addCustomSelectionBehaviour() {
        this.nattable.addLayerListener(new ILayerListener(){

            public void handleLayerEvent(ILayerEvent event) {
                if (event instanceof CellSelectionEvent) {
                    CellSelectionEvent cellEvent = (CellSelectionEvent)event;
                    Selection_events.this.log("Selected cell: [" + cellEvent.getRowPosition() + ", " + cellEvent.getColumnPosition() + "], " + Selection_events.this.nattable.getDataValueByPosition(cellEvent.getColumnPosition(), cellEvent.getRowPosition()));
                }
            }
        });
        this.nattable.addLayerListener(new ILayerListener(){

            public void handleLayerEvent(ILayerEvent event) {
                if (event instanceof RowSelectionEvent) {
                    RowSelectionEvent rowEvent = (RowSelectionEvent)event;
                    Selection_events.this.log("Selected Row: " + ObjectUtils.toString((Collection)rowEvent.getRowPositionRanges()));
                }
            }
        });
        this.nattable.addLayerListener(new ILayerListener(){

            public void handleLayerEvent(ILayerEvent event) {
                if (event instanceof ColumnSelectionEvent) {
                    ColumnSelectionEvent columnEvent = (ColumnSelectionEvent)event;
                    Selection_events.this.log("Selected Column: " + columnEvent.getColumnPositionRanges());
                }
            }
        });
    }
}

