/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.examples.examples._110_Editing;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.config.DefaultNatTableStyleConfiguration;
import org.eclipse.nebula.widgets.nattable.config.IConfiguration;
import org.eclipse.nebula.widgets.nattable.dataset.NumberValues;
import org.eclipse.nebula.widgets.nattable.examples.AbstractNatExample;
import org.eclipse.nebula.widgets.nattable.examples.examples._110_Editing.TableEditConfiguration;
import org.eclipse.nebula.widgets.nattable.examples.runner.StandaloneNatExampleRunner;
import org.eclipse.nebula.widgets.nattable.grid.layer.DefaultGridLayer;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.cell.ColumnOverrideLabelAccumulator;
import org.eclipse.nebula.widgets.nattable.layer.cell.IConfigLabelAccumulator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class EditErrorHandlingExample
extends AbstractNatExample {
    public static String COLUMN_ONE_LABEL = "ColumnOneLabel";
    public static String COLUMN_TWO_LABEL = "ColumnTwoLabel";
    public static String COLUMN_THREE_LABEL = "ColumnThreeLabel";
    public static String COLUMN_FOUR_LABEL = "ColumnFourLabel";
    public static String COLUMN_FIVE_LABEL = "ColumnFiveLabel";
    public static String COLUMN_SIX_LABEL = "ColumnSixLabel";
    public static String COLUMN_SEVEN_LABEL = "ColumnSevenLabel";
    public static String COLUMN_EIGHT_LABEL = "ColumnEightLabel";
    public static String COLUMN_NINE_LABEL = "ColumnNineLabel";

    public static void main(String[] args) throws Exception {
        StandaloneNatExampleRunner.run(1024, 400, new EditErrorHandlingExample());
    }

    @Override
    public String getDescription() {
        return "This example demonstrates the modified edit behaviour of the NatTable using error handling strategies. The columns are configured differently for handling conversion and validation errors:\n\n- Column 1:\nNo error handling for conversion and validation failures registered\n\n- Column 2:\nDialog error handling for conversion failures registered\nNo error handling for validation failures registered\n\n- Column 3:\nNo error handling for conversion failures registered\nDialog error handling for validation failures registered\n\n- Column 4:\nDialog error handling for conversion failures registered\nDialog error handling for validation failures registered\n\n- Column 5:\nWill simulate to throw an IllegalArgumentException with default configuration on validation to show that other exceptions than the defined ones for conversion and validation failures are logged completely.";
    }

    @Override
    public Control createExampleControl(Composite parent) {
        String[] propertyNames = new String[]{"columnOneNumber", "columnTwoNumber", "columnThreeNumber", "columnFourNumber", "columnFiveNumber"};
        HashMap<String, String> propertyToLabelMap = new HashMap<String, String>();
        propertyToLabelMap.put("columnOneNumber", "Column 1");
        propertyToLabelMap.put("columnTwoNumber", "Column 2");
        propertyToLabelMap.put("columnThreeNumber", "Column 3");
        propertyToLabelMap.put("columnFourNumber", "Column 4");
        propertyToLabelMap.put("columnFiveNumber", "Column 5");
        DefaultGridLayer gridLayer = new DefaultGridLayer(this.createNumberValuesList(), propertyNames, propertyToLabelMap);
        DataLayer bodyDataLayer = (DataLayer)gridLayer.getBodyDataLayer();
        ColumnOverrideLabelAccumulator columnLabelAccumulator = new ColumnOverrideLabelAccumulator((ILayer)bodyDataLayer);
        bodyDataLayer.setConfigLabelAccumulator((IConfigLabelAccumulator)columnLabelAccumulator);
        this.registerColumnLabels(columnLabelAccumulator);
        NatTable natTable = new NatTable(parent, (ILayer)gridLayer, false);
        natTable.addConfiguration((IConfiguration)new DefaultNatTableStyleConfiguration());
        natTable.addConfiguration((IConfiguration)new TableEditConfiguration());
        natTable.configure();
        return natTable;
    }

    private List<NumberValues> createNumberValuesList() {
        ArrayList<NumberValues> result = new ArrayList<NumberValues>();
        NumberValues nv = null;
        int i = 0;
        while (i < 10) {
            nv = new NumberValues();
            nv.setColumnOneNumber(11111);
            nv.setColumnTwoNumber(22222);
            nv.setColumnThreeNumber(33333);
            nv.setColumnFourNumber(44444);
            nv.setColumnFiveNumber(55555);
            nv.setColumnSixNumber(66666);
            nv.setColumnSevenNumber(77777);
            nv.setColumnEightNumber(88888);
            nv.setColumnNineNumber(99999);
            result.add(nv);
            ++i;
        }
        return result;
    }

    private void registerColumnLabels(ColumnOverrideLabelAccumulator columnLabelAccumulator) {
        columnLabelAccumulator.registerColumnOverrides(0, new String[]{COLUMN_ONE_LABEL});
        columnLabelAccumulator.registerColumnOverrides(1, new String[]{COLUMN_TWO_LABEL});
        columnLabelAccumulator.registerColumnOverrides(2, new String[]{COLUMN_THREE_LABEL});
        columnLabelAccumulator.registerColumnOverrides(3, new String[]{COLUMN_FOUR_LABEL});
        columnLabelAccumulator.registerColumnOverrides(4, new String[]{COLUMN_FIVE_LABEL});
    }
}

