/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.examples.examples._101_Data;

import java.util.ArrayList;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.data.IColumnAccessor;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.data.ListDataProvider;
import org.eclipse.nebula.widgets.nattable.data.ReflectiveColumnPropertyAccessor;
import org.eclipse.nebula.widgets.nattable.examples.AbstractNatExample;
import org.eclipse.nebula.widgets.nattable.examples.runner.StandaloneNatExampleRunner;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class Using_the_ListDataProvider
extends AbstractNatExample {
    public static void main(String[] args) throws Exception {
        StandaloneNatExampleRunner.run(new Using_the_ListDataProvider());
    }

    @Override
    public String getDescription() {
        return "NatTable provides a useful class that implements the common case of implementing an IDataProvider based on a List. This example shows how to use it.\n\nIn this case the ListDataProvider is given an array of property names and uses reflection to retrieve the property values for each column. The ListDataProvider can also be given an instance of an IColumnPropertyAccessor to enable it to retrieve column values from a row object.";
    }

    @Override
    public Control createExampleControl(Composite parent) {
        ArrayList<Person> myList = new ArrayList<Person>();
        myList.add(new Person("Homer", "Simpson", "Sargeant", 1234567890L));
        myList.add(new Person("Waylon", "Smithers", "Admiral", 6666666666L));
        myList.add(new Person("Bart", "Smithers", "General", 9125798342L));
        myList.add(new Person("Nelson", "Muntz", "Private", 1L));
        myList.add(new Person("John", "Frink", "Lieutenant", 3141592654L));
        String[] propertyNames = new String[]{"firstName", "lastName", "rank", "serialNumber"};
        ReflectiveColumnPropertyAccessor columnPropertyAccessor = new ReflectiveColumnPropertyAccessor(propertyNames);
        ListDataProvider listDataProvider = new ListDataProvider(myList, (IColumnAccessor)columnPropertyAccessor);
        DataLayer layer = new DataLayer((IDataProvider)listDataProvider);
        return new NatTable(parent, (ILayer)layer);
    }

    public class Person {
        private String firstName;
        private String lastName;
        private String rank;
        private long serialNumber;

        public Person(String firstName, String lastName, String rank, long serialNumber) {
            this.firstName = firstName;
            this.lastName = lastName;
            this.rank = rank;
            this.serialNumber = serialNumber;
        }

        public String getFirstName() {
            return this.firstName;
        }

        public String getLastName() {
            return this.lastName;
        }

        public String getRank() {
            return this.rank;
        }

        public long getSerialNumber() {
            return this.serialNumber;
        }
    }
}

