/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.examples.examples._101_Data;

import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.config.ConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.DefaultNatTableStyleConfiguration;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.IConfiguration;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.examples.AbstractNatExample;
import org.eclipse.nebula.widgets.nattable.examples.runner.StandaloneNatExampleRunner;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.summaryrow.DefaultSummaryRowConfiguration;
import org.eclipse.nebula.widgets.nattable.summaryrow.ISummaryProvider;
import org.eclipse.nebula.widgets.nattable.summaryrow.SummaryRowConfigAttributes;
import org.eclipse.nebula.widgets.nattable.summaryrow.SummaryRowLayer;
import org.eclipse.nebula.widgets.nattable.summaryrow.SummationSummaryProvider;
import org.eclipse.nebula.widgets.nattable.util.GUIHelper;
import org.eclipse.nebula.widgets.nattable.viewport.ViewportLayer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class Creating_a_summary_row
extends AbstractNatExample {
    private IDataProvider myDataProvider;

    public static void main(String[] args) throws Exception {
        StandaloneNatExampleRunner.run(600, 400, new Creating_a_summary_row());
    }

    @Override
    public String getDescription() {
        return "Grid demonstrates adding a Summary row at the end of the table.\n\nFeatures\n\tDifferent style can be applied to the whole row\n\tDifferent style can be applied to the individual cells in the summary row\n\tPlug-in your own summary formulas via ISummaryProvider interface (Default is summation)";
    }

    @Override
    public Control createExampleControl(Composite parent) {
        this.myDataProvider = new IDataProvider(){

            public int getColumnCount() {
                return 4;
            }

            public int getRowCount() {
                return 10;
            }

            public Object getDataValue(int columnIndex, int rowIndex) {
                if (columnIndex >= this.getColumnCount() || rowIndex >= this.getRowCount()) {
                    throw new RuntimeException("Data value requested is out of bounds");
                }
                return columnIndex % 2 == 0 ? Integer.valueOf(10) : "Apple";
            }

            public void setDataValue(int columnIndex, int rowIndex, Object newValue) {
            }
        };
        ConfigRegistry configRegistry = new ConfigRegistry();
        DataLayer dataLayer = new DataLayer(this.myDataProvider);
        SummaryRowLayer summaryRowLayer = new SummaryRowLayer((IUniqueIndexLayer)dataLayer, (IConfigRegistry)configRegistry, false);
        ViewportLayer viewportLayer = new ViewportLayer((IUniqueIndexLayer)summaryRowLayer);
        NatTable natTable = new NatTable(parent, (ILayer)viewportLayer, false);
        natTable.addConfiguration((IConfiguration)new MySummaryRowConfig(this.myDataProvider));
        natTable.addConfiguration((IConfiguration)new DefaultNatTableStyleConfiguration());
        natTable.setConfigRegistry((IConfigRegistry)configRegistry);
        natTable.configure();
        return natTable;
    }

    class AverageSummaryProvider
    implements ISummaryProvider {
        AverageSummaryProvider() {
        }

        public Object summarize(int columnIndex) {
            int total = 0;
            int rowCount = Creating_a_summary_row.this.myDataProvider.getRowCount();
            int rowIndex = 0;
            while (rowIndex < rowCount) {
                Object dataValue = Creating_a_summary_row.this.myDataProvider.getDataValue(columnIndex, rowIndex);
                total += Integer.parseInt(dataValue.toString());
                ++rowIndex;
            }
            return "Average: " + total / rowCount;
        }
    }

    class MySummaryRowConfig
    extends DefaultSummaryRowConfiguration {
        private final IDataProvider myDataProvider;

        public MySummaryRowConfig(IDataProvider myDataProvider) {
            this.myDataProvider = myDataProvider;
            this.summaryRowBgColor = GUIHelper.COLOR_BLUE;
            this.summaryRowFgColor = GUIHelper.COLOR_WHITE;
        }

        public void addSummaryProviderConfig(IConfigRegistry configRegistry) {
            configRegistry.registerConfigAttribute(SummaryRowConfigAttributes.SUMMARY_PROVIDER, (Object)new SummationSummaryProvider(this.myDataProvider), "NORMAL", "SummaryRow");
            configRegistry.registerConfigAttribute(SummaryRowConfigAttributes.SUMMARY_PROVIDER, (Object)new AverageSummaryProvider(), "NORMAL", "SummaryColumn_2");
        }
    }
}

