/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.examples._500_Layers._505_Selection;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommandHandler;
import org.eclipse.nebula.widgets.nattable.config.AbstractRegistryConfiguration;
import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.IConfiguration;
import org.eclipse.nebula.widgets.nattable.config.IEditableRule;
import org.eclipse.nebula.widgets.nattable.data.IColumnAccessor;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.data.ListDataProvider;
import org.eclipse.nebula.widgets.nattable.data.ReflectiveColumnPropertyAccessor;
import org.eclipse.nebula.widgets.nattable.data.convert.DefaultBooleanDisplayConverter;
import org.eclipse.nebula.widgets.nattable.data.convert.DefaultDateDisplayConverter;
import org.eclipse.nebula.widgets.nattable.dataset.person.PersonService;
import org.eclipse.nebula.widgets.nattable.edit.EditConfigAttributes;
import org.eclipse.nebula.widgets.nattable.edit.config.DefaultEditBindings;
import org.eclipse.nebula.widgets.nattable.edit.config.DefaultEditConfiguration;
import org.eclipse.nebula.widgets.nattable.edit.editor.CheckBoxCellEditor;
import org.eclipse.nebula.widgets.nattable.edit.editor.DateCellEditor;
import org.eclipse.nebula.widgets.nattable.edit.editor.TextCellEditor;
import org.eclipse.nebula.widgets.nattable.examples.AbstractNatExample;
import org.eclipse.nebula.widgets.nattable.examples.runner.StandaloneNatExampleRunner;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.cell.ColumnOverrideLabelAccumulator;
import org.eclipse.nebula.widgets.nattable.layer.cell.IConfigLabelAccumulator;
import org.eclipse.nebula.widgets.nattable.painter.cell.CheckBoxPainter;
import org.eclipse.nebula.widgets.nattable.selection.EditTraversalStrategy;
import org.eclipse.nebula.widgets.nattable.selection.ITraversalStrategy;
import org.eclipse.nebula.widgets.nattable.selection.MoveCellSelectionCommandHandler;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.viewport.ViewportLayer;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class _5055_SelectionTraversalExample
extends AbstractNatExample {
    public static String COLUMN_ONE_LABEL = "ColumnOneLabel";
    public static String COLUMN_TWO_LABEL = "ColumnTwoLabel";
    public static String COLUMN_THREE_LABEL = "ColumnThreeLabel";
    public static String COLUMN_FOUR_LABEL = "ColumnFourLabel";
    public static String COLUMN_FIVE_LABEL = "ColumnFiveLabel";

    public static void main(String[] args) throws Exception {
        StandaloneNatExampleRunner.run(600, 600, new _5055_SelectionTraversalExample());
    }

    @Override
    public String getDescription() {
        return "This example shows different traversal strategy configurations.\n\n1. AXIS traversal - traversal happens on one axis without cycle, default\n2. AXIS CYCLE traversal - traversal happens on one axis where moving over a border means to move to the beginning of the same row/column\n3. TABLE traversal - traversal happens on table basis where moving over a border means to move to the beginning of the next/previous row/column\n4. TABLE CYCLE traversal - traversal happens on table basis where moving over a border means to move to the beginning of the next/previous row/column, but moving over the table end/beginning moves to the opposite\n5. mixed - this shows how to mix traversal strategies for left/right and up/down movements\n6. editable traversal - shows how to use the editable traversal strategy.\nThe last three columns are not editable, and the traversal will always search for the next editable cell.";
    }

    @Override
    public Control createExampleControl(Composite parent) {
        String[] propertyNames = new String[]{"firstName", "lastName", "gender", "married", "birthday"};
        ReflectiveColumnPropertyAccessor columnPropertyAccessor = new ReflectiveColumnPropertyAccessor(propertyNames);
        ListDataProvider bodyDataProvider = new ListDataProvider(PersonService.getPersons((int)3), (IColumnAccessor)columnPropertyAccessor);
        Composite panel = new Composite(parent, 0);
        panel.setLayout((Layout)new GridLayout());
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)panel);
        DataLayer bodyDataLayer = new DataLayer((IDataProvider)bodyDataProvider);
        SelectionLayer selectionLayer = new SelectionLayer((IUniqueIndexLayer)bodyDataLayer);
        ViewportLayer viewportLayer = new ViewportLayer((IUniqueIndexLayer)selectionLayer);
        viewportLayer.setRegionName("BODY");
        NatTable natTable = new NatTable(panel, (ILayer)viewportLayer);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)natTable);
        bodyDataLayer = new DataLayer((IDataProvider)bodyDataProvider);
        selectionLayer = new SelectionLayer((IUniqueIndexLayer)bodyDataLayer);
        viewportLayer = new ViewportLayer((IUniqueIndexLayer)selectionLayer);
        viewportLayer.setRegionName("BODY");
        viewportLayer.registerCommandHandler((ILayerCommandHandler)new MoveCellSelectionCommandHandler(selectionLayer, ITraversalStrategy.AXIS_CYCLE_TRAVERSAL_STRATEGY));
        natTable = new NatTable(panel, (ILayer)viewportLayer);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)natTable);
        bodyDataLayer = new DataLayer((IDataProvider)bodyDataProvider);
        selectionLayer = new SelectionLayer((IUniqueIndexLayer)bodyDataLayer);
        viewportLayer = new ViewportLayer((IUniqueIndexLayer)selectionLayer);
        viewportLayer.setRegionName("BODY");
        viewportLayer.registerCommandHandler((ILayerCommandHandler)new MoveCellSelectionCommandHandler(selectionLayer, ITraversalStrategy.TABLE_TRAVERSAL_STRATEGY));
        natTable = new NatTable(panel, (ILayer)viewportLayer);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)natTable);
        bodyDataLayer = new DataLayer((IDataProvider)bodyDataProvider);
        selectionLayer = new SelectionLayer((IUniqueIndexLayer)bodyDataLayer);
        viewportLayer = new ViewportLayer((IUniqueIndexLayer)selectionLayer);
        viewportLayer.setRegionName("BODY");
        viewportLayer.registerCommandHandler((ILayerCommandHandler)new MoveCellSelectionCommandHandler(selectionLayer, ITraversalStrategy.TABLE_CYCLE_TRAVERSAL_STRATEGY));
        natTable = new NatTable(panel, (ILayer)viewportLayer);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)natTable);
        bodyDataLayer = new DataLayer((IDataProvider)bodyDataProvider);
        selectionLayer = new SelectionLayer((IUniqueIndexLayer)bodyDataLayer);
        viewportLayer = new ViewportLayer((IUniqueIndexLayer)selectionLayer);
        viewportLayer.setRegionName("BODY");
        viewportLayer.registerCommandHandler((ILayerCommandHandler)new MoveCellSelectionCommandHandler(selectionLayer, ITraversalStrategy.TABLE_CYCLE_TRAVERSAL_STRATEGY, ITraversalStrategy.AXIS_CYCLE_TRAVERSAL_STRATEGY));
        natTable = new NatTable(panel, (ILayer)viewportLayer);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)natTable);
        bodyDataLayer = new DataLayer((IDataProvider)bodyDataProvider);
        selectionLayer = new SelectionLayer((IUniqueIndexLayer)bodyDataLayer);
        viewportLayer = new ViewportLayer((IUniqueIndexLayer)selectionLayer);
        viewportLayer.setRegionName("BODY");
        ColumnOverrideLabelAccumulator columnLabelAccumulator = new ColumnOverrideLabelAccumulator((ILayer)bodyDataLayer);
        bodyDataLayer.setConfigLabelAccumulator((IConfigLabelAccumulator)columnLabelAccumulator);
        this.registerColumnLabels(columnLabelAccumulator);
        viewportLayer.addConfiguration((IConfiguration)new DefaultEditBindings());
        viewportLayer.addConfiguration((IConfiguration)new DefaultEditConfiguration());
        viewportLayer.addConfiguration((IConfiguration)new EditorConfiguration());
        natTable = new NatTable(panel, (ILayer)viewportLayer);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)natTable);
        viewportLayer.registerCommandHandler((ILayerCommandHandler)new MoveCellSelectionCommandHandler(selectionLayer, (ITraversalStrategy)new EditTraversalStrategy(ITraversalStrategy.TABLE_CYCLE_TRAVERSAL_STRATEGY, natTable), (ITraversalStrategy)new EditTraversalStrategy(ITraversalStrategy.AXIS_CYCLE_TRAVERSAL_STRATEGY, natTable)));
        return panel;
    }

    private void registerColumnLabels(ColumnOverrideLabelAccumulator columnLabelAccumulator) {
        columnLabelAccumulator.registerColumnOverrides(0, new String[]{COLUMN_ONE_LABEL});
        columnLabelAccumulator.registerColumnOverrides(1, new String[]{COLUMN_TWO_LABEL});
        columnLabelAccumulator.registerColumnOverrides(2, new String[]{COLUMN_THREE_LABEL});
        columnLabelAccumulator.registerColumnOverrides(3, new String[]{COLUMN_FOUR_LABEL});
        columnLabelAccumulator.registerColumnOverrides(4, new String[]{COLUMN_FIVE_LABEL});
    }

    class EditorConfiguration
    extends AbstractRegistryConfiguration {
        EditorConfiguration() {
        }

        public void configureRegistry(IConfigRegistry configRegistry) {
            configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITABLE_RULE, (Object)IEditableRule.ALWAYS_EDITABLE);
            configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITABLE_RULE, (Object)IEditableRule.NEVER_EDITABLE, "EDIT", COLUMN_THREE_LABEL);
            configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITABLE_RULE, (Object)IEditableRule.NEVER_EDITABLE, "EDIT", COLUMN_FOUR_LABEL);
            configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITABLE_RULE, (Object)IEditableRule.NEVER_EDITABLE, "EDIT", COLUMN_FIVE_LABEL);
            configRegistry.registerConfigAttribute(EditConfigAttributes.OPEN_ADJACENT_EDITOR, (Object)Boolean.TRUE);
            this.registerEditors(configRegistry);
        }

        private void registerEditors(IConfigRegistry configRegistry) {
            configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITOR, (Object)new TextCellEditor(true, true), "NORMAL", COLUMN_ONE_LABEL);
            configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITOR, (Object)new TextCellEditor(true, true), "NORMAL", COLUMN_TWO_LABEL);
            this.registerColumnFourCheckbox(configRegistry);
            this.registerColumnFiveDateEditor(configRegistry);
        }

        private void registerColumnFourCheckbox(IConfigRegistry configRegistry) {
            configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITOR, (Object)new CheckBoxCellEditor(), "EDIT", COLUMN_FOUR_LABEL);
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, (Object)new CheckBoxPainter(), "NORMAL", COLUMN_FOUR_LABEL);
            configRegistry.registerConfigAttribute(CellConfigAttributes.DISPLAY_CONVERTER, (Object)new DefaultBooleanDisplayConverter(), "NORMAL", COLUMN_FOUR_LABEL);
        }

        private void registerColumnFiveDateEditor(IConfigRegistry configRegistry) {
            configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITOR, (Object)new DateCellEditor(), "EDIT", COLUMN_FIVE_LABEL);
            DateFormat formatter = DateFormat.getDateInstance(2, Locale.getDefault());
            String pattern = ((SimpleDateFormat)formatter).toPattern();
            configRegistry.registerConfigAttribute(CellConfigAttributes.DISPLAY_CONVERTER, (Object)new DefaultDateDisplayConverter(pattern), "NORMAL", COLUMN_FIVE_LABEL);
        }
    }
}

