/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.examples._500_Layers._505_Selection;

import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.coordinate.Range;
import org.eclipse.nebula.widgets.nattable.data.IColumnAccessor;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.data.IRowDataProvider;
import org.eclipse.nebula.widgets.nattable.data.ListDataProvider;
import org.eclipse.nebula.widgets.nattable.data.ReflectiveColumnPropertyAccessor;
import org.eclipse.nebula.widgets.nattable.dataset.person.Person;
import org.eclipse.nebula.widgets.nattable.dataset.person.PersonService;
import org.eclipse.nebula.widgets.nattable.examples.AbstractNatExample;
import org.eclipse.nebula.widgets.nattable.examples.runner.StandaloneNatExampleRunner;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultColumnHeaderDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultCornerDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultRowHeaderDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.layer.ColumnHeaderLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.CornerLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.DefaultRowHeaderDataLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.GridLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.RowHeaderLayer;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayerListener;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.event.ILayerEvent;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.selection.event.CellSelectionEvent;
import org.eclipse.nebula.widgets.nattable.selection.event.ColumnSelectionEvent;
import org.eclipse.nebula.widgets.nattable.selection.event.RowSelectionEvent;
import org.eclipse.nebula.widgets.nattable.viewport.ViewportLayer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class _5053_SelectionEventsExample
extends AbstractNatExample {
    public static void main(String[] args) throws Exception {
        StandaloneNatExampleRunner.run(600, 400, new _5053_SelectionEventsExample());
    }

    @Override
    public String getDescription() {
        return "This example shows custom selection event handling in a NatTable grid composition. There is different handling for cell, column and row selection.";
    }

    @Override
    public Control createExampleControl(Composite parent) {
        String[] propertyNames = new String[]{"firstName", "lastName", "gender", "married", "birthday"};
        HashMap<String, String> propertyToLabelMap = new HashMap<String, String>();
        propertyToLabelMap.put("firstName", "Firstname");
        propertyToLabelMap.put("lastName", "Lastname");
        propertyToLabelMap.put("gender", "Gender");
        propertyToLabelMap.put("married", "Married");
        propertyToLabelMap.put("birthday", "Birthday");
        ReflectiveColumnPropertyAccessor columnPropertyAccessor = new ReflectiveColumnPropertyAccessor(propertyNames);
        List data = PersonService.getPersons((int)10);
        ListDataProvider bodyDataProvider = new ListDataProvider(data, (IColumnAccessor)columnPropertyAccessor);
        DataLayer bodyDataLayer = new DataLayer((IDataProvider)bodyDataProvider);
        final SelectionLayer selectionLayer = new SelectionLayer((IUniqueIndexLayer)bodyDataLayer);
        ViewportLayer viewportLayer = new ViewportLayer((IUniqueIndexLayer)selectionLayer);
        DefaultColumnHeaderDataProvider columnHeaderDataProvider = new DefaultColumnHeaderDataProvider(propertyNames, propertyToLabelMap);
        ColumnHeaderLayer columnHeaderLayer = new ColumnHeaderLayer((IUniqueIndexLayer)new DataLayer((IDataProvider)columnHeaderDataProvider), (ILayer)viewportLayer, selectionLayer);
        DefaultRowHeaderDataProvider rowHeaderDataProvider = new DefaultRowHeaderDataProvider((IDataProvider)bodyDataProvider);
        RowHeaderLayer rowHeaderLayer = new RowHeaderLayer((IUniqueIndexLayer)new DefaultRowHeaderDataLayer((IDataProvider)new DefaultRowHeaderDataProvider((IDataProvider)bodyDataProvider)), (ILayer)viewportLayer, selectionLayer);
        CornerLayer cornerLayer = new CornerLayer((IUniqueIndexLayer)new DataLayer((IDataProvider)new DefaultCornerDataProvider((IDataProvider)columnHeaderDataProvider, (IDataProvider)rowHeaderDataProvider)), (ILayer)rowHeaderLayer, (ILayer)columnHeaderLayer);
        GridLayer gridLayer = new GridLayer((ILayer)viewportLayer, (ILayer)columnHeaderLayer, (ILayer)rowHeaderLayer, (ILayer)cornerLayer);
        final NatTable natTable = new NatTable(parent, (ILayer)gridLayer);
        natTable.addLayerListener(new ILayerListener((IRowDataProvider)bodyDataProvider){
            private final /* synthetic */ IRowDataProvider val$bodyDataProvider;
            {
                this.val$bodyDataProvider = iRowDataProvider;
            }

            public void handleLayerEvent(ILayerEvent event) {
                if (event instanceof CellSelectionEvent) {
                    CellSelectionEvent cellEvent = (CellSelectionEvent)event;
                    _5053_SelectionEventsExample.this.log("Selected cell: [" + cellEvent.getRowPosition() + ", " + cellEvent.getColumnPosition() + "], " + natTable.getDataValueByPosition(cellEvent.getColumnPosition(), cellEvent.getRowPosition()));
                } else if (event instanceof ColumnSelectionEvent) {
                    ColumnSelectionEvent columnEvent = (ColumnSelectionEvent)event;
                    _5053_SelectionEventsExample.this.log("Selected Column: " + columnEvent.getColumnPositionRanges());
                } else if (event instanceof RowSelectionEvent) {
                    Set selections = selectionLayer.getSelectedRowPositions();
                    StringBuilder builder = new StringBuilder("Selected Persons: ").append(selectionLayer.getSelectedRowPositions()).append("[");
                    for (Range r : selections) {
                        int i = r.start;
                        while (i < r.end) {
                            Person p = (Person)this.val$bodyDataProvider.getRowObject(i);
                            if (p != null) {
                                if (!builder.toString().endsWith("[")) {
                                    builder.append(", ");
                                }
                                builder.append(p.getFirstName()).append(" ").append(p.getLastName());
                            }
                            ++i;
                        }
                    }
                    builder.append("]");
                    _5053_SelectionEventsExample.this.log(builder.toString());
                }
            }
        });
        parent.setLayout((Layout)new GridLayout(1, true));
        natTable.setLayoutData((Object)new GridData(4, 4, true, true));
        this.setupTextArea(parent);
        return natTable;
    }
}

