/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.examples._400_Configuration._440_Editing;

import org.eclipse.nebula.widgets.nattable.config.AbstractRegistryConfiguration;
import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.IEditableRule;
import org.eclipse.nebula.widgets.nattable.data.convert.DefaultIntegerDisplayConverter;
import org.eclipse.nebula.widgets.nattable.data.validate.DataValidator;
import org.eclipse.nebula.widgets.nattable.data.validate.IDataValidator;
import org.eclipse.nebula.widgets.nattable.data.validate.ValidationFailedException;
import org.eclipse.nebula.widgets.nattable.edit.EditConfigAttributes;
import org.eclipse.nebula.widgets.nattable.edit.config.DialogErrorHandling;
import org.eclipse.nebula.widgets.nattable.examples._400_Configuration._440_Editing._446_EditErrorHandlingExample;
import org.eclipse.nebula.widgets.nattable.style.CellStyleAttributes;
import org.eclipse.nebula.widgets.nattable.style.Style;
import org.eclipse.nebula.widgets.nattable.util.GUIHelper;

class TableEditConfiguration
extends AbstractRegistryConfiguration {
    TableEditConfiguration() {
    }

    public void configureRegistry(IConfigRegistry configRegistry) {
        configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITABLE_RULE, (Object)IEditableRule.ALWAYS_EDITABLE);
        configRegistry.registerConfigAttribute(CellConfigAttributes.DISPLAY_CONVERTER, (Object)new DefaultIntegerDisplayConverter(), "NORMAL");
        configRegistry.registerConfigAttribute(CellConfigAttributes.DISPLAY_CONVERTER, (Object)new DefaultIntegerDisplayConverter(false), "EDIT");
        configRegistry.registerConfigAttribute(EditConfigAttributes.DATA_VALIDATOR, (Object)this.getExampleValidator(), "EDIT");
        configRegistry.registerConfigAttribute(EditConfigAttributes.DATA_VALIDATOR, (Object)this.getExceptionValidator(), "EDIT", _446_EditErrorHandlingExample.COLUMN_FIVE_LABEL);
        this.registerErrorHandlingStrategies(configRegistry);
        this.registerErrorHandlingStyles(configRegistry);
    }

    private void registerErrorHandlingStrategies(IConfigRegistry configRegistry) {
        configRegistry.registerConfigAttribute(EditConfigAttributes.CONVERSION_ERROR_HANDLER, (Object)new DialogErrorHandling(), "EDIT", _446_EditErrorHandlingExample.COLUMN_TWO_LABEL);
        configRegistry.registerConfigAttribute(EditConfigAttributes.VALIDATION_ERROR_HANDLER, (Object)new DialogErrorHandling(), "EDIT", _446_EditErrorHandlingExample.COLUMN_THREE_LABEL);
        configRegistry.registerConfigAttribute(EditConfigAttributes.CONVERSION_ERROR_HANDLER, (Object)new DialogErrorHandling(), "EDIT", _446_EditErrorHandlingExample.COLUMN_FOUR_LABEL);
        configRegistry.registerConfigAttribute(EditConfigAttributes.VALIDATION_ERROR_HANDLER, (Object)new DialogErrorHandling(), "EDIT", _446_EditErrorHandlingExample.COLUMN_FOUR_LABEL);
    }

    private void registerErrorHandlingStyles(IConfigRegistry configRegistry) {
        Style conversionErrorStyle = new Style();
        conversionErrorStyle.setAttributeValue(CellStyleAttributes.BACKGROUND_COLOR, (Object)GUIHelper.COLOR_RED);
        conversionErrorStyle.setAttributeValue(CellStyleAttributes.FOREGROUND_COLOR, (Object)GUIHelper.COLOR_WHITE);
        configRegistry.registerConfigAttribute(EditConfigAttributes.CONVERSION_ERROR_STYLE, (Object)conversionErrorStyle, "EDIT", _446_EditErrorHandlingExample.COLUMN_TWO_LABEL);
        Style validationErrorStyle = new Style();
        validationErrorStyle.setAttributeValue(CellStyleAttributes.BACKGROUND_COLOR, (Object)GUIHelper.COLOR_BLACK);
        validationErrorStyle.setAttributeValue(CellStyleAttributes.FOREGROUND_COLOR, (Object)GUIHelper.COLOR_WHITE);
        configRegistry.registerConfigAttribute(EditConfigAttributes.VALIDATION_ERROR_STYLE, (Object)validationErrorStyle, "EDIT", _446_EditErrorHandlingExample.COLUMN_TWO_LABEL);
    }

    private IDataValidator getExampleValidator() {
        return new DataValidator(){

            public boolean validate(int columnIndex, int rowIndex, Object newValue) {
                if (newValue instanceof Integer && (Integer)newValue > 10000) {
                    return true;
                }
                throw new ValidationFailedException("The value has to be bigger than 10000");
            }
        };
    }

    private IDataValidator getExceptionValidator() {
        return new DataValidator(){

            public boolean validate(int columnIndex, int rowIndex, Object newValue) {
                throw new IllegalArgumentException("This is an exception throwed because of missing constraint checks!");
            }
        };
    }
}

