/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.examples._400_Configuration;

import java.net.URL;
import java.util.HashMap;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.config.AbstractRegistryConfiguration;
import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.config.DefaultNatTableStyleConfiguration;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.IConfiguration;
import org.eclipse.nebula.widgets.nattable.data.ExtendedReflectiveColumnPropertyAccessor;
import org.eclipse.nebula.widgets.nattable.data.IColumnAccessor;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.data.ListDataProvider;
import org.eclipse.nebula.widgets.nattable.data.convert.DefaultBooleanDisplayConverter;
import org.eclipse.nebula.widgets.nattable.data.convert.DefaultDoubleDisplayConverter;
import org.eclipse.nebula.widgets.nattable.data.convert.DefaultIntegerDisplayConverter;
import org.eclipse.nebula.widgets.nattable.data.convert.DisplayConverter;
import org.eclipse.nebula.widgets.nattable.data.convert.IDisplayConverter;
import org.eclipse.nebula.widgets.nattable.dataset.person.Person;
import org.eclipse.nebula.widgets.nattable.dataset.person.PersonService;
import org.eclipse.nebula.widgets.nattable.examples.AbstractNatExample;
import org.eclipse.nebula.widgets.nattable.examples.runner.StandaloneNatExampleRunner;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultColumnHeaderDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.layer.DefaultGridLayer;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.cell.ColumnOverrideLabelAccumulator;
import org.eclipse.nebula.widgets.nattable.layer.cell.IConfigLabelAccumulator;
import org.eclipse.nebula.widgets.nattable.painter.cell.BackgroundImagePainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.CheckBoxPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.ComboBoxPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.GradientBackgroundPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.ICellPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.PasswordTextPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.TableCellPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.TextPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.decorator.CustomLineBorderDecorator;
import org.eclipse.nebula.widgets.nattable.painter.cell.decorator.PaddingDecorator;
import org.eclipse.nebula.widgets.nattable.style.BorderStyle;
import org.eclipse.nebula.widgets.nattable.style.CellStyleAttributes;
import org.eclipse.nebula.widgets.nattable.style.HorizontalAlignmentEnum;
import org.eclipse.nebula.widgets.nattable.style.Style;
import org.eclipse.nebula.widgets.nattable.tooltip.NatTableContentTooltip;
import org.eclipse.nebula.widgets.nattable.util.GUIHelper;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class _4222_CellPainterExample
extends AbstractNatExample {
    public static String COLUMN_ONE_LABEL = "ColumnOneLabel";
    public static String COLUMN_TWO_LABEL = "ColumnTwoLabel";
    public static String COLUMN_THREE_LABEL = "ColumnThreeLabel";
    public static String COLUMN_FOUR_LABEL = "ColumnFourLabel";
    public static String COLUMN_FIVE_LABEL = "ColumnFiveLabel";
    public static String COLUMN_SIX_LABEL = "ColumnSixLabel";
    public static String COLUMN_SEVEN_LABEL = "ColumnSevenLabel";
    public static String COLUMN_EIGHT_LABEL = "ColumnEightLabel";
    public static String COLUMN_NINE_LABEL = "ColumnNineLabel";
    public static String COLUMN_TEN_LABEL = "ColumnTenLabel";
    public static String COLUMN_ELEVEN_LABEL = "ColumnElevenLabel";
    public static String COLUMN_TWELVE_LABEL = "ColumnTwelveLabel";
    private NatTable natTable;

    public static void main(String[] args) throws Exception {
        StandaloneNatExampleRunner.run(1024, 400, new _4222_CellPainterExample());
    }

    @Override
    public String getDescription() {
        return "Example showing the different painters that come with NatTable";
    }

    @Override
    public Control createExampleControl(Composite parent) {
        String[] propertyNames = new String[]{"firstName", "lastName", "password", "description", "age", "money", "married", "gender", "address.street", "address.city", "favouriteFood", "favouriteDrinks"};
        HashMap<String, String> propertyToLabelMap = new HashMap<String, String>();
        propertyToLabelMap.put("firstName", "Firstname");
        propertyToLabelMap.put("lastName", "Lastname");
        propertyToLabelMap.put("password", "Password");
        propertyToLabelMap.put("description", "Description");
        propertyToLabelMap.put("age", "Age");
        propertyToLabelMap.put("money", "Money");
        propertyToLabelMap.put("married", "Married");
        propertyToLabelMap.put("gender", "Gender");
        propertyToLabelMap.put("address.street", "Street");
        propertyToLabelMap.put("address.city", "City");
        propertyToLabelMap.put("favouriteFood", "Food");
        propertyToLabelMap.put("favouriteDrinks", "Drinks");
        ListDataProvider bodyDataProvider = new ListDataProvider(PersonService.getExtendedPersonsWithAddress((int)10), (IColumnAccessor)new ExtendedReflectiveColumnPropertyAccessor(propertyNames));
        DefaultGridLayer gridLayer = new DefaultGridLayer((IDataProvider)bodyDataProvider, (IDataProvider)new DefaultColumnHeaderDataProvider(propertyNames, propertyToLabelMap));
        DataLayer bodyDataLayer = (DataLayer)gridLayer.getBodyDataLayer();
        ColumnOverrideLabelAccumulator columnLabelAccumulator = new ColumnOverrideLabelAccumulator((ILayer)bodyDataLayer);
        bodyDataLayer.setConfigLabelAccumulator((IConfigLabelAccumulator)columnLabelAccumulator);
        this.registerColumnLabels(columnLabelAccumulator);
        this.natTable = new NatTable(parent, (ILayer)gridLayer, false);
        this.natTable.addConfiguration((IConfiguration)new DefaultNatTableStyleConfiguration());
        this.natTable.addConfiguration((IConfiguration)new PainterConfiguration());
        this.natTable.configure();
        new NatTableContentTooltip(this.natTable, new String[]{"BODY"});
        return this.natTable;
    }

    private void registerColumnLabels(ColumnOverrideLabelAccumulator columnLabelAccumulator) {
        columnLabelAccumulator.registerColumnOverrides(0, new String[]{COLUMN_ONE_LABEL});
        columnLabelAccumulator.registerColumnOverrides(1, new String[]{COLUMN_TWO_LABEL});
        columnLabelAccumulator.registerColumnOverrides(2, new String[]{COLUMN_THREE_LABEL});
        columnLabelAccumulator.registerColumnOverrides(3, new String[]{COLUMN_FOUR_LABEL});
        columnLabelAccumulator.registerColumnOverrides(4, new String[]{COLUMN_FIVE_LABEL});
        columnLabelAccumulator.registerColumnOverrides(5, new String[]{COLUMN_SIX_LABEL});
        columnLabelAccumulator.registerColumnOverrides(5, new String[]{"rightLineBorderLabel"});
        columnLabelAccumulator.registerColumnOverrides(6, new String[]{COLUMN_SEVEN_LABEL});
        columnLabelAccumulator.registerColumnOverrides(7, new String[]{COLUMN_EIGHT_LABEL});
        columnLabelAccumulator.registerColumnOverrides(8, new String[]{COLUMN_NINE_LABEL});
        columnLabelAccumulator.registerColumnOverrides(9, new String[]{COLUMN_TEN_LABEL});
        columnLabelAccumulator.registerColumnOverrides(10, new String[]{COLUMN_ELEVEN_LABEL});
        columnLabelAccumulator.registerColumnOverrides(11, new String[]{COLUMN_TWELVE_LABEL});
    }

    class PainterConfiguration
    extends AbstractRegistryConfiguration {
        PainterConfiguration() {
        }

        public void configureRegistry(IConfigRegistry configRegistry) {
            this.registerPainters(configRegistry);
        }

        private void registerPainters(IConfigRegistry configRegistry) {
            this.registerColumnHeaderStyle(configRegistry);
            this.registerColumnTwoTextPainterStyle(configRegistry);
            this.registerColumnThreePasswordPainter(configRegistry);
            this.registerColumnFourPainter(configRegistry);
            this.registerColumnFivePainter(configRegistry);
            this.registerColumnSixDoublePainter(configRegistry);
            this.registerColumnSevenCheckboxPainter(configRegistry);
            this.registerColumnEightCheckboxPainter(configRegistry);
            this.registerColumnNineComboBox(configRegistry);
            this.registerColumnTenComboBoxPainter(configRegistry);
            this.registerColumnElevenTablePainter(configRegistry);
            this.registerColumnTwelveComboBox(configRegistry);
        }

        private void registerColumnHeaderStyle(IConfigRegistry configRegistry) {
            Image bgImage = GUIHelper.getImageByURL((String)"columnHeaderBg", (URL)((Object)((Object)this)).getClass().getResource("/org/eclipse/nebula/widgets/nattable/examples/resources/column_header_bg.png"));
            Image selectedBgImage = GUIHelper.getImageByURL((String)"selectedColumnHeaderBg", (URL)((Object)((Object)this)).getClass().getResource("/org/eclipse/nebula/widgets/nattable/examples/resources/selected_column_header_bg.png"));
            TextPainter txtPainter = new TextPainter(false, false);
            BackgroundImagePainter bgImagePainter = new BackgroundImagePainter((ICellPainter)txtPainter, bgImage, GUIHelper.getColor((int)192, (int)192, (int)192));
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, (Object)bgImagePainter, "NORMAL", "COLUMN_HEADER");
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, (Object)bgImagePainter, "NORMAL", "CORNER");
            BackgroundImagePainter selectedHeaderPainter = new BackgroundImagePainter((ICellPainter)txtPainter, selectedBgImage, GUIHelper.getColor((int)192, (int)192, (int)192));
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, (Object)selectedHeaderPainter, "SELECT", "COLUMN_HEADER");
        }

        private void registerColumnTwoTextPainterStyle(IConfigRegistry configRegistry) {
            Style style = new Style();
            style.setAttributeValue(CellStyleAttributes.BORDER_STYLE, (Object)new BorderStyle(2, GUIHelper.COLOR_BLUE, BorderStyle.LineStyleEnum.DASHDOT));
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, (Object)style, "NORMAL", COLUMN_TWO_LABEL);
        }

        private void registerColumnThreePasswordPainter(IConfigRegistry configRegistry) {
            Style style = new Style();
            style.setAttributeValue(CellStyleAttributes.GRADIENT_BACKGROUND_COLOR, (Object)GUIHelper.COLOR_WHITE);
            style.setAttributeValue(CellStyleAttributes.GRADIENT_FOREGROUND_COLOR, (Object)GUIHelper.COLOR_RED);
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, (Object)style, "NORMAL", COLUMN_THREE_LABEL);
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, (Object)new GradientBackgroundPainter((ICellPainter)new PasswordTextPainter(false, false)), "NORMAL", COLUMN_THREE_LABEL);
        }

        private void registerColumnFourPainter(IConfigRegistry configRegistry) {
            Style style = new Style();
            style.setAttributeValue(CellStyleAttributes.HORIZONTAL_ALIGNMENT, (Object)HorizontalAlignmentEnum.LEFT);
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, (Object)style, "NORMAL", COLUMN_FOUR_LABEL);
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, (Object)new GradientBackgroundPainter((ICellPainter)new TextPainter(false, false, false, true), true), "NORMAL", COLUMN_FOUR_LABEL);
        }

        private void registerColumnFivePainter(IConfigRegistry configRegistry) {
            Style style = new Style();
            style.setAttributeValue(CellStyleAttributes.HORIZONTAL_ALIGNMENT, (Object)HorizontalAlignmentEnum.RIGHT);
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, (Object)style, "NORMAL", COLUMN_FIVE_LABEL);
            configRegistry.registerConfigAttribute(CellConfigAttributes.DISPLAY_CONVERTER, (Object)new DefaultIntegerDisplayConverter(), "NORMAL", COLUMN_FIVE_LABEL);
        }

        private void registerColumnSixDoublePainter(IConfigRegistry configRegistry) {
            Style style = new Style();
            style.setAttributeValue(CellStyleAttributes.HORIZONTAL_ALIGNMENT, (Object)HorizontalAlignmentEnum.RIGHT);
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, (Object)style, "NORMAL", COLUMN_SIX_LABEL);
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, (Object)new CustomLineBorderDecorator((ICellPainter)new PaddingDecorator((ICellPainter)new TextPainter(), 0, 5, 0, 0), new BorderStyle(2, GUIHelper.COLOR_GREEN, BorderStyle.LineStyleEnum.SOLID)), "NORMAL", COLUMN_SIX_LABEL);
            configRegistry.registerConfigAttribute(CellConfigAttributes.DISPLAY_CONVERTER, (Object)new DefaultDoubleDisplayConverter(), "NORMAL", COLUMN_SIX_LABEL);
        }

        private void registerColumnSevenCheckboxPainter(IConfigRegistry configRegistry) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, (Object)new CheckBoxPainter(), "NORMAL", COLUMN_SEVEN_LABEL);
            configRegistry.registerConfigAttribute(CellConfigAttributes.DISPLAY_CONVERTER, (Object)new DefaultBooleanDisplayConverter(), "NORMAL", COLUMN_SEVEN_LABEL);
        }

        private void registerColumnEightCheckboxPainter(IConfigRegistry configRegistry) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, (Object)new CheckBoxPainter(GUIHelper.getImage((String)"arrow_up"), GUIHelper.getImage((String)"arrow_down")), "NORMAL", COLUMN_EIGHT_LABEL);
            configRegistry.registerConfigAttribute(CellConfigAttributes.DISPLAY_CONVERTER, (Object)this.getGenderBooleanConverter(), "NORMAL", COLUMN_EIGHT_LABEL);
        }

        private void registerColumnNineComboBox(IConfigRegistry configRegistry) {
        }

        private void registerColumnTenComboBoxPainter(IConfigRegistry configRegistry) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, (Object)new ComboBoxPainter(), "NORMAL", COLUMN_TEN_LABEL);
        }

        private void registerColumnElevenTablePainter(IConfigRegistry configRegistry) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, (Object)new TableCellPainter(), "NORMAL", COLUMN_ELEVEN_LABEL);
        }

        private void registerColumnTwelveComboBox(IConfigRegistry configRegistry) {
        }

        private IDisplayConverter getGenderBooleanConverter() {
            return new DisplayConverter(){

                public Object canonicalToDisplayValue(Object canonicalValue) {
                    if (canonicalValue instanceof Person.Gender) {
                        if ((Person.Gender)canonicalValue == Person.Gender.MALE) {
                            return true;
                        }
                        return false;
                    }
                    return null;
                }

                public Object displayToCanonicalValue(Object displayValue) {
                    Boolean displayBoolean = Boolean.valueOf(displayValue.toString());
                    return displayBoolean != false ? Person.Gender.MALE : Person.Gender.FEMALE;
                }
            };
        }
    }
}

