/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.widget;

import java.util.Arrays;
import org.eclipse.nebula.widgets.nattable.style.CellStyleAttributes;
import org.eclipse.nebula.widgets.nattable.style.CellStyleUtil;
import org.eclipse.nebula.widgets.nattable.style.HorizontalAlignmentEnum;
import org.eclipse.nebula.widgets.nattable.style.IStyle;
import org.eclipse.nebula.widgets.nattable.style.VerticalAlignmentEnum;
import org.eclipse.nebula.widgets.nattable.util.GUIHelper;
import org.eclipse.nebula.widgets.nattable.widget.EditModeEnum;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class NatCombo
extends Composite {
    public static final int DEFAULT_NUM_OF_VISIBLE_ITEMS = 5;
    private final IStyle cellStyle;
    private int maxVisibleItems = 10;
    private String[] items;
    private Text text;
    private Shell dropdownShell;
    private List dropdownList;
    private Image iconImage;
    private EditModeEnum editMode;
    private boolean initialResize = false;

    public NatCombo(Composite parent, IStyle cellStyle) {
        this(parent, cellStyle, 5);
    }

    public NatCombo(Composite parent, IStyle cellStyle, int maxVisibleItems) {
        super(parent, 0);
        this.cellStyle = cellStyle;
        this.maxVisibleItems = maxVisibleItems;
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.horizontalSpacing = 0;
        this.setLayout((Layout)gridLayout);
        this.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent event) {
                if (NatCombo.this.editMode == EditModeEnum.MULTI && !NatCombo.this.initialResize) {
                    NatCombo.this.initialResize = true;
                    return;
                }
                NatCombo.this.resizeDropdownControl();
            }
        });
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                NatCombo.this.dropdownShell.dispose();
                NatCombo.this.text.dispose();
            }
        });
        this.createTextControl();
        this.createDropdownControl();
    }

    public void setEditMode(EditModeEnum editMode) {
        this.editMode = editMode;
    }

    public void setItems(String[] items) {
        if (items != null) {
            this.items = items;
            if (!this.dropdownList.isDisposed() && items != null && items.length > 0) {
                this.dropdownList.setItems(items);
            }
            this.resizeDropdownControl();
        }
    }

    public void setSelection(String[] items) {
        if (items != null && !this.dropdownList.isDisposed()) {
            this.dropdownList.setSelection(items);
        }
        if (items[0] != null) {
            this.text.setText(items[0]);
        }
    }

    public int getSelectionIndex() {
        if (!this.dropdownList.isDisposed()) {
            return this.dropdownList.getSelectionIndex();
        }
        return Arrays.asList(this.items).indexOf(this.text.getText());
    }

    public void addKeyListener(KeyListener listener) {
        this.text.addKeyListener(listener);
        this.dropdownList.addKeyListener(listener);
    }

    public void addTraverseListener(TraverseListener listener) {
        this.text.addTraverseListener(listener);
        this.dropdownList.addTraverseListener(listener);
    }

    public void addMouseListener(MouseListener listener) {
        this.text.addMouseListener(listener);
        this.dropdownList.addMouseListener(listener);
    }

    public void notifyListeners(int eventType, Event event) {
        this.dropdownList.notifyListeners(eventType, event);
    }

    private void createTextControl() {
        this.text = new Text((Composite)this, HorizontalAlignmentEnum.getSWTStyle(this.cellStyle));
        this.text.setBackground(this.cellStyle.getAttributeValue(CellStyleAttributes.BACKGROUND_COLOR));
        this.text.setForeground(this.cellStyle.getAttributeValue(CellStyleAttributes.FOREGROUND_COLOR));
        this.text.setFont(this.cellStyle.getAttributeValue(CellStyleAttributes.FONT));
        GridData gridData = new GridData(4, 4, true, true);
        this.text.setLayoutData((Object)gridData);
        this.text.forceFocus();
        this.text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.keyCode == 0x1000002 || event.keyCode == 0x1000001) {
                    NatCombo.this.showDropdownControl();
                    int selectionIndex = NatCombo.this.dropdownList.getSelectionIndex();
                    if ((selectionIndex += event.keyCode == 0x1000002 ? 1 : -1) < 0) {
                        selectionIndex = 0;
                    }
                    NatCombo.this.dropdownList.select(selectionIndex);
                    NatCombo.this.text.setText(NatCombo.this.dropdownList.getSelection()[0]);
                }
            }
        });
        this.iconImage = GUIHelper.getImage("down_2");
        final Canvas iconCanvas = new Canvas(this, 0){

            public Point computeSize(int wHint, int hHint, boolean changed) {
                Rectangle iconImageBounds = NatCombo.this.iconImage.getBounds();
                return new Point(iconImageBounds.width + 2, iconImageBounds.height + 2);
            }
        };
        gridData = new GridData(1, 4, false, true);
        iconCanvas.setLayoutData((Object)gridData);
        iconCanvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                GC gc = event.gc;
                Rectangle iconCanvasBounds = iconCanvas.getBounds();
                Rectangle iconImageBounds = NatCombo.this.iconImage.getBounds();
                int horizontalAlignmentPadding = CellStyleUtil.getHorizontalAlignmentPadding(HorizontalAlignmentEnum.CENTER, iconCanvasBounds, iconImageBounds.width);
                int verticalAlignmentPadding = CellStyleUtil.getVerticalAlignmentPadding(VerticalAlignmentEnum.MIDDLE, iconCanvasBounds, iconImageBounds.height);
                gc.drawImage(NatCombo.this.iconImage, horizontalAlignmentPadding, verticalAlignmentPadding);
                Color originalFg = gc.getForeground();
                gc.setForeground(GUIHelper.COLOR_WIDGET_BORDER);
                gc.drawRectangle(0, 0, iconCanvasBounds.width - 1, iconCanvasBounds.height - 1);
                gc.setForeground(originalFg);
            }
        });
        iconCanvas.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                NatCombo.this.showDropdownControl();
            }
        });
    }

    private void showDropdownControl() {
        if (this.dropdownShell.isDisposed()) {
            this.createDropdownControl();
        }
        this.resizeDropdownControl();
    }

    public void hideDropdownControl() {
        if (!this.dropdownShell.isDisposed()) {
            this.dropdownShell.setVisible(false);
        }
    }

    private void createDropdownControl() {
        this.dropdownShell = new Shell(this.getShell(), 0);
        this.dropdownShell.setLayout((Layout)new FillLayout());
        this.dropdownList = new List((Composite)this.dropdownShell, 0x200 | HorizontalAlignmentEnum.getSWTStyle(this.cellStyle));
        this.dropdownList.setBackground(this.cellStyle.getAttributeValue(CellStyleAttributes.BACKGROUND_COLOR));
        this.dropdownList.setForeground(this.cellStyle.getAttributeValue(CellStyleAttributes.FOREGROUND_COLOR));
        this.dropdownList.setFont(this.cellStyle.getAttributeValue(CellStyleAttributes.FONT));
        this.dropdownList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (NatCombo.this.dropdownList.getSelectionCount() > 0) {
                    NatCombo.this.text.setText(NatCombo.this.dropdownList.getSelection()[0]);
                }
            }
        });
        this.setItems(this.items);
        this.dropdownList.setSelection(new String[]{this.text.getText()});
    }

    private void resizeDropdownControl() {
        if (this.dropdownShell != null && !this.dropdownShell.isDisposed() && !this.dropdownShell.isVisible()) {
            Point size = this.getSize();
            int itemCount = this.dropdownList.getItemCount();
            if (itemCount > 0 && size.x > 0 && size.y > 0) {
                int listHeight = Math.min(itemCount, this.maxVisibleItems) * this.dropdownList.getItemHeight();
                int listWidth = this.dropdownList.computeSize((int)-1, (int)listHeight).x;
                if (listWidth < size.x) {
                    listWidth = size.x;
                }
                this.dropdownList.setSize(listWidth, listHeight);
                Display display = this.getDisplay();
                Rectangle listRect = this.dropdownList.getBounds();
                Rectangle parentRect = display.map((Control)this.getParent(), null, this.getBounds());
                Point comboSize = this.getSize();
                Rectangle displayRect = this.getMonitor().getClientArea();
                int width = Math.max(comboSize.x, listRect.width + 2);
                int height = listRect.height + 2;
                int x = parentRect.x;
                int y = parentRect.y + comboSize.y;
                if (y + height > displayRect.y + displayRect.height) {
                    y = parentRect.y - height;
                }
                if (x + width > displayRect.x + displayRect.width) {
                    x = displayRect.x + displayRect.width - listRect.width;
                }
                this.dropdownShell.setBounds(x, y, width, height);
                this.dropdownShell.open();
            }
        }
    }

    public void select(int index) {
        this.dropdownList.select(index);
    }

    public void addFocusListener(FocusListener listener) {
        this.dropdownList.addFocusListener(listener);
    }

    public void addShellListener(ShellListener listener) {
        this.dropdownShell.addShellListener(listener);
    }
}

