/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.style.editor.command;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.nebula.widgets.nattable.command.AbstractLayerCommandHandler;
import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.layer.LabelStack;
import org.eclipse.nebula.widgets.nattable.layer.cell.ColumnOverrideLabelAccumulator;
import org.eclipse.nebula.widgets.nattable.persistence.IPersistable;
import org.eclipse.nebula.widgets.nattable.persistence.StylePersistor;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.style.CellStyleAttributes;
import org.eclipse.nebula.widgets.nattable.style.Style;
import org.eclipse.nebula.widgets.nattable.style.editor.ColumnStyleEditorDialog;
import org.eclipse.nebula.widgets.nattable.style.editor.command.DisplayColumnStyleEditorCommand;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DisplayColumnStyleEditorCommandHandler
extends AbstractLayerCommandHandler<DisplayColumnStyleEditorCommand>
implements IPersistable {
    protected static final String PERSISTENCE_PREFIX = "userDefinedColumnStyle";
    protected static final String USER_EDITED_STYLE_LABEL = "USER_EDITED_STYLE_FOR_INDEX_";
    protected final SelectionLayer selectionLayer;
    protected ColumnOverrideLabelAccumulator columnLabelAccumulator;
    private final IConfigRegistry configRegistry;
    protected ColumnStyleEditorDialog dialog;
    protected final Map<String, Style> stylesToPersist = new HashMap<String, Style>();

    public DisplayColumnStyleEditorCommandHandler(SelectionLayer selectionLayer, ColumnOverrideLabelAccumulator labelAccumulator, IConfigRegistry configRegistry) {
        this.selectionLayer = selectionLayer;
        this.columnLabelAccumulator = labelAccumulator;
        this.configRegistry = configRegistry;
    }

    @Override
    public boolean doCommand(DisplayColumnStyleEditorCommand command) {
        int columnIndexOfClick = command.getNattableLayer().getColumnIndexByPosition(command.columnPosition);
        LabelStack configLabels = new LabelStack(new String[0]);
        this.columnLabelAccumulator.accumulateConfigLabels(configLabels, columnIndexOfClick, 0);
        configLabels.addLabel(this.getConfigLabel(columnIndexOfClick));
        Style clickedCellStyle = (Style)this.configRegistry.getConfigAttribute(CellConfigAttributes.CELL_STYLE, "NORMAL", configLabels.getLabels());
        this.dialog = new ColumnStyleEditorDialog(Display.getCurrent().getActiveShell(), clickedCellStyle);
        this.dialog.open();
        if (this.dialog.isCancelPressed()) {
            return true;
        }
        this.applySelectedStyleToColumns(command, this.getSelectedColumnIndeces());
        return true;
    }

    private int[] getSelectedColumnIndeces() {
        int[] selectedColumnPositions = this.selectionLayer.getSelectedColumnPositions();
        int[] selectedColumnIndeces = new int[selectedColumnPositions.length];
        int i = 0;
        while (i < selectedColumnPositions.length) {
            selectedColumnIndeces[i] = this.selectionLayer.getColumnIndexByPosition(selectedColumnPositions[i]);
            ++i;
        }
        return selectedColumnIndeces;
    }

    @Override
    public Class<DisplayColumnStyleEditorCommand> getCommandClass() {
        return DisplayColumnStyleEditorCommand.class;
    }

    protected void applySelectedStyleToColumns(DisplayColumnStyleEditorCommand command, int[] columnIndeces) {
        int i = 0;
        while (i < columnIndeces.length) {
            int columnIndex = columnIndeces[i];
            Style newColumnCellStyle = this.dialog.getNewColumnCellStyle();
            String configLabel = this.getConfigLabel(columnIndex);
            if (newColumnCellStyle == null) {
                this.stylesToPersist.remove(configLabel);
            } else {
                newColumnCellStyle.setAttributeValue(CellStyleAttributes.BORDER_STYLE, this.dialog.getNewColumnBorderStyle());
                this.stylesToPersist.put(configLabel, newColumnCellStyle);
            }
            this.configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, newColumnCellStyle, "NORMAL", configLabel);
            this.columnLabelAccumulator.registerColumnOverridesOnTop(columnIndex, configLabel);
            ++i;
        }
    }

    protected String getConfigLabel(int columnIndex) {
        return USER_EDITED_STYLE_LABEL + columnIndex;
    }

    @Override
    public void loadState(String prefix, Properties properties) {
        prefix = String.valueOf(prefix) + "." + PERSISTENCE_PREFIX;
        Set<Object> keySet = properties.keySet();
        for (Object key : keySet) {
            String keyString = (String)key;
            if (!keyString.contains(PERSISTENCE_PREFIX)) continue;
            int colIndex = this.parseColumnIndexFromKey(keyString);
            if (this.stylesToPersist.keySet().contains(this.getConfigLabel(colIndex))) continue;
            Style savedStyle = StylePersistor.loadStyle(String.valueOf(prefix) + "." + this.getConfigLabel(colIndex), properties);
            this.configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, savedStyle, "NORMAL", this.getConfigLabel(colIndex));
            this.stylesToPersist.put(this.getConfigLabel(colIndex), savedStyle);
            this.columnLabelAccumulator.registerColumnOverrides(colIndex, this.getConfigLabel(colIndex));
        }
    }

    protected int parseColumnIndexFromKey(String keyString) {
        int colLabelStartIndex = keyString.indexOf(USER_EDITED_STYLE_LABEL);
        String columnConfigLabel = keyString.substring(colLabelStartIndex, keyString.indexOf(46, colLabelStartIndex));
        int lastUnderscoreInLabel = columnConfigLabel.lastIndexOf(95, colLabelStartIndex);
        return Integer.parseInt(columnConfigLabel.substring(lastUnderscoreInLabel + 1));
    }

    @Override
    public void saveState(String prefix, Properties properties) {
        prefix = String.valueOf(prefix) + "." + PERSISTENCE_PREFIX;
        for (Map.Entry<String, Style> labelToStyle : this.stylesToPersist.entrySet()) {
            Style style = labelToStyle.getValue();
            String label = labelToStyle.getKey();
            StylePersistor.saveStyle(String.valueOf(prefix) + "." + label, properties, style);
        }
    }
}

