/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.layer.cell;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.LabelStack;
import org.eclipse.nebula.widgets.nattable.layer.cell.AbstractOverrider;
import org.eclipse.nebula.widgets.nattable.persistence.IPersistable;

public class ColumnOverrideLabelAccumulator
extends AbstractOverrider
implements IPersistable {
    public static final String PERSISTENCE_KEY = ".columnOverrideLabelAccumulator";
    private final ILayer layer;

    public ColumnOverrideLabelAccumulator(ILayer layer) {
        this.layer = layer;
    }

    public void accumulateConfigLabels(LabelStack configLabels, int columnPosition, int rowPosition) {
        int columnIndex = this.layer.getColumnIndexByPosition(columnPosition);
        List<String> overrides = this.getOverrides(Integer.valueOf(columnIndex));
        if (overrides != null) {
            for (String configLabel : overrides) {
                configLabels.addLabel(configLabel);
            }
        }
    }

    public void registerColumnOverrides(int columnIndex, String ... configLabels) {
        super.registerOverrides((Serializable)Integer.valueOf(columnIndex), configLabels);
    }

    public void registerColumnOverridesOnTop(int columnIndex, String ... configLabels) {
        super.registerOverridesOnTop(Integer.valueOf(columnIndex), configLabels);
    }

    public void saveState(String prefix, Properties properties) {
        Map<Serializable, List<String>> overrides = this.getOverrides();
        for (Map.Entry<Serializable, List<String>> entry : overrides.entrySet()) {
            StringBuilder strBuilder = new StringBuilder();
            for (String columnLabel : entry.getValue()) {
                strBuilder.append(columnLabel);
                strBuilder.append(",");
            }
            String propertyValue = strBuilder.toString();
            if (propertyValue.endsWith(",")) {
                propertyValue = propertyValue.substring(0, propertyValue.length() - 1);
            }
            String propertyKey = String.valueOf(prefix) + PERSISTENCE_KEY + "." + entry.getKey();
            properties.setProperty(propertyKey, propertyValue);
        }
    }

    public void loadState(String prefix, Properties properties) {
        Set<Object> keySet = properties.keySet();
        for (Object key : keySet) {
            String keyString = (String)key;
            if (!keyString.contains(PERSISTENCE_KEY)) continue;
            String labelsFromPropertyValue = properties.getProperty(keyString).trim();
            String columnIndexFromKey = keyString.substring(keyString.lastIndexOf(".") + 1);
            this.registerColumnOverrides(Integer.parseInt(columnIndexFromKey), labelsFromPropertyValue.split(","));
        }
    }
}

