/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.hideshow;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.nebula.widgets.nattable.coordinate.Range;
import org.eclipse.nebula.widgets.nattable.layer.AbstractLayerTransform;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.LayerUtil;
import org.eclipse.nebula.widgets.nattable.layer.event.ILayerEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.IStructuralChangeEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.RowStructuralRefreshEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractColumnHideShowLayer
extends AbstractLayerTransform
implements IUniqueIndexLayer {
    private List<Integer> cachedVisibleColumnIndexOrder;
    private Map<Integer, Integer> cachedHiddenColumnIndexToPositionMap;
    private final Map<Integer, Integer> startXCache = new HashMap<Integer, Integer>();

    public AbstractColumnHideShowLayer(IUniqueIndexLayer underlyingLayer) {
        super(underlyingLayer);
    }

    @Override
    public void handleLayerEvent(ILayerEvent event) {
        IStructuralChangeEvent structuralChangeEvent;
        if (event instanceof IStructuralChangeEvent && (structuralChangeEvent = (IStructuralChangeEvent)event).isHorizontalStructureChanged()) {
            this.invalidateCache();
        }
        super.handleLayerEvent(event);
    }

    @Override
    public void loadState(String prefix, Properties properties) {
        super.loadState(prefix, properties);
        this.fireLayerEvent(new RowStructuralRefreshEvent(this));
    }

    @Override
    public int getColumnCount() {
        return this.getCachedVisibleColumnIndexes().size();
    }

    @Override
    public int getColumnIndexByPosition(int columnPosition) {
        if (columnPosition < 0 || columnPosition >= this.getColumnCount()) {
            return -1;
        }
        Integer columnIndex = this.getCachedVisibleColumnIndexes().get(columnPosition);
        if (columnIndex != null) {
            return columnIndex;
        }
        return -1;
    }

    @Override
    public int getColumnPositionByIndex(int columnIndex) {
        return this.getCachedVisibleColumnIndexes().indexOf(columnIndex);
    }

    @Override
    public int localToUnderlyingColumnPosition(int localColumnPosition) {
        int columnIndex = this.getColumnIndexByPosition(localColumnPosition);
        return ((IUniqueIndexLayer)this.getUnderlyingLayer()).getColumnPositionByIndex(columnIndex);
    }

    @Override
    public int underlyingToLocalColumnPosition(ILayer sourceUnderlyingLayer, int underlyingColumnPosition) {
        int columnIndex = this.getUnderlyingLayer().getColumnIndexByPosition(underlyingColumnPosition);
        int columnPosition = this.getColumnPositionByIndex(columnIndex);
        if (columnPosition >= 0) {
            return columnPosition;
        }
        Integer hiddenColumnPosition = this.cachedHiddenColumnIndexToPositionMap.get(columnIndex);
        if (hiddenColumnPosition != null) {
            return hiddenColumnPosition;
        }
        return -1;
    }

    @Override
    public Collection<Range> underlyingToLocalColumnPositions(ILayer sourceUnderlyingLayer, Collection<Range> underlyingColumnPositionRanges) {
        ArrayList<Range> localColumnPositionRanges = new ArrayList<Range>();
        for (Range underlyingColumnPositionRange : underlyingColumnPositionRanges) {
            int startColumnPosition = this.getAdjustedUnderlyingToLocalStartPosition(sourceUnderlyingLayer, underlyingColumnPositionRange.start, underlyingColumnPositionRange.end);
            int endColumnPosition = this.getAdjustedUnderlyingToLocalEndPosition(sourceUnderlyingLayer, underlyingColumnPositionRange.end, underlyingColumnPositionRange.start);
            if (startColumnPosition <= -1) continue;
            localColumnPositionRanges.add(new Range(startColumnPosition, endColumnPosition));
        }
        return localColumnPositionRanges;
    }

    private int getAdjustedUnderlyingToLocalStartPosition(ILayer sourceUnderlyingLayer, int startUnderlyingPosition, int endUnderlyingPosition) {
        int localStartColumnPosition = this.underlyingToLocalColumnPosition(sourceUnderlyingLayer, startUnderlyingPosition);
        int offset = 0;
        while (localStartColumnPosition < 0 && startUnderlyingPosition + offset < endUnderlyingPosition) {
            localStartColumnPosition = this.underlyingToLocalColumnPosition(sourceUnderlyingLayer, startUnderlyingPosition + offset++);
        }
        return localStartColumnPosition;
    }

    private int getAdjustedUnderlyingToLocalEndPosition(ILayer sourceUnderlyingLayer, int endUnderlyingPosition, int startUnderlyingPosition) {
        int localEndColumnPosition = this.underlyingToLocalColumnPosition(sourceUnderlyingLayer, endUnderlyingPosition - 1);
        int offset = 0;
        while (localEndColumnPosition < 0 && endUnderlyingPosition - offset > startUnderlyingPosition) {
            localEndColumnPosition = this.underlyingToLocalColumnPosition(sourceUnderlyingLayer, endUnderlyingPosition - offset++);
        }
        return localEndColumnPosition + 1;
    }

    @Override
    public int getWidth() {
        int lastColumnPosition = this.getColumnCount() - 1;
        return this.getStartXOfColumnPosition(lastColumnPosition) + this.getColumnWidthByPosition(lastColumnPosition);
    }

    @Override
    public int getColumnPositionByX(int x) {
        return LayerUtil.getColumnPositionByX(this, x);
    }

    @Override
    public int getStartXOfColumnPosition(int localColumnPosition) {
        Integer cachedStartX = this.startXCache.get(localColumnPosition);
        if (cachedStartX != null) {
            return cachedStartX;
        }
        IUniqueIndexLayer underlyingLayer = (IUniqueIndexLayer)this.getUnderlyingLayer();
        int underlyingPosition = this.localToUnderlyingColumnPosition(localColumnPosition);
        int underlyingStartX = underlyingLayer.getStartXOfColumnPosition(underlyingPosition);
        for (Integer hiddenIndex : this.getHiddenColumnIndexes()) {
            int hiddenPosition = underlyingLayer.getColumnPositionByIndex(hiddenIndex);
            if (hiddenPosition > underlyingPosition) continue;
            underlyingStartX -= underlyingLayer.getColumnWidthByPosition(hiddenPosition);
        }
        this.startXCache.put(localColumnPosition, underlyingStartX);
        return underlyingStartX;
    }

    @Override
    public int getRowPositionByIndex(int rowIndex) {
        return ((IUniqueIndexLayer)this.getUnderlyingLayer()).getRowPositionByIndex(rowIndex);
    }

    public abstract boolean isColumnIndexHidden(int var1);

    public abstract Collection<Integer> getHiddenColumnIndexes();

    protected void invalidateCache() {
        this.cachedVisibleColumnIndexOrder = null;
        this.startXCache.clear();
    }

    private List<Integer> getCachedVisibleColumnIndexes() {
        if (this.cachedVisibleColumnIndexOrder == null) {
            this.cacheVisibleColumnIndexes();
        }
        return this.cachedVisibleColumnIndexOrder;
    }

    private void cacheVisibleColumnIndexes() {
        this.cachedVisibleColumnIndexOrder = new ArrayList<Integer>();
        this.cachedHiddenColumnIndexToPositionMap = new HashMap<Integer, Integer>();
        this.startXCache.clear();
        ILayer underlyingLayer = this.getUnderlyingLayer();
        int columnPosition = 0;
        int parentColumnPosition = 0;
        while (parentColumnPosition < underlyingLayer.getColumnCount()) {
            int columnIndex = underlyingLayer.getColumnIndexByPosition(parentColumnPosition);
            if (!this.isColumnIndexHidden(columnIndex)) {
                this.cachedVisibleColumnIndexOrder.add(columnIndex);
                ++columnPosition;
            } else {
                this.cachedHiddenColumnIndexToPositionMap.put(columnIndex, columnPosition);
            }
            ++parentColumnPosition;
        }
    }
}

