/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.grid.layer;

import java.util.List;
import java.util.Map;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultBodyDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultColumnHeaderDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultCornerDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultRowHeaderDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.layer.ColumnHeaderLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.CornerLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.DefaultColumnHeaderDataLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.DefaultRowHeaderDataLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.GridLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.RowHeaderLayer;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.stack.DefaultBodyLayerStack;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultGridLayer
extends GridLayer {
    protected IUniqueIndexLayer bodyDataLayer;
    protected IUniqueIndexLayer columnHeaderDataLayer;
    protected IUniqueIndexLayer rowHeaderDataLayer;
    protected IUniqueIndexLayer cornerDataLayer;

    public <T> DefaultGridLayer(List<T> rowData, String[] propertyNames, Map<String, String> propertyToLabelMap) {
        this(rowData, propertyNames, propertyToLabelMap, true);
    }

    public <T> DefaultGridLayer(List<T> rowData, String[] propertyNames, Map<String, String> propertyToLabelMap, boolean useDefaultConfiguration) {
        super(useDefaultConfiguration);
        this.init(rowData, propertyNames, propertyToLabelMap);
    }

    public DefaultGridLayer(IDataProvider bodyDataProvider, IDataProvider columnHeaderDataProvider) {
        this(bodyDataProvider, columnHeaderDataProvider, true);
    }

    public DefaultGridLayer(IDataProvider bodyDataProvider, IDataProvider columnHeaderDataProvider, boolean useDefaultConfiguration) {
        super(useDefaultConfiguration);
        this.init(bodyDataProvider, columnHeaderDataProvider);
    }

    public DefaultGridLayer(IDataProvider bodyDataProvider, IDataProvider columnHeaderDataProvider, IDataProvider rowHeaderDataProvider) {
        this(bodyDataProvider, columnHeaderDataProvider, rowHeaderDataProvider, true);
    }

    public DefaultGridLayer(IDataProvider bodyDataProvider, IDataProvider columnHeaderDataProvider, IDataProvider rowHeaderDataProvider, boolean useDefaultConfiguration) {
        super(useDefaultConfiguration);
        this.init(bodyDataProvider, columnHeaderDataProvider, rowHeaderDataProvider);
    }

    public DefaultGridLayer(IDataProvider bodyDataProvider, IDataProvider columnHeaderDataProvider, IDataProvider rowHeaderDataProvider, IDataProvider cornerDataProvider) {
        this(bodyDataProvider, columnHeaderDataProvider, rowHeaderDataProvider, cornerDataProvider, true);
    }

    public DefaultGridLayer(IDataProvider bodyDataProvider, IDataProvider columnHeaderDataProvider, IDataProvider rowHeaderDataProvider, IDataProvider cornerDataProvider, boolean useDefaultConfiguration) {
        super(useDefaultConfiguration);
        this.init(bodyDataProvider, columnHeaderDataProvider, rowHeaderDataProvider, cornerDataProvider);
    }

    public DefaultGridLayer(IUniqueIndexLayer bodyDataLayer, IUniqueIndexLayer columnHeaderDataLayer, IUniqueIndexLayer rowHeaderDataLayer, IUniqueIndexLayer cornerDataLayer) {
        this(bodyDataLayer, columnHeaderDataLayer, rowHeaderDataLayer, cornerDataLayer, true);
    }

    public DefaultGridLayer(IUniqueIndexLayer bodyDataLayer, IUniqueIndexLayer columnHeaderDataLayer, IUniqueIndexLayer rowHeaderDataLayer, IUniqueIndexLayer cornerDataLayer, boolean useDefaultConfiguration) {
        super(useDefaultConfiguration);
        this.init(bodyDataLayer, columnHeaderDataLayer, rowHeaderDataLayer, cornerDataLayer);
    }

    protected DefaultGridLayer(boolean useDefaultConfiguration) {
        super(useDefaultConfiguration);
    }

    protected <T> void init(List<T> rowData, String[] propertyNames, Map<String, String> propertyToLabelMap) {
        this.init(new DefaultBodyDataProvider<T>(rowData, propertyNames), new DefaultColumnHeaderDataProvider(propertyNames, propertyToLabelMap));
    }

    protected void init(IDataProvider bodyDataProvider, IDataProvider columnHeaderDataProvider) {
        this.init(bodyDataProvider, columnHeaderDataProvider, new DefaultRowHeaderDataProvider(bodyDataProvider));
    }

    protected void init(IDataProvider bodyDataProvider, IDataProvider columnHeaderDataProvider, IDataProvider rowHeaderDataProvider) {
        this.init(bodyDataProvider, columnHeaderDataProvider, rowHeaderDataProvider, new DefaultCornerDataProvider(columnHeaderDataProvider, rowHeaderDataProvider));
    }

    protected void init(IDataProvider bodyDataProvider, IDataProvider columnHeaderDataProvider, IDataProvider rowHeaderDataProvider, IDataProvider cornerDataProvider) {
        this.init(new DataLayer(bodyDataProvider), new DefaultColumnHeaderDataLayer(columnHeaderDataProvider), new DefaultRowHeaderDataLayer(rowHeaderDataProvider), new DataLayer(cornerDataProvider));
    }

    protected void init(IUniqueIndexLayer bodyDataLayer, IUniqueIndexLayer columnHeaderDataLayer, IUniqueIndexLayer rowHeaderDataLayer, IUniqueIndexLayer cornerDataLayer) {
        this.bodyDataLayer = bodyDataLayer;
        DefaultBodyLayerStack bodyLayer = new DefaultBodyLayerStack(bodyDataLayer);
        SelectionLayer selectionLayer = bodyLayer.getSelectionLayer();
        this.columnHeaderDataLayer = columnHeaderDataLayer;
        ColumnHeaderLayer columnHeaderLayer = new ColumnHeaderLayer(columnHeaderDataLayer, (ILayer)bodyLayer, selectionLayer);
        this.rowHeaderDataLayer = rowHeaderDataLayer;
        RowHeaderLayer rowHeaderLayer = new RowHeaderLayer(rowHeaderDataLayer, (ILayer)bodyLayer, selectionLayer);
        this.cornerDataLayer = cornerDataLayer;
        CornerLayer cornerLayer = new CornerLayer(cornerDataLayer, rowHeaderLayer, columnHeaderLayer);
        this.setBodyLayer(bodyLayer);
        this.setColumnHeaderLayer(columnHeaderLayer);
        this.setRowHeaderLayer(rowHeaderLayer);
        this.setCornerLayer(cornerLayer);
    }

    public IUniqueIndexLayer getBodyDataLayer() {
        return this.bodyDataLayer;
    }

    @Override
    public DefaultBodyLayerStack getBodyLayer() {
        return (DefaultBodyLayerStack)super.getBodyLayer();
    }

    public IUniqueIndexLayer getColumnHeaderDataLayer() {
        return this.columnHeaderDataLayer;
    }

    @Override
    public ColumnHeaderLayer getColumnHeaderLayer() {
        return (ColumnHeaderLayer)super.getColumnHeaderLayer();
    }

    public IUniqueIndexLayer getRowHeaderDataLayer() {
        return this.rowHeaderDataLayer;
    }

    @Override
    public RowHeaderLayer getRowHeaderLayer() {
        return (RowHeaderLayer)super.getRowHeaderLayer();
    }

    public IUniqueIndexLayer getCornerDataLayer() {
        return this.cornerDataLayer;
    }

    @Override
    public CornerLayer getCornerLayer() {
        return (CornerLayer)super.getCornerLayer();
    }
}

