/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.export.excel;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.export.FileOutputStreamProvider;
import org.eclipse.nebula.widgets.nattable.export.ILayerExporter;
import org.eclipse.nebula.widgets.nattable.export.IOutputStreamProvider;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.style.CellStyleAttributes;
import org.eclipse.nebula.widgets.nattable.style.CellStyleProxy;
import org.eclipse.nebula.widgets.nattable.util.ObjectUtils;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Shell;

public class ExcelExporter
implements ILayerExporter {
    private static final String EXCEL_HEADER_FILE = "excelExportHeader.txt";
    private final IOutputStreamProvider outputStreamProvider;

    public ExcelExporter() {
        this(new FileOutputStreamProvider("table_export.xls", new String[]{"Excel Workbok (*.xls)"}, new String[]{"*.xls"}));
    }

    public ExcelExporter(IOutputStreamProvider outputStreamProvider) {
        this.outputStreamProvider = outputStreamProvider;
    }

    public OutputStream getOutputStream(Shell shell) {
        return this.outputStreamProvider.getOutputStream(shell);
    }

    public void exportBegin(OutputStream outputStream) throws IOException {
    }

    public void exportEnd(OutputStream outputStream) throws IOException {
    }

    public void exportLayerBegin(OutputStream outputStream, String layerName) throws IOException {
        this.writeHeader(outputStream);
        outputStream.write(this.asBytes("<body><table border='1'>"));
    }

    private void writeHeader(OutputStream outputStream) throws IOException {
        InputStream headerStream = null;
        try {
            try {
                int c;
                headerStream = this.getClass().getResourceAsStream(EXCEL_HEADER_FILE);
                while ((c = headerStream.read()) != -1) {
                    outputStream.write(c);
                }
            }
            catch (Exception e) {
                this.logError(e);
                if (ObjectUtils.isNotNull(headerStream)) {
                    headerStream.close();
                }
            }
        }
        finally {
            if (ObjectUtils.isNotNull(headerStream)) {
                headerStream.close();
            }
        }
    }

    public void exportLayerEnd(OutputStream outputStream, String layerName) throws IOException {
        outputStream.write(this.asBytes("</table></body></html>"));
    }

    public void exportRowBegin(OutputStream outputStream, int rowPosition) throws IOException {
        outputStream.write(this.asBytes("<tr>\n"));
    }

    public void exportRowEnd(OutputStream outputStream, int rowPosition) throws IOException {
        outputStream.write(this.asBytes("</tr>\n"));
    }

    public void exportCell(OutputStream outputStream, Object exportDisplayValue, ILayerCell cell, IConfigRegistry configRegistry) throws IOException {
        String htmlText;
        CellStyleProxy cellStyle = new CellStyleProxy(configRegistry, cell.getDisplayMode(), cell.getConfigLabels().getLabels());
        Color fg = cellStyle.getAttributeValue(CellStyleAttributes.FOREGROUND_COLOR);
        Color bg = cellStyle.getAttributeValue(CellStyleAttributes.BACKGROUND_COLOR);
        Font font = cellStyle.getAttributeValue(CellStyleAttributes.FONT);
        String htmlAttributes = String.format("style='color: %s; background-color: %s; %s;'", this.getColorInCSSFormat(fg), this.getColorInCSSFormat(bg), this.getFontInCSSFormat(font));
        String string = htmlText = exportDisplayValue != null ? exportDisplayValue.toString() : "";
        if (htmlText.startsWith(" ")) {
            htmlAttributes = String.valueOf(htmlAttributes) + " x:str=\"'" + htmlText + "\";";
            htmlText = htmlText.replaceFirst("^(\\ *)", "<span style='mso-spacerun:yes'>$1</span>");
        }
        outputStream.write(this.asBytes(String.format("\t<td %s>%s</td>\n", htmlAttributes, htmlText)));
    }

    private byte[] asBytes(String string) {
        return string.getBytes();
    }

    private void logError(Exception e) {
        System.err.println("Excel Exporter failed: " + e.getMessage());
        e.printStackTrace(System.err);
    }

    private String getFontInCSSFormat(Font font) {
        FontData fontData = font.getFontData()[0];
        String fontName = fontData.getName();
        int fontStyle = fontData.getStyle();
        String[] HTML_STYLES = new String[]{"NORMAL", "BOLD", "ITALIC"};
        return String.format("font: %s; font-family: %s", fontStyle <= 2 ? HTML_STYLES[fontStyle] : HTML_STYLES[0], fontName);
    }

    private String getColorInCSSFormat(Color color) {
        return String.format("rgb(%d,%d,%d)", color.getRed(), color.getGreen(), color.getBlue());
    }
}

