/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.edit.config;

import org.eclipse.nebula.widgets.nattable.edit.editor.AbstractEditErrorHandler;
import org.eclipse.nebula.widgets.nattable.edit.editor.ControlDecorationProvider;
import org.eclipse.nebula.widgets.nattable.edit.editor.ICellEditor;
import org.eclipse.nebula.widgets.nattable.edit.editor.IEditErrorHandler;
import org.eclipse.nebula.widgets.nattable.edit.editor.TextCellEditor;
import org.eclipse.nebula.widgets.nattable.util.GUIHelper;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Text;

public class RenderErrorHandling
extends AbstractEditErrorHandler {
    private Color originalColor;
    protected final ControlDecorationProvider decorationProvider;

    public RenderErrorHandling() {
        this(null, new ControlDecorationProvider());
    }

    public RenderErrorHandling(ControlDecorationProvider decorationProvider) {
        this(null, decorationProvider);
    }

    public RenderErrorHandling(IEditErrorHandler underlyingErrorHandler, ControlDecorationProvider decorationProvider) {
        super(underlyingErrorHandler);
        this.decorationProvider = decorationProvider;
    }

    public void removeError(ICellEditor cellEditor) {
        super.removeError(cellEditor);
        if (cellEditor instanceof TextCellEditor) {
            TextCellEditor textCellEditor = (TextCellEditor)cellEditor;
            Text textControl = textCellEditor.getTextControl();
            if (this.originalColor != null) {
                textControl.setForeground(this.originalColor);
                this.originalColor = null;
            }
            this.decorationProvider.hideDecoration();
        }
    }

    public void displayError(ICellEditor cellEditor, Exception e) {
        super.displayError(cellEditor, e);
        if (cellEditor instanceof TextCellEditor) {
            TextCellEditor textCellEditor = (TextCellEditor)cellEditor;
            Text textControl = textCellEditor.getTextControl();
            if (this.originalColor == null) {
                this.originalColor = textControl.getForeground();
            }
            textControl.setForeground(GUIHelper.COLOR_RED);
            this.decorationProvider.showDecoration();
        }
    }
}

