/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.edit;

import org.eclipse.nebula.widgets.nattable.edit.ICellEditHandler;
import org.eclipse.nebula.widgets.nattable.edit.command.UpdateDataCommand;
import org.eclipse.nebula.widgets.nattable.edit.editor.ICellEditor;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.selection.command.MoveSelectionCommand;

public class SingleEditHandler
implements ICellEditHandler {
    private final ICellEditor cellEditor;
    private final ILayer layer;
    private final int columnPosition;
    private final int rowPosition;

    public SingleEditHandler(ICellEditor cellEditor, ILayer layer, int columnPosition, int rowPosition) {
        this.cellEditor = cellEditor;
        this.layer = layer;
        this.columnPosition = columnPosition;
        this.rowPosition = rowPosition;
    }

    public boolean commit(SelectionLayer.MoveDirectionEnum direction, boolean closeEditorAfterCommit) {
        Object canonicalValue = this.cellEditor.getCanonicalValue();
        boolean committed = this.layer.doCommand(new UpdateDataCommand(this.layer, this.columnPosition, this.rowPosition, canonicalValue));
        switch (direction) {
            case LEFT: {
                this.layer.doCommand(new MoveSelectionCommand(SelectionLayer.MoveDirectionEnum.LEFT, 1, false, false));
                break;
            }
            case UP: {
                this.layer.doCommand(new MoveSelectionCommand(SelectionLayer.MoveDirectionEnum.UP, 1, false, false));
                break;
            }
            case RIGHT: {
                this.layer.doCommand(new MoveSelectionCommand(SelectionLayer.MoveDirectionEnum.RIGHT, 1, false, false));
                break;
            }
            case DOWN: {
                this.layer.doCommand(new MoveSelectionCommand(SelectionLayer.MoveDirectionEnum.DOWN, 1, false, false));
            }
        }
        if (committed && closeEditorAfterCommit) {
            this.cellEditor.close();
            return true;
        }
        return committed;
    }
}

