/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.config;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.style.ConfigAttribute;
import org.eclipse.nebula.widgets.nattable.style.DefaultDisplayModeOrdering;
import org.eclipse.nebula.widgets.nattable.style.IDisplayModeOrdering;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigRegistry
implements IConfigRegistry {
    Map<ConfigAttribute<?>, Map<String, Map<String, ?>>> configRegistry = new HashMap();
    IDisplayModeOrdering displayModeOrdering = new DefaultDisplayModeOrdering();

    @Override
    public <T> T getConfigAttribute(ConfigAttribute<T> configAttribute, String targetDisplayMode, String ... configLabels) {
        return this.getConfigAttribute(configAttribute, targetDisplayMode, Arrays.asList(configLabels));
    }

    @Override
    public <T> T getConfigAttribute(ConfigAttribute<T> configAttribute, String targetDisplayMode, List<String> configLabels) {
        T attributeValue = null;
        Map<String, Map<String, ?>> displayModeConfigAttributeMap = this.configRegistry.get(configAttribute);
        if (displayModeConfigAttributeMap != null) {
            for (String displayMode : this.displayModeOrdering.getDisplayModeOrdering(targetDisplayMode)) {
                Map<String, ?> configAttributeMap = displayModeConfigAttributeMap.get(displayMode);
                if (configAttributeMap == null) continue;
                for (String configLabel : configLabels) {
                    attributeValue = (T)configAttributeMap.get(configLabel);
                    if (attributeValue == null) continue;
                    return attributeValue;
                }
                attributeValue = (T)configAttributeMap.get(null);
                if (attributeValue == null) continue;
                return attributeValue;
            }
        }
        return attributeValue;
    }

    @Override
    public <T> T getSpecificConfigAttribute(ConfigAttribute<T> configAttribute, String displayMode, String configLabel) {
        Map<String, ?> configAttributeMap;
        T attributeValue = null;
        Map<String, Map<String, ?>> displayModeConfigAttributeMap = this.configRegistry.get(configAttribute);
        if (displayModeConfigAttributeMap != null && (configAttributeMap = displayModeConfigAttributeMap.get(displayMode)) != null && (attributeValue = (T)configAttributeMap.get(configLabel)) != null) {
            return attributeValue;
        }
        return attributeValue;
    }

    @Override
    public <T> void registerConfigAttribute(ConfigAttribute<T> configAttribute, T attributeValue) {
        this.registerConfigAttribute(configAttribute, attributeValue, "NORMAL");
    }

    @Override
    public <T> void registerConfigAttribute(ConfigAttribute<T> configAttribute, T attributeValue, String displayMode) {
        this.registerConfigAttribute(configAttribute, attributeValue, displayMode, null);
    }

    @Override
    public <T> void registerConfigAttribute(ConfigAttribute<T> configAttribute, T attributeValue, String displayMode, String configLabel) {
        Map<String, ?> configAttributeMap;
        Map<String, Map<String, ?>> displayModeConfigAttributeMap = this.configRegistry.get(configAttribute);
        if (displayModeConfigAttributeMap == null) {
            displayModeConfigAttributeMap = new HashMap();
            this.configRegistry.put(configAttribute, displayModeConfigAttributeMap);
        }
        if ((configAttributeMap = displayModeConfigAttributeMap.get(displayMode)) == null) {
            configAttributeMap = new HashMap();
            displayModeConfigAttributeMap.put(displayMode, configAttributeMap);
        }
        configAttributeMap.put(configLabel, attributeValue);
    }

    @Override
    public <T> void unregisterConfigAttribute(ConfigAttribute<T> configAttributeType, String displayMode, String configLabel) {
        Map<String, ?> configAttributeMap;
        Map<String, Map<String, ?>> displayModeConfigAttributeMap = this.configRegistry.get(configAttributeType);
        if (displayModeConfigAttributeMap != null && (configAttributeMap = displayModeConfigAttributeMap.get(displayMode)) != null) {
            configAttributeMap.remove(configLabel);
        }
    }

    @Override
    public IDisplayModeOrdering getDisplayModeOrdering() {
        return this.displayModeOrdering;
    }

    public void setDisplayModeOrdering(IDisplayModeOrdering displayModeOrdering) {
        this.displayModeOrdering = displayModeOrdering;
    }
}

