/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.command;

import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.nebula.widgets.nattable.command.LayerCommandUtil;
import org.eclipse.nebula.widgets.nattable.coordinate.PositionCoordinate;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;

public abstract class AbstractPositionCommand
implements ILayerCommand {
    private PositionCoordinate positionCoordinate;

    protected AbstractPositionCommand(ILayer layer, int columnPosition, int rowPosition) {
        this.positionCoordinate = new PositionCoordinate(layer, columnPosition, rowPosition);
    }

    protected AbstractPositionCommand(AbstractPositionCommand command) {
        this.positionCoordinate = command.positionCoordinate;
    }

    public boolean convertToTargetLayer(ILayer targetLayer) {
        this.positionCoordinate = LayerCommandUtil.convertPositionToTargetContext(this.positionCoordinate, targetLayer);
        return this.positionCoordinate != null;
    }

    public int getColumnPosition() {
        return this.positionCoordinate.getColumnPosition();
    }

    public int getRowPosition() {
        return this.positionCoordinate.getRowPosition();
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " columnPosition=" + this.positionCoordinate.getColumnPosition() + ", rowPosition=" + this.positionCoordinate.getRowPosition();
    }
}

