/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.sandbox.ui.hyperlinks;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.ui.JavaUIMessages;
import org.eclipse.jdt.internal.ui.dialogs.OpenTypeSelectionDialog;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;

public class JavaResourceHyperlink
implements IHyperlink {
    private final IRegion region;
    private final String typeName;

    public JavaResourceHyperlink(IRegion region, String typeName) {
        this.region = region;
        this.typeName = typeName;
    }

    public IRegion getHyperlinkRegion() {
        return this.region;
    }

    public String getHyperlinkText() {
        return "Open " + this.typeName;
    }

    public String getTypeLabel() {
        return null;
    }

    public void open() {
        this.startSourceSearch(this.typeName);
    }

    protected void startSourceSearch(final String typeName) {
        Job search = new Job("Searching..."){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    final ArrayList<IType> results = new ArrayList<IType>();
                    SearchRequestor collector = new SearchRequestor(){

                        public void acceptSearchMatch(SearchMatch match) throws CoreException {
                            Object element = match.getElement();
                            if (element instanceof IType) {
                                results.add((IType)element);
                            }
                        }
                    };
                    SearchEngine engine = new SearchEngine();
                    SearchPattern pattern = SearchPattern.createPattern((String)typeName, (int)0, (int)0, (int)8);
                    engine.search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, SearchEngine.createWorkspaceScope(), collector, monitor);
                    JavaResourceHyperlink.this.searchCompleted(results, typeName, null);
                }
                catch (CoreException e) {
                    JavaResourceHyperlink.this.searchCompleted(null, typeName, e.getStatus());
                }
                return Status.OK_STATUS;
            }
        };
        search.schedule();
    }

    protected void searchCompleted(final List<IType> sources, final String typeName, IStatus status) {
        UIJob job = new UIJob("link search complete"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                if (sources.size() > 1) {
                    JavaResourceHyperlink.this.openTypeDialog(typeName);
                } else if (sources.size() == 1 && sources.get(0) != null) {
                    IType type = (IType)sources.get(0);
                    JavaResourceHyperlink.this.processSearchResult(type, typeName);
                } else {
                    MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Open Type", (String)"Type could not be located.");
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    protected void processSearchResult(Object source, String typeName) {
        String editorId;
        IDebugModelPresentation presentation = JDIDebugUIPlugin.getDefault().getModelPresentation();
        IEditorInput editorInput = presentation.getEditorInput(source);
        if (editorInput != null && (editorId = presentation.getEditorId(editorInput, source)) != null) {
            try {
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor(editorInput, editorId);
            }
            catch (CoreException coreException) {
                MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Open Type", (String)"Failed to open type.");
            }
        }
    }

    private void openTypeDialog(String typeName) {
        OpenTypeSelectionDialog dialog = new OpenTypeSelectionDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), true, (IRunnableContext)PlatformUI.getWorkbench().getProgressService(), null, 0);
        dialog.setTitle("Open Hyperlink");
        dialog.setMessage("More than one types are detected, please select one:");
        dialog.setHelpAvailable(false);
        dialog.setInitialPattern(typeName);
        int result = dialog.open();
        if (result != 0) {
            return;
        }
        Object[] types = dialog.getResult();
        if (types != null && types.length > 0) {
            IType type = null;
            Object[] objectArray = types;
            int n = types.length;
            int n2 = 0;
            while (n2 < n) {
                Object type2 = objectArray[n2];
                type = (IType)type2;
                try {
                    JavaUI.openInEditor((IJavaElement)type, (boolean)true, (boolean)true);
                }
                catch (CoreException x) {
                    ExceptionHandler.handle((CoreException)x, (String)JavaUIMessages.OpenTypeAction_errorTitle, (String)JavaUIMessages.OpenTypeAction_errorMessage);
                }
                ++n2;
            }
        }
    }
}

