/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.runtime.ui.wizards;

import java.util.Iterator;
import java.util.List;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.m2m.internal.qvt.oml.common.MdaException;
import org.eclipse.m2m.internal.qvt.oml.common.launch.InMemoryLaunchUtils;
import org.eclipse.m2m.internal.qvt.oml.common.launch.TargetUriData;
import org.eclipse.m2m.internal.qvt.oml.common.ui.wizards.PersistedValuesWizard;
import org.eclipse.m2m.internal.qvt.oml.emf.util.EmfUtil;
import org.eclipse.m2m.internal.qvt.oml.emf.util.Logger;
import org.eclipse.m2m.internal.qvt.oml.emf.util.ModelContent;
import org.eclipse.m2m.internal.qvt.oml.emf.util.ui.choosers.IMetamodelHandler;
import org.eclipse.m2m.internal.qvt.oml.emf.util.ui.choosers.MetamodelHandlerManager;
import org.eclipse.m2m.internal.qvt.oml.runtime.launch.QvtLaunchUtil;
import org.eclipse.m2m.internal.qvt.oml.runtime.project.QvtInterpretedTransformation;
import org.eclipse.m2m.internal.qvt.oml.runtime.project.QvtTransformation;
import org.eclipse.m2m.internal.qvt.oml.runtime.project.TransformationUtil;
import org.eclipse.m2m.internal.qvt.oml.runtime.ui.QvtRuntimePluginImages;
import org.eclipse.m2m.internal.qvt.oml.runtime.ui.QvtRuntimeUIPlugin;
import org.eclipse.m2m.internal.qvt.oml.runtime.ui.wizards.ApplyTransformationData;
import org.eclipse.m2m.internal.qvt.oml.runtime.ui.wizards.Messages;
import org.eclipse.m2m.internal.qvt.oml.runtime.ui.wizards.QvtTransformationConfigurationPage;
import org.eclipse.m2m.internal.qvt.oml.runtime.ui.wizards.SelectInterpretedTransformationPage;
import org.eclipse.m2m.internal.qvt.oml.runtime.ui.wizards.TransformationParametersPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.plugin.AbstractUIPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RunInterpretedTransformationWizard
extends PersistedValuesWizard {
    private final SelectInterpretedTransformationPage mySelectTransformationPage;
    private final TransformationParametersPage myTransformationParametersPage;
    private final QvtTransformationConfigurationPage myQvtTransformationConfigurationPage;
    private final ApplyTransformationData myTransformationData;
    private final URI myTransfUri;
    private QvtTransformation myTransformation;

    public RunInterpretedTransformationWizard(URI uriTransf, List<URI> paramUris) {
        super((AbstractUIPlugin)QvtRuntimeUIPlugin.getDefault());
        this.myTransfUri = uriTransf;
        this.setNeedsProgressMonitor(false);
        this.setWindowTitle(Messages.LaunchWorkspaceTransformationWizard_Title);
        ImageDescriptor desc = QvtRuntimePluginImages.getInstance().getImageDescriptor("apply_wizard");
        this.setDefaultPageImageDescriptor(desc);
        this.myTransformationData = new ApplyTransformationData();
        this.mySelectTransformationPage = new SelectInterpretedTransformationPage("SelectTransfromationPageId");
        this.mySelectTransformationPage.setTitle(Messages.SelectWorkspaceTransformationPage_Title);
        this.myTransformationParametersPage = new TransformationParametersPage("TransformationParametersPageId", paramUris);
        this.myTransformationParametersPage.setTitle(Messages.TransformationParametersPage_Title);
        this.myQvtTransformationConfigurationPage = new QvtTransformationConfigurationPage("QvtTransformationConfigurationPage", this.myTransformationData);
        this.myQvtTransformationConfigurationPage.setTitle(Messages.ApplyTransformationWizard_ConfigProperties);
        this.myQvtTransformationConfigurationPage.setDescription(Messages.ApplyTransformationWizard_SetupConfigProperty);
    }

    public void addPages() {
        QvtInterpretedTransformation transformation = null;
        if (this.myTransfUri != null) {
            try {
                transformation = new QvtInterpretedTransformation(TransformationUtil.getQvtModule((URI)this.myTransfUri));
                List parameters = transformation.getParameters();
                if (parameters.isEmpty()) {
                    transformation = null;
                }
            }
            catch (Exception e) {
                transformation = null;
            }
        }
        if (transformation == null) {
            this.addPage((IWizardPage)this.mySelectTransformationPage);
        } else {
            this.setQvtTransformation((QvtTransformation)transformation);
        }
        this.addPage((IWizardPage)this.myTransformationParametersPage);
        this.addPage((IWizardPage)this.myQvtTransformationConfigurationPage);
        super.addPages();
    }

    protected void saveValues() {
    }

    public void dispose() {
        super.dispose();
        try {
            if (this.myTransformation != null) {
                this.myTransformation.cleanup();
            }
        }
        catch (MdaException mdaException) {
            // empty catch block
        }
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.mySelectTransformationPage) {
            this.setQvtTransformation(this.mySelectTransformationPage.getTransformation());
        }
        if (page == this.myTransformationParametersPage) {
            try {
                if (this.myTransformation.getConfigurationProperties().size() <= 0) {
                    return null;
                }
            }
            catch (MdaException e) {
                return null;
            }
        }
        return super.getNextPage(page);
    }

    protected boolean performFinishBody() {
        try {
            ILaunchConfigurationWorkingCopy workingCopy = this.createLaunchConfiguration();
            DebugUITools.launch((ILaunchConfiguration)workingCopy, (String)"run");
        }
        catch (Exception e) {
            String message = NLS.bind((String)Messages.LaunchWorkspaceTransformationWizard_FailedToLaunch, (Object)this.myTransformation);
            Logger.getLogger().log(Logger.SEVERE, message, e);
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.LaunchWorkspaceTransformationWizard_Error, (String)message);
        }
        return true;
    }

    private ILaunchConfigurationWorkingCopy createLaunchConfiguration() throws Exception {
        ILaunchConfigurationWorkingCopy workingCopy = QvtLaunchUtil.getInMemoryLaunchConfigurationType().newInstance(null, "QVTO");
        workingCopy.setAttribute("org.eclipse.debug.ui.ATTR_LAUNCH_IN_BACKGROUND", false);
        InMemoryLaunchUtils.setAttribute((ILaunchConfigurationWorkingCopy)workingCopy, (String)"org.eclipse.m2m.qvt.oml.interpreter.transformationId", (Object)this.myTransformation);
        this.myTransformationParametersPage.applyConfiguration(workingCopy);
        if (this.myTransformationParametersPage.isOpenInEditor()) {
            List targetUris = QvtLaunchUtil.getTargetUris((ILaunchConfiguration)workingCopy);
            InMemoryLaunchUtils.setAttribute((ILaunchConfigurationWorkingCopy)workingCopy, (String)"org.eclipse.m2m.qvt.oml.interpreter.doneAction", (Object)this.createShowResultAction(targetUris));
        }
        workingCopy.setAttribute("org.eclipse.m2m.qvt.oml.interpreter.configurationProperties", this.myTransformationData.getConfiguration());
        return workingCopy;
    }

    private Runnable createShowResultAction(final List<TargetUriData> targetUris) {
        if (this.myTransformation == null) {
            return null;
        }
        return new Runnable(){

            public void run() {
                IWorkbenchPage page = QvtRuntimeUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
                Iterator itrTargetData = targetUris.iterator();
                try {
                    for (QvtTransformation.TransformationParameter transfParam : RunInterpretedTransformationWizard.this.myTransformation.getParameters()) {
                        if (itrTargetData.hasNext()) {
                            TargetUriData targetData = (TargetUriData)itrTargetData.next();
                            if (transfParam.getDirectionKind() == QvtTransformation.TransformationParameter.DirectionKind.IN) continue;
                            IMetamodelHandler handler = MetamodelHandlerManager.getInstance().getHandler(String.valueOf(targetData.getUri()));
                            ModelContent result = EmfUtil.loadModel((URI)targetData.getUri());
                            if (result == null || result.getContent().isEmpty()) {
                                return;
                            }
                            try {
                                handler.getSaver().select((EObject)result.getContent().get(0), page);
                            }
                            catch (Exception e) {
                                Logger.getLogger().log(Logger.SEVERE, Messages.LaunchWorkspaceTransformationWizard_ShowResultError, e);
                            }
                            continue;
                        }
                        break;
                    }
                }
                catch (MdaException e) {
                    Logger.getLogger().log(Logger.SEVERE, Messages.LaunchWorkspaceTransformationWizard_ShowResultError, e);
                }
            }
        };
    }

    private void setQvtTransformation(QvtTransformation transformation) {
        this.myTransformation = transformation;
        this.myTransformationParametersPage.setTransformation(this.myTransformation);
        this.myTransformationData.setTransformation(this.myTransformation);
    }
}

