/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.qvt.oml.util;

import java.io.IOException;
import java.io.Writer;
import java.text.MessageFormat;
import org.eclipse.m2m.internal.qvt.oml.QvtPlugin;
import org.eclipse.m2m.qvt.oml.util.Log;

public class WriterLog
implements Log {
    private static final String LINE_SEP = System.getProperty("line.separator");
    private Writer fWriter;
    private String fRecordSeparator;
    private boolean fFlush;
    private boolean fErrorLogged;

    public WriterLog(Writer writer) {
        this(writer, true);
    }

    public WriterLog(Writer writer, boolean flush) {
        if (writer == null) {
            throw new IllegalArgumentException("null writer");
        }
        this.fWriter = writer;
        this.fRecordSeparator = LINE_SEP;
        this.fErrorLogged = false;
        this.fFlush = flush;
    }

    protected final Writer getWriter() {
        return this.fWriter;
    }

    public void log(int level, String message, Object param) {
        String recordStr = MessageFormat.format("Level {0} - {1}, data: {2}", level, message, String.valueOf(param));
        this.logRecord(recordStr);
    }

    public void log(int level, String message) {
        String recordStr = MessageFormat.format("Level {0} - {1}", level, message);
        this.logRecord(recordStr);
    }

    public void log(String message, Object param) {
        String recordStr = MessageFormat.format("{0}, data: {1}", message, String.valueOf(param));
        this.logRecord(recordStr);
    }

    public void log(String message) {
        this.logRecord(message);
    }

    private void logRecord(String recordStr) {
        block3: {
            try {
                this.fWriter.write(recordStr);
                this.fWriter.write(this.fRecordSeparator);
                if (this.fFlush) {
                    this.fWriter.flush();
                }
            }
            catch (IOException e) {
                if (this.fErrorLogged) break block3;
                QvtPlugin.error(e);
                this.fErrorLogged = true;
            }
        }
    }
}

