/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.uml.internal.operations;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.uml2.common.util.UnionEObjectEList;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Component;
import org.eclipse.uml2.uml.ComponentRealization;
import org.eclipse.uml2.uml.Dependency;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.PrimitiveType;
import org.eclipse.uml2.uml.Realization;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.Usage;
import org.eclipse.uml2.uml.internal.operations.ClassOperations;

public class ComponentOperations
extends ClassOperations {
    protected ComponentOperations() {
    }

    public static Class createOwnedClass(Component component, String name, boolean isAbstract) {
        Class ownedClass = (Class)component.createPackagedElement(name, UMLPackage.Literals.CLASS);
        ownedClass.setIsAbstract(isAbstract);
        return ownedClass;
    }

    public static Enumeration createOwnedEnumeration(Component component, String name) {
        return (Enumeration)component.createPackagedElement(name, UMLPackage.Literals.ENUMERATION);
    }

    public static PrimitiveType createOwnedPrimitiveType(Component component, String name) {
        return (PrimitiveType)component.createPackagedElement(name, UMLPackage.Literals.PRIMITIVE_TYPE);
    }

    public static Interface createOwnedInterface(Component component, String name) {
        return (Interface)component.createPackagedElement(name, UMLPackage.Literals.INTERFACE);
    }

    public static EList realizedInterfaces(Component component, Classifier classifier) {
        return ECollections.unmodifiableEList((EList)ComponentOperations.realizedInterfaces(component, classifier, true));
    }

    protected static EList realizedInterfaces(Component component, Classifier classifier, boolean resolve) {
        return ComponentOperations.realizedInterfaces(component, classifier, resolve, (EList)new UniqueEList.FastCompare());
    }

    protected static EList realizedInterfaces(Component component, Classifier classifier, boolean resolve, EList realizedInterfaces) {
        Iterator clientDependencies = classifier.getClientDependencies().iterator();
        while (clientDependencies.hasNext()) {
            Dependency dependency = (Dependency)clientDependencies.next();
            if (!(dependency instanceof Realization)) continue;
            Iterator suppliers = resolve ? dependency.getSuppliers().iterator() : ((InternalEList)dependency.getSuppliers()).basicIterator();
            while (suppliers.hasNext()) {
                Object supplier = suppliers.next();
                if (!(supplier instanceof Interface)) continue;
                realizedInterfaces.add(supplier);
            }
        }
        return realizedInterfaces;
    }

    public static EList usedInterfaces(Component component, Classifier classifier) {
        return ECollections.unmodifiableEList((EList)ComponentOperations.usedInterfaces(component, classifier, true));
    }

    protected static EList usedInterfaces(Component component, Classifier classifier, boolean resolve) {
        return ComponentOperations.usedInterfaces(component, classifier, resolve, (EList)new UniqueEList.FastCompare());
    }

    protected static EList usedInterfaces(Component component, Classifier classifier, boolean resolve, EList usedInterfaces) {
        Iterator clientDependencies = classifier.getClientDependencies().iterator();
        while (clientDependencies.hasNext()) {
            Dependency dependency = (Dependency)clientDependencies.next();
            if (!(dependency instanceof Usage)) continue;
            Iterator suppliers = resolve ? dependency.getSuppliers().iterator() : ((InternalEList)dependency.getSuppliers()).basicIterator();
            while (suppliers.hasNext()) {
                Object supplier = suppliers.next();
                if (!(supplier instanceof Interface)) continue;
                usedInterfaces.add(supplier);
            }
        }
        return usedInterfaces;
    }

    public static EList getRequireds(Component component) {
        EList requireds = ComponentOperations.usedInterfaces(component, component, false, (EList)new UniqueEList.FastCompare());
        Iterator realizations = component.getRealizations().iterator();
        while (realizations.hasNext()) {
            Classifier realizingClassifier = ((ComponentRealization)realizations.next()).getRealizingClassifier();
            if (realizingClassifier == null) continue;
            ComponentOperations.usedInterfaces(component, realizingClassifier, false, requireds);
            Iterator allParents = realizingClassifier.allParents().iterator();
            while (allParents.hasNext()) {
                ComponentOperations.usedInterfaces(component, (Classifier)allParents.next(), false, requireds);
            }
        }
        Iterator ownedPorts = component.getOwnedPorts().iterator();
        while (ownedPorts.hasNext()) {
            requireds.addAll((Collection)((InternalEList)((Port)ownedPorts.next()).getRequireds()).basicList());
        }
        return new UnionEObjectEList((InternalEObject)component, (EStructuralFeature)UMLPackage.Literals.COMPONENT__REQUIRED, requireds.size(), requireds.toArray());
    }

    public static EList getProvideds(Component component) {
        EList provideds = ComponentOperations.realizedInterfaces(component, component, false, (EList)new UniqueEList.FastCompare());
        Iterator realizations = component.getRealizations().iterator();
        while (realizations.hasNext()) {
            Classifier realizingClassifier = ((ComponentRealization)realizations.next()).getRealizingClassifier();
            if (realizingClassifier == null) continue;
            ComponentOperations.realizedInterfaces(component, realizingClassifier, false, provideds);
            Iterator allParents = realizingClassifier.allParents().iterator();
            while (allParents.hasNext()) {
                ComponentOperations.realizedInterfaces(component, (Classifier)allParents.next(), false, provideds);
            }
        }
        Iterator ownedPorts = component.getOwnedPorts().iterator();
        while (ownedPorts.hasNext()) {
            provideds.addAll((Collection)((InternalEList)((Port)ownedPorts.next()).getProvideds()).basicList());
        }
        return new UnionEObjectEList((InternalEObject)component, (EStructuralFeature)UMLPackage.Literals.COMPONENT__PROVIDED, provideds.size(), provideds.toArray());
    }

    protected static EList getAllProvideds(Component component, EList allProvideds) {
        allProvideds.addAll((Collection)component.getProvideds());
        Iterator allParents = component.allParents().iterator();
        while (allParents.hasNext()) {
            Object parent = allParents.next();
            if (parent instanceof Component) {
                allProvideds.addAll((Collection)((Component)parent).getProvideds());
                continue;
            }
            ComponentOperations.realizedInterfaces(component, (Classifier)parent, true, allProvideds);
        }
        return allProvideds;
    }

    protected static EList getAllRequireds(Component component, EList allRequireds) {
        allRequireds.addAll((Collection)component.getRequireds());
        Iterator allParents = component.allParents().iterator();
        while (allParents.hasNext()) {
            Object parent = allParents.next();
            if (parent instanceof Component) {
                allRequireds.addAll((Collection)((Component)parent).getRequireds());
                continue;
            }
            ComponentOperations.usedInterfaces(component, (Classifier)parent, true, allRequireds);
        }
        return allRequireds;
    }
}

