/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.common.util;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.plugin.RegistryReader;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.uml2.common.CommonPlugin;
import org.eclipse.uml2.common.util.UML2Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheAdapter
extends ECrossReferenceAdapter {
    private static CacheAdapter INSTANCE = CacheAdapter.createCacheAdapter();
    protected static final ThreadLocal<CacheAdapter> THREAD_LOCAL = System.getProperty("org.eclipse.uml2.common.util.CacheAdapter.ThreadLocal") != null ? new ThreadLocal<CacheAdapter>(){

        @Override
        protected CacheAdapter initialValue() {
            return CacheAdapter.createCacheAdapter();
        }
    } : null;
    private final Map<Resource, Map<EObject, Map<Object, Object>>> values = Collections.synchronizedMap(this.createHashMap());
    protected boolean adapting = false;
    protected URIConverter uriConverter = null;

    public static CacheAdapter getInstance() {
        return THREAD_LOCAL == null ? INSTANCE : THREAD_LOCAL.get();
    }

    private static CacheAdapter createCacheAdapter() {
        CacheAdapter cacheAdapter = (CacheAdapter)((Object)UML2Util.loadClassFromSystemProperty("org.eclipse.uml2.common.util.CacheAdapter.INSTANCE"));
        if (cacheAdapter != null) {
            return cacheAdapter;
        }
        if (EMFPlugin.IS_ECLIPSE_RUNNING) {
            OverrideRegistryReader registryReader = new OverrideRegistryReader();
            registryReader.readRegistry();
            cacheAdapter = registryReader.getCacheAdapter();
            if (cacheAdapter != null) {
                return cacheAdapter;
            }
        }
        return new CacheAdapter();
    }

    public static CacheAdapter getCacheAdapter(Notifier notifier) {
        EList eAdapters = notifier.eAdapters();
        int i = 0;
        int size = eAdapters.size();
        while (i < size) {
            Object adapter = eAdapters.get(i);
            if (adapter instanceof CacheAdapter) {
                return (CacheAdapter)((Object)adapter);
            }
            ++i;
        }
        return null;
    }

    public CacheAdapter() {
        this.unloadedEObjects = Collections.synchronizedMap(this.createHashMap());
        this.unloadedResources = new Set<Resource>(){
            Map<Resource, Object> map = new WeakHashMap<Resource, Object>();

            @Override
            public boolean add(Resource o) {
                if (this.map.containsKey(o)) {
                    return false;
                }
                this.map.put(o, null);
                return true;
            }

            @Override
            public boolean addAll(Collection<? extends Resource> c) {
                boolean result = false;
                for (Resource resource : c) {
                    if (!this.add(resource)) continue;
                    result = true;
                }
                return result;
            }

            @Override
            public void clear() {
                this.map.keySet().clear();
            }

            @Override
            public boolean contains(Object o) {
                return this.map.keySet().contains(o);
            }

            @Override
            public boolean containsAll(Collection<?> c) {
                return this.map.keySet().containsAll(c);
            }

            @Override
            public boolean isEmpty() {
                return this.map.keySet().isEmpty();
            }

            @Override
            public Iterator<Resource> iterator() {
                return this.map.keySet().iterator();
            }

            @Override
            public boolean remove(Object o) {
                return this.map.keySet().remove(o);
            }

            @Override
            public boolean removeAll(Collection<?> c) {
                return this.map.keySet().removeAll(c);
            }

            @Override
            public boolean retainAll(Collection<?> c) {
                return this.map.keySet().retainAll(c);
            }

            @Override
            public int size() {
                return this.map.keySet().size();
            }

            @Override
            public Object[] toArray() {
                return this.map.keySet().toArray();
            }

            @Override
            public <T> T[] toArray(T[] a) {
                return this.map.keySet().toArray(a);
            }
        };
    }

    protected <K, V> Map<K, V> createHashMap() {
        return new HashMap();
    }

    protected ECrossReferenceAdapter.InverseCrossReferencer createInverseCrossReferencer() {
        return new InverseCrossReferencer();
    }

    protected boolean addAdapter(EList<Adapter> adapters) {
        int index = adapters.indexOf((Object)this);
        switch (index) {
            case 0: {
                break;
            }
            case -1: {
                adapters.add(0, (Object)this);
                return true;
            }
            default: {
                adapters.move(0, index);
            }
        }
        return false;
    }

    public boolean adapt(Notifier notifier) {
        boolean result = false;
        if (notifier != null) {
            try {
                this.adapting = true;
                result = this.addAdapter((EList<Adapter>)notifier.eAdapters());
            }
            finally {
                this.adapting = false;
            }
        }
        return result;
    }

    protected void addAdapter(Notifier notifier) {
        this.addAdapter((EList<Adapter>)notifier.eAdapters());
    }

    protected void addAdapter(EObject eObject) {
        if (eObject != null && !eObject.eIsProxy()) {
            Resource eResource = eObject.eResource();
            if (eResource == null) {
                this.addAdapter((EList<Adapter>)EcoreUtil.getRootContainer((EObject)eObject).eAdapters());
            } else {
                ResourceSet resourceSet = eResource.getResourceSet();
                if (resourceSet == null) {
                    this.addAdapter((EList<Adapter>)eResource.eAdapters());
                } else {
                    this.addAdapter((EList<Adapter>)resourceSet.eAdapters());
                }
            }
        }
    }

    protected ECrossReferenceAdapter provideCrossReferenceAdapter(EObject eObject) {
        return CacheAdapter.getCrossReferenceAdapter((Notifier)eObject);
    }

    public Collection<EStructuralFeature.Setting> getNonNavigableInverseReferences(EObject eObject) {
        this.addAdapter(eObject);
        return super.getNonNavigableInverseReferences(eObject);
    }

    public Collection<EStructuralFeature.Setting> getInverseReferences(EObject eObject) {
        this.addAdapter(eObject);
        return super.getInverseReferences(eObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleCrossReference(EObject eObject) {
        ECrossReferenceAdapter.InverseCrossReferencer inverseCrossReferencer = this.inverseCrossReferencer;
        synchronized (inverseCrossReferencer) {
            this.inverseCrossReferencer.add(eObject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleCrossReference(EReference reference, Notification notification) {
        ECrossReferenceAdapter.InverseCrossReferencer inverseCrossReferencer = this.inverseCrossReferencer;
        synchronized (inverseCrossReferencer) {
            super.handleCrossReference(reference, notification);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTarget(Notifier target) {
        if (!this.adapting) {
            ECrossReferenceAdapter.InverseCrossReferencer inverseCrossReferencer = this.inverseCrossReferencer;
            synchronized (inverseCrossReferencer) {
                super.setTarget(target);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unsetTarget(EObject target) {
        ECrossReferenceAdapter.InverseCrossReferencer inverseCrossReferencer = this.inverseCrossReferencer;
        synchronized (inverseCrossReferencer) {
            super.unsetTarget(target);
        }
        if (this.uriConverter == null) {
            this.clear(target.eResource());
        }
    }

    protected void unsetTarget(Resource target) {
        super.unsetTarget(target);
        this.clear(target);
    }

    public void notifyChanged(Notification msg) {
        block10: {
            Object notifier;
            block9: {
                super.notifyChanged(msg);
                notifier = msg.getNotifier();
                if (!(notifier instanceof Resource)) break block9;
                switch (msg.getFeatureID(Resource.class)) {
                    case 2: {
                        ResourceSet resourceSet;
                        Resource resource;
                        this.clear();
                        if (this.uriConverter == null && !(resource = (Resource)notifier).isLoaded() && (resourceSet = resource.getResourceSet()) != null) {
                            this.uriConverter = resourceSet.getURIConverter();
                            break;
                        }
                        break block10;
                    }
                    case 4: {
                        if (msg.getNewBooleanValue()) break block10;
                        this.uriConverter = null;
                    }
                    default: {
                        break;
                    }
                    {
                    }
                }
                break block10;
            }
            if (notifier instanceof EObject && !msg.isTouch()) {
                this.clear(((EObject)notifier).eResource());
            }
        }
    }

    public void clear() {
        this.values.clear();
    }

    public void clear(Resource resource) {
        this.values.remove(resource);
        if (resource != null) {
            this.values.remove(null);
        }
    }

    public boolean containsKey(EObject eObject, Object key) {
        return this.containsKey(null, eObject, key);
    }

    public boolean containsKey(Resource resource, EObject eObject, Object key) {
        Map<Object, Object> eObjectMap;
        Map<EObject, Map<Object, Object>> resourceMap = this.values.get(resource);
        if (resourceMap != null && (eObjectMap = resourceMap.get(eObject)) != null) {
            return eObjectMap.containsKey(key);
        }
        return false;
    }

    public Object get(EObject eObject, Object key) {
        return this.get(null, eObject, key);
    }

    public Object get(Resource resource, EObject eObject, Object key) {
        Map<Object, Object> eObjectMap;
        Map<EObject, Map<Object, Object>> resourceMap = this.values.get(resource);
        if (resourceMap != null && (eObjectMap = resourceMap.get(eObject)) != null) {
            return eObjectMap.get(key);
        }
        return null;
    }

    public Object put(EObject eObject, Object key, Object value) {
        return this.put(null, eObject, key, value);
    }

    public Object put(Resource resource, EObject eObject, Object key, Object value) {
        Map<Object, Object> eObjectMap;
        Map<Object, Map<Object, Object>> resourceMap;
        if (key == null) {
            throw new IllegalArgumentException(String.valueOf(key));
        }
        if (resource != null) {
            this.addAdapter((Notifier)resource);
        }
        if ((resourceMap = this.values.get(resource)) == null) {
            resourceMap = Collections.synchronizedMap(this.createHashMap());
            this.values.put(resource, resourceMap);
        }
        if ((eObjectMap = resourceMap.get(eObject)) == null) {
            eObjectMap = Collections.synchronizedMap(this.createHashMap());
            resourceMap.put(eObject, eObjectMap);
        }
        return eObjectMap.put(key, value);
    }

    protected boolean resolve() {
        return false;
    }

    protected boolean isIncluded(EReference eReference) {
        return super.isIncluded(eReference) && eReference.isChangeable();
    }

    public Map<URI, List<EObject>> getProxyMap() {
        return ((InverseCrossReferencer)this.inverseCrossReferencer).getProxyMap();
    }

    protected void resolveProxy(Resource resource, EObject eObject, EObject proxy, EStructuralFeature.Setting setting) {
        Resource eResource = setting.getEObject().eResource();
        if (eResource != null && eResource.getResourceSet() == resource.getResourceSet()) {
            super.resolveProxy(resource, eObject, proxy, setting);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void selfAdapt(Notification notification) {
        Object notifier = notification.getNotifier();
        if (notifier instanceof Resource && notification.getFeatureID(Resource.class) == 4) {
            if (notification.getNewBooleanValue()) {
                this.unloadedResources.remove(notifier);
                for (Notifier child : ((Resource)notifier).getContents()) {
                    this.addAdapter(child);
                }
            } else {
                this.unloadedResources.add((Resource)notifier);
                Map map = this.unloadedEObjects;
                synchronized (map) {
                    Iterator i = this.unloadedEObjects.entrySet().iterator();
                    while (i.hasNext()) {
                        Map.Entry entry = i.next();
                        if (entry.getValue() != notifier) continue;
                        i.remove();
                        EObject eObject = (EObject)entry.getKey();
                        ECrossReferenceAdapter.InverseCrossReferencer inverseCrossReferencer = this.inverseCrossReferencer;
                        synchronized (inverseCrossReferencer) {
                            Collection settings = (Collection)this.inverseCrossReferencer.get((Object)eObject);
                            if (settings != null) {
                                for (EStructuralFeature.Setting setting : settings) {
                                    ((InverseCrossReferencer)this.inverseCrossReferencer).addProxy(eObject, setting.getEObject());
                                }
                            }
                        }
                    }
                }
            }
        } else {
            super.selfAdapt(notification);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class InverseCrossReferencer
    extends ECrossReferenceAdapter.InverseCrossReferencer {
        private static final long serialVersionUID = 1L;

        protected InverseCrossReferencer() {
            super((ECrossReferenceAdapter)CacheAdapter.this);
        }

        private URI normalizeURI(URI uri, Resource resourceContext) {
            ResourceSet resourceSetContext;
            int index;
            int length;
            String fragment = uri.fragment();
            if (fragment != null && (length = fragment.length()) > 0 && fragment.charAt(0) != '/' && fragment.charAt(length - 1) == '?' && (index = fragment.lastIndexOf(63, length - 2)) > 0) {
                uri = uri.trimFragment().appendFragment(fragment.substring(0, index));
            }
            if (CacheAdapter.this.uriConverter != null) {
                return CacheAdapter.this.uriConverter.normalize(uri);
            }
            if (resourceContext != null && (resourceSetContext = resourceContext.getResourceSet()) != null) {
                return resourceSetContext.getURIConverter().normalize(uri);
            }
            return uri;
        }

        protected URI normalizeURI(URI uri, EObject objectContext) {
            return this.normalizeURI(uri, objectContext.eResource());
        }

        protected void addProxy(EObject proxy, EObject context) {
            if (proxy.eIsProxy()) {
                URI uri;
                List proxies;
                Resource resource;
                if (this.proxyMap == null) {
                    this.proxyMap = CacheAdapter.this.createHashMap();
                }
                if ((resource = context.eResource()) != null) {
                    CacheAdapter.this.addAdapter((Notifier)resource);
                }
                if ((proxies = (List)this.proxyMap.get(uri = this.normalizeURI(((InternalEObject)proxy).eProxyURI(), resource))) == null) {
                    proxies = new BasicEList.FastCompare();
                    this.proxyMap.put(uri, proxies);
                }
                proxies.add(proxy);
            }
        }

        protected Map<URI, List<EObject>> getProxyMap() {
            if (this.proxyMap == null) {
                Map emptyMap = Collections.emptyMap();
                return Collections.unmodifiableMap(emptyMap);
            }
            return Collections.unmodifiableMap(this.proxyMap);
        }
    }

    private static final class OverrideRegistryReader
    extends RegistryReader {
        private static final String PPID = "cache_adapter_override";
        private static final String TAG_CACHE_ADAPTER = "cacheAdapter";
        private static final String ATT_CLASS = "class";
        private CacheAdapter cacheAdapter;

        private OverrideRegistryReader() {
            super(RegistryFactory.getRegistry(), CommonPlugin.INSTANCE.getSymbolicName(), PPID);
        }

        public CacheAdapter getCacheAdapter() {
            return this.cacheAdapter;
        }

        protected boolean readElement(IConfigurationElement element, boolean add) {
            if (element.getName().equals(TAG_CACHE_ADAPTER)) {
                String className = element.getAttribute(ATT_CLASS);
                if (className == null) {
                    this.logMissingAttribute(element, ATT_CLASS);
                } else if (add) {
                    if (this.cacheAdapter != null) {
                        if (!((Object)((Object)this.cacheAdapter)).getClass().getName().equals(className)) {
                            CommonPlugin.INSTANCE.log("Ignored '" + className + "' in favour of '" + ((Object)((Object)this.cacheAdapter)).getClass().getName() + "'");
                        }
                        return false;
                    }
                    try {
                        this.cacheAdapter = (CacheAdapter)((Object)element.createExecutableExtension(ATT_CLASS));
                    }
                    catch (CoreException e) {
                        throw new WrappedException((Exception)((Object)e));
                    }
                }
                return true;
            }
            return false;
        }
    }
}

