/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.profilemigration.internal.migrators.atomic.property;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.tree.TreeNode;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.papyrus.toolsmiths.profilemigration.MigratorProfileApplication;
import org.eclipse.papyrus.toolsmiths.profilemigration.internal.data.structure.StereotypeApplicationDescriptor;
import org.eclipse.papyrus.toolsmiths.profilemigration.internal.data.structure.StereotypeApplicationRegistry;
import org.eclipse.papyrus.toolsmiths.profilemigration.internal.utils.TreeNodeUtils;
import org.eclipse.papyrus.toolsmiths.profilemigration.migrators.atomic.AbstractMigrator;
import org.eclipse.papyrus.toolsmiths.profilemigration.migrators.atomic.property.IChangeLowerMultiplicityFromPropertyMigrator;
import org.eclipse.papyrus.toolsmiths.profilemigration.ui.Activator;
import org.eclipse.papyrus.toolsmiths.profilemigration.ui.dialogs.ChangeLowerMultiplicityDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.uml2.common.util.UML2Util;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.LiteralInteger;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.UMLPackage;

public class ChangeLowerMultiplicityFromPropertyMigrator
extends AbstractMigrator
implements IChangeLowerMultiplicityFromPropertyMigrator {
    private int newValue;
    private int oldValue;
    private Property property;

    public ChangeLowerMultiplicityFromPropertyMigrator(TreeNode treeNode) {
        super(treeNode);
    }

    public static boolean isValid(TreeNode treeNode) {
        EStructuralFeature structuralFeature;
        EObject element;
        if (TreeNodeUtils.isChangeType(treeNode, MigratorProfileApplication.appliedProfile)) {
            Element oldProperty;
            EObject oldElement;
            Element property;
            EObject element2 = TreeNodeUtils.getChangedElement(treeNode);
            EStructuralFeature structuralFeature2 = TreeNodeUtils.getChangedAttribute(treeNode);
            if (element2 instanceof LiteralInteger && structuralFeature2 == UMLPackage.eINSTANCE.getLiteralInteger_Value() && (property = ((LiteralInteger)element2).getOwner()) instanceof Property && ((Property)property).getLowerValue() == element2 && (oldElement = TreeNodeUtils.getChangedOldElement(treeNode)) instanceof LiteralInteger && (oldProperty = ((LiteralInteger)oldElement).getOwner()) instanceof Property && ((Property)oldProperty).getLowerValue() == oldElement) {
                return true;
            }
        } else if (TreeNodeUtils.isAddType(treeNode, MigratorProfileApplication.appliedProfile) && (element = TreeNodeUtils.getAddedElement(treeNode)) instanceof LiteralInteger && (structuralFeature = TreeNodeUtils.getAddedStructuralFeature(treeNode)) == UMLPackage.eINSTANCE.getMultiplicityElement_LowerValue() && (!TreeNodeUtils.isAddType(treeNode.getParent(), MigratorProfileApplication.appliedProfile) || !(TreeNodeUtils.getAddedElement(treeNode.getParent()) instanceof Property))) {
            return true;
        }
        return false;
    }

    @Override
    public boolean isValid() {
        return ChangeLowerMultiplicityFromPropertyMigrator.isValid(this.treeNode);
    }

    @Override
    public void initAttributes() {
        if (this.isValid()) {
            if (TreeNodeUtils.isChangeType(this.treeNode, MigratorProfileApplication.appliedProfile)) {
                EObject element = TreeNodeUtils.getChangedElement(this.treeNode);
                this.newValue = ((LiteralInteger)element).getValue();
                this.property = (Property)((LiteralInteger)element).getOwner();
                EObject oldElement = TreeNodeUtils.getChangedOldElement(this.treeNode);
                this.oldValue = ((LiteralInteger)oldElement).getValue();
            } else if (TreeNodeUtils.isAddType(this.treeNode, MigratorProfileApplication.appliedProfile)) {
                EObject element = TreeNodeUtils.getAddedElement(this.treeNode);
                this.newValue = ((LiteralInteger)element).getValue();
                this.oldValue = 1;
                this.property = (Property)((LiteralInteger)element).getOwner();
            }
        }
    }

    @Override
    public void migrationAction() {
        List<StereotypeApplicationDescriptor> list;
        if (this.isDisplayDialogPreference() && this.newValue > this.oldValue && this.property.getOwner() instanceof Stereotype && !(list = StereotypeApplicationRegistry.getAllStereotypeApplicationDescriptors((Stereotype)this.property.getOwner())).isEmpty()) {
            HashMap mapElementToStereotype = new HashMap();
            for (StereotypeApplicationDescriptor descriptor : list) {
                Object values;
                EStructuralFeature feature;
                EObject stereotypeApplication = descriptor.getOwner().getStereotypeApplication(descriptor.getStereotype());
                if (stereotypeApplication == null || (feature = stereotypeApplication.eClass().getEStructuralFeature(UML2Util.getValidJavaIdentifier((String)this.property.getName()))) == null || !((values = stereotypeApplication.eGet(feature)) instanceof List) || ((List)values).size() >= this.newValue) continue;
                if (mapElementToStereotype.get(descriptor.getOwner()) == null) {
                    ArrayList<Stereotype> stereotypes = new ArrayList<Stereotype>();
                    stereotypes.add(descriptor.getStereotype());
                    mapElementToStereotype.put(descriptor.getOwner(), stereotypes);
                    continue;
                }
                ((List)mapElementToStereotype.get(descriptor.getOwner())).add(descriptor.getStereotype());
            }
            if (!mapElementToStereotype.isEmpty()) {
                ChangeLowerMultiplicityDialog dialog = new ChangeLowerMultiplicityDialog(Display.getDefault().getActiveShell(), this.property, this.oldValue, this.newValue, mapElementToStereotype);
                dialog.open();
            }
        }
    }

    @Override
    public int getPriority() {
        return 49;
    }

    private boolean isDisplayDialogPreference() {
        IPreferenceStore prefStore = Activator.getDefault().getPreferenceStore();
        return prefStore.getBoolean("ChangeLowerMultiplicityOfProperty");
    }

    @Override
    public int getValue() {
        return this.newValue;
    }

    @Override
    public int getOldValue() {
        return this.oldValue;
    }

    @Override
    public Property getProperty() {
        return this.property;
    }

    @Override
    public Element getChangedElement() {
        return this.getProperty();
    }

    @Override
    public Object getNewValue() {
        return this.getValue();
    }

    @Override
    public EStructuralFeature getChangedStructuralFeature() {
        return UMLPackage.eINSTANCE.getMultiplicityElement_LowerValue();
    }
}

