/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.profilemigration.ui.preferences;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.papyrus.infra.widgets.providers.CollectionContentProvider;
import org.eclipse.papyrus.toolsmiths.profilemigration.ui.Activator;
import org.eclipse.papyrus.toolsmiths.profilemigration.ui.Messages;
import org.eclipse.papyrus.toolsmiths.profilemigration.ui.preferences.ProfileMigrationPreferenceConstants;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class ProfileMigrationPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private static final int DELETE_BUTTON_ID = 1;
    private static final Image DELETE_ICON = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.papyrus.infra.widgets", (String)"icons/Delete_12x12.gif").createImage();
    private static List<String> cachedFiles = new ArrayList<String>();
    private List<BooleanFieldEditor> booleanFieldEditor = new ArrayList<BooleanFieldEditor>();
    private TreeViewer cachedFilesTreeViewer;
    private Composite mainContainer;

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
    }

    protected Control createContents(Composite parent) {
        this.mainContainer = parent;
        this.createFieldEditors();
        Group group = new Group(this.mainContainer, 2);
        group.setLayout((Layout)new GridLayout());
        group.setText(Messages.ProfileMigrationPreferencePage_FileInCached);
        this.createTreeActionButtons((Composite)group);
        this.createCachedFilesPart((Composite)group);
        this.refreshTreeviewer();
        this.initialize();
        this.checkState();
        return this.mainContainer;
    }

    protected void createFieldEditors() {
        Group group = new Group(this.mainContainer, 2);
        group.setLayout((Layout)new GridLayout());
        group.setText(Messages.ProfileMigrationPreferencePage_ShowDialogs);
        for (Map.Entry<String, String> entry : ProfileMigrationPreferenceConstants.mapPrefConstToLabel.entrySet()) {
            BooleanFieldEditor editor = new BooleanFieldEditor(entry.getKey(), entry.getValue(), (Composite)group);
            this.booleanFieldEditor.add(editor);
            this.addField((FieldEditor)editor);
            editor.setPreferenceStore(Activator.getDefault().getPreferenceStore());
        }
    }

    private void createTreeActionButtons(Composite parent) {
        Composite buttonsPanel = new Composite(parent, 0);
        buttonsPanel.setLayout((Layout)new GridLayout());
        buttonsPanel.setLayoutData((Object)new GridData(131072, 4, true, false, 1, 1));
        this.createButton(buttonsPanel, 1, DELETE_ICON, null);
    }

    private void createCachedFilesPart(Composite parent) {
        this.cachedFilesTreeViewer = new TreeViewer(parent, 2048);
        this.cachedFilesTreeViewer.setContentProvider((IContentProvider)CollectionContentProvider.instance);
        this.cachedFilesTreeViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        Tree tree = this.cachedFilesTreeViewer.getTree();
        tree.setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
    }

    protected Button createButton(Composite parent, int id, Image icon, String label) {
        ++((GridLayout)parent.getLayout()).numColumns;
        Button button = new Button(parent, 8);
        button.setFont(JFaceResources.getDialogFont());
        button.setData((Object)new Integer(id));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ProfileMigrationPreferencePage.this.buttonPressed();
            }
        });
        if (label != null) {
            button.setText(label);
        }
        if (icon != null) {
            button.setImage(icon);
        }
        this.setButtonLayoutData(button);
        return button;
    }

    protected void buttonPressed() {
        this.deleteAction();
    }

    private void deleteAction() {
        ISelection selection = this.cachedFilesTreeViewer.getSelection();
        if (selection instanceof IStructuredSelection) {
            Object selectedElement = ((IStructuredSelection)selection).getFirstElement();
            if (selectedElement instanceof String) {
                cachedFiles.remove(selectedElement);
            }
            this.refreshTreeviewer();
        }
    }

    private void refreshTreeviewer() {
        this.cachedFilesTreeViewer.getTree().setEnabled(true);
        this.cachedFilesTreeViewer.setInput(cachedFiles);
    }

    public static void addFile(String fileName) {
        cachedFiles.add(fileName);
    }

    public static List<String> getCachedFiles() {
        return cachedFiles;
    }
}

