/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.junit.utils;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.io.PrintStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.ProgressMonitorWrapper;

public class PrintingProgressMonitor
extends ProgressMonitorWrapper {
    private final PrintStream printTo;
    private boolean first;
    private Predicate<String> filter = Predicates.alwaysTrue();

    public PrintingProgressMonitor() {
        this(System.out, (IProgressMonitor)new NullProgressMonitor());
    }

    public PrintingProgressMonitor(PrintStream printTo) {
        this(printTo, (IProgressMonitor)new NullProgressMonitor());
    }

    public PrintingProgressMonitor(PrintStream printTo, IProgressMonitor monitor) {
        super(monitor);
        this.printTo = printTo;
    }

    public PrintingProgressMonitor filter(String pattern) {
        Pattern regex = Pattern.compile(pattern);
        final Matcher m = regex.matcher("");
        Predicate<String> filter = new Predicate<String>(){

            public boolean apply(String input) {
                m.reset(input);
                return !m.find();
            }
        };
        this.filter = Predicates.and((Predicate)filter, this.filter);
        return this;
    }

    private void echo(boolean dashN, String text) {
        this.echo(true, false, text);
    }

    private void echo(boolean initialNewline, boolean terminalNewline, String text) {
        if (this.filter.apply((Object)text)) {
            if (this.first) {
                this.first = false;
            } else if (initialNewline) {
                this.printTo.println();
            }
            this.printTo.print(text);
            if (terminalNewline) {
                this.printTo.println();
            }
        }
    }

    public void beginTask(String name, int totalWork) {
        this.echo(true, name);
        super.beginTask(name, totalWork);
    }

    public void setTaskName(String name) {
        this.echo(true, name);
        super.setTaskName(name);
    }

    public void subTask(String name) {
        this.echo(true, name);
        super.subTask(name);
    }

    public void worked(int work) {
        this.echo(false, false, ".");
        super.worked(work);
    }

    public void done() {
        this.echo(false, true, " Done.");
        super.done();
    }
}

