/**
 * Copyright (c) 2017 CEA LIST, ALL4TEC and others.
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   CEA LIST - initial API and implementation
 *   Mickal ADAM (ALL4TEC) mickael.adam@all4tec.net - Bug 510587: the palette must not be generated by using GMF gen
 */
package aspects.xpt.plugin;

import aspects.xpt.Common;
import aspects.xpt.editor.palette.Utils_qvto;
import com.google.common.base.Objects;
import com.google.common.collect.Iterators;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.codegen.gmfgen.AbstractToolEntry;
import org.eclipse.gmf.codegen.gmfgen.GenApplication;
import org.eclipse.gmf.codegen.gmfgen.GenCompartment;
import org.eclipse.gmf.codegen.gmfgen.GenEditorGenerator;
import org.eclipse.gmf.codegen.gmfgen.GenExternalNodeLabel;
import org.eclipse.gmf.codegen.gmfgen.GenLink;
import org.eclipse.gmf.codegen.gmfgen.GenLinkLabel;
import org.eclipse.gmf.codegen.gmfgen.GenMetricContainer;
import org.eclipse.gmf.codegen.gmfgen.GenNavigator;
import org.eclipse.gmf.codegen.gmfgen.GenPlugin;
import org.eclipse.gmf.codegen.gmfgen.GenPropertySheet;
import org.eclipse.gmf.codegen.gmfgen.ToolEntry;
import org.eclipse.gmf.codegen.gmfgen.ToolGroup;
import org.eclipse.gmf.codegen.gmfgen.ToolGroupItem;
import org.eclipse.papyrus.papyrusgmfgenextension.ExtendedGenView;
import org.eclipse.papyrus.papyrusgmfgenextension.LabelVisibilityPreference;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import xpt.editor.extensions;
import xpt.plugin.pluginUtils;

@Singleton
@SuppressWarnings("all")
public class plugin extends xpt.plugin.plugin {
  @Inject
  @Extension
  private Common _common;
  
  @Inject
  @Extension
  private pluginUtils _pluginUtils;
  
  @Inject
  @Extension
  private Utils_qvto _utils_qvto;
  
  @Inject
  private extensions xptEditorExtension;
  
  @Inject
  private xpt.diagram.preferences.extensions xptPreferencesExtension;
  
  @Inject
  private xpt.propsheet.extensions xptPropsheetExtension;
  
  @Inject
  private xpt.navigator.extensions xptNavigatorExtension;
  
  @Inject
  private xpt.application.extensions xptApplicationExtension;
  
  @Inject
  private xpt.diagram.updater.extensions xptUpdaterExtension;
  
  @Inject
  private impl.actions.extensions xptActionExtension;
  
  @Inject
  private xpt.providers.extensions xptProvidersExtension;
  
  @Override
  public CharSequence plugin(final GenPlugin it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
    _builder.newLine();
    _builder.append("<?eclipse version=\"3.0\"?>");
    _builder.newLine();
    CharSequence _xcopyright = this._common.xcopyright(it.getEditorGen());
    _builder.append(_xcopyright);
    _builder.newLineIfNotEmpty();
    _builder.append("<plugin>");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    CharSequence _extensions = this.xptEditorExtension.extensions(it.getEditorGen());
    _builder.append(_extensions, "\t\t\t\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t\t");
    CharSequence _validation = this.validation(it.getEditorGen().getDiagram());
    _builder.append(_validation, "\t\t\t\t");
    _builder.newLineIfNotEmpty();
    {
      GenMetricContainer _metrics = it.getEditorGen().getMetrics();
      boolean _notEquals = (!Objects.equal(_metrics, null));
      if (_notEquals) {
        CharSequence _metrics_1 = this.metrics(it.getEditorGen().getMetrics());
        _builder.append(_metrics_1);
      }
    }
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    CharSequence _extensions_1 = this.xptPreferencesExtension.extensions(it.getEditorGen().getDiagram());
    _builder.append(_extensions_1, "\t\t");
    _builder.newLineIfNotEmpty();
    {
      GenPropertySheet _propertySheet = it.getEditorGen().getPropertySheet();
      boolean _notEquals_1 = (!Objects.equal(_propertySheet, null));
      if (_notEquals_1) {
        CharSequence _extensions_2 = this.xptPropsheetExtension.extensions(it.getEditorGen().getPropertySheet());
        _builder.append(_extensions_2);
      }
    }
    _builder.newLineIfNotEmpty();
    CharSequence _extensions_3 = this.xptProvidersExtension.extensions(it.getEditorGen().getDiagram());
    _builder.append(_extensions_3);
    _builder.newLineIfNotEmpty();
    {
      GenNavigator _navigator = it.getEditorGen().getNavigator();
      boolean _notEquals_2 = (!Objects.equal(_navigator, null));
      if (_notEquals_2) {
        CharSequence _extensions_4 = this.xptNavigatorExtension.extensions(it.getEditorGen().getNavigator());
        _builder.append(_extensions_4);
      }
    }
    _builder.newLineIfNotEmpty();
    {
      GenApplication _application = it.getEditorGen().getApplication();
      boolean _notEquals_3 = (!Objects.equal(_application, null));
      if (_notEquals_3) {
        CharSequence _extensions_5 = this.xptApplicationExtension.extensions(it.getEditorGen().getApplication());
        _builder.append(_extensions_5);
      }
    }
    _builder.newLineIfNotEmpty();
    CharSequence _extensionsConstraintProviders = this._pluginUtils.extensionsConstraintProviders(it.getEditorGen());
    _builder.append(_extensionsConstraintProviders);
    _builder.newLineIfNotEmpty();
    CharSequence _extensions_6 = this.xptUpdaterExtension.extensions(it.getEditorGen().getDiagramUpdater());
    _builder.append(_extensions_6);
    _builder.newLineIfNotEmpty();
    CharSequence _Main = this.xptActionExtension.Main(it.getEditorGen());
    _builder.append(_Main);
    _builder.newLineIfNotEmpty();
    CharSequence _additions = this.additions(it);
    _builder.append(_additions);
    _builder.newLineIfNotEmpty();
    CharSequence _notationTypesMap = this.notationTypesMap(it.getEditorGen());
    _builder.append(_notationTypesMap);
    _builder.newLineIfNotEmpty();
    _builder.append("</plugin>");
    _builder.newLine();
    return _builder;
  }
  
  /**
   * deprecated: palette configuration are now declared through architecture model.
   */
  public CharSequence paletteConfiguration(final GenEditorGenerator it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("<extension point=\"org.eclipse.papyrus.infra.gmfdiag.common.paletteDefinition\">");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _xmlGeneratedTag = this._common.xmlGeneratedTag();
    _builder.append(_xmlGeneratedTag, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("<paletteDefinition");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("ID=\"");
    String _iD = it.getPlugin().getID();
    _builder.append(_iD, "\t\t");
    _builder.append(".paletteconfiguration\"");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("class=\"org.eclipse.papyrus.infra.gmfdiag.common.service.palette.ExtendedPluginPaletteProvider\"");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("name=\"");
    String _name = it.getPlugin().getName();
    _builder.append(_name, "\t\t");
    _builder.append(" Palette\"");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("path=\"");
    String _relativePath = this._utils_qvto.getRelativePath(it);
    _builder.append(_relativePath, "\t\t");
    _builder.append("/");
    String _modelID = it.getModelID();
    _builder.append(_modelID, "\t\t");
    _builder.append(".paletteconfiguration\"");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("provider=\"Eclipse Modeling Project\">");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("<Priority");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("name=\"Lowest\">");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("</Priority>");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("<!-- Specify diagram to which this palette tool relates -->");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("<editor");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("id=\"");
    String _iD_1 = it.getPlugin().getID();
    _builder.append(_iD_1, "\t\t\t");
    _builder.append("\">");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("</editor>");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("</paletteDefinition>");
    _builder.newLine();
    _builder.append("</extension>");
    _builder.newLine();
    return _builder;
  }
  
  @Override
  public CharSequence additions(final GenPlugin it) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }
  
  public CharSequence palettePredefinedEntries(final GenEditorGenerator it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _xmlGeneratedTag = this._common.xmlGeneratedTag();
    _builder.append(_xmlGeneratedTag);
    _builder.newLineIfNotEmpty();
    _builder.append("<extension");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("id=\"");
    String _name = it.getPlugin().getName();
    _builder.append(_name, "\t");
    _builder.append(".palettedefinition\"");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("name=\"");
    String _name_1 = it.getPlugin().getName();
    _builder.append(_name_1, "\t");
    _builder.append(" Predefined Entries\"");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("point=\"org.eclipse.gmf.runtime.diagram.ui.paletteProviders\"> ");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _xmlGeneratedTag_1 = this._common.xmlGeneratedTag();
    _builder.append(_xmlGeneratedTag_1, "\t");
    _builder.append("\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("<paletteProvider class=\"org.eclipse.gmf.runtime.diagram.ui.providers.DefaultPaletteProvider\">");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("<Priority name=\"Lowest\"/>");
    _builder.newLine();
    _builder.append("\t\t   \t\t");
    _builder.append("<contribution");
    _builder.newLine();
    _builder.append("\t\t   \t\t    \t");
    _builder.append("factoryClass=\"");
    String _packageName = it.getDiagram().getPalette().getPackageName();
    _builder.append(_packageName, "\t\t   \t\t    \t");
    _builder.append(".");
    String _factoryClassName = it.getDiagram().getPalette().getFactoryClassName();
    _builder.append(_factoryClassName, "\t\t   \t\t    \t");
    _builder.append("\">");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t   \t\t");
    _builder.append("<predefinedEntry id=\"standardGroup/noteStack/noteTool\" remove=\"true\"/> ");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("<predefinedEntry id=\"standardGroup/noteStack/textTool\" remove=\"true\"/> ");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("<predefinedEntry id=\"standardGroup/noteStack/noteattachmentTool\" remove=\"true\"/>");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.newLine();
    {
      Iterable<AbstractToolEntry> _collectTools = this._utils_qvto.collectTools(it.getDiagram().getPalette());
      for(final AbstractToolEntry tool : _collectTools) {
        _builder.append("\t\t");
        CharSequence _predefinedEntryDefinition = this.predefinedEntryDefinition(tool);
        _builder.append(_predefinedEntryDefinition, "\t\t");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("\t\t");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("</contribution>");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("</paletteProvider>\t");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.newLine();
    _builder.append("</extension>");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence paletteEntries(final GenEditorGenerator it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _xmlGeneratedTag = this._common.xmlGeneratedTag();
    _builder.append(_xmlGeneratedTag);
    _builder.newLineIfNotEmpty();
    _builder.append("<extension");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("id=\"");
    String _name = it.getPlugin().getName();
    _builder.append(_name, "\t");
    _builder.append(".standard\"");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("name=\"");
    String _name_1 = it.getPlugin().getName();
    _builder.append(_name_1, "\t");
    _builder.append(" Standard Palette\"");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("point=\"org.eclipse.gmf.runtime.diagram.ui.paletteProviders\"> ");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _xmlGeneratedTag_1 = this._common.xmlGeneratedTag();
    _builder.append(_xmlGeneratedTag_1, "\t");
    _builder.append("\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("<paletteProvider class=\"org.eclipse.gmf.runtime.diagram.ui.providers.DefaultPaletteProvider\">");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("<Priority name=\"Low\"/>");
    _builder.newLine();
    _builder.append("\t\t   \t\t");
    _builder.append("<contribution");
    _builder.newLine();
    _builder.append("\t\t   \t\t    \t");
    _builder.append("factoryClass=\"");
    String _packageName = it.getDiagram().getPalette().getPackageName();
    _builder.append(_packageName, "\t\t   \t\t    \t");
    _builder.append(".");
    String _factoryClassName = it.getDiagram().getPalette().getFactoryClassName();
    _builder.append(_factoryClassName, "\t\t   \t\t    \t");
    _builder.append("\">");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t   \t\t");
    _builder.append("<predefinedEntry id=\"standardGroup/noteStack/noteTool\" remove=\"true\"/> ");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("<predefinedEntry id=\"standardGroup/noteStack/textTool\" remove=\"true\"/> ");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("<predefinedEntry id=\"standardGroup/noteStack/noteattachmentTool\" remove=\"true\"/>");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.newLine();
    {
      EList<ToolGroup> _groups = it.getDiagram().getPalette().getGroups();
      for(final ToolGroup tool : _groups) {
        _builder.append("\t\t");
        CharSequence _groupUsage = this.groupUsage(tool);
        _builder.append(_groupUsage, "\t\t");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("\t\t");
    _builder.append("</contribution>");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("<editor id=\"");
    String _iD = it.getPlugin().getID();
    _builder.append(_iD, "\t\t");
    _builder.append("\"/>");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("</paletteProvider>\t");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.newLine();
    _builder.append("</extension>");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence groupUsage(final ToolGroup it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("<entry");
    _builder.newLine();
    _builder.append("      ");
    _builder.append("description=\"");
    String _description = it.getDescription();
    _builder.append(_description, "      ");
    _builder.append("\"");
    _builder.newLineIfNotEmpty();
    _builder.append("      ");
    _builder.append("id=");
    {
      boolean _isQuoted = this._utils_qvto.isQuoted(it.getId(), "\"");
      if (_isQuoted) {
        String _id = it.getId();
        _builder.append(_id, "      ");
      } else {
        _builder.append("\"");
        String _id_1 = it.getId();
        _builder.append(_id_1, "      ");
        _builder.append("\"");
      }
    }
    _builder.newLineIfNotEmpty();
    _builder.append("      ");
    _builder.append("kind=\"");
    {
      if ((it.isStack() && it.isToolsOnly())) {
        _builder.append("stack");
      } else {
        _builder.append("drawer");
      }
    }
    _builder.append("\"");
    _builder.newLineIfNotEmpty();
    _builder.append("      ");
    _builder.append("label=\"");
    String _title = it.getTitle();
    _builder.append(_title, "      ");
    _builder.append("\"");
    _builder.newLineIfNotEmpty();
    _builder.append("      ");
    _builder.append("large_icon=\"");
    String _largeIconPath = it.getLargeIconPath();
    _builder.append(_largeIconPath, "      ");
    _builder.append("\"");
    _builder.newLineIfNotEmpty();
    _builder.append("      ");
    _builder.append("path=\"");
    String _path = this.getPath(it);
    _builder.append(_path, "      ");
    _builder.append("\"");
    _builder.newLineIfNotEmpty();
    _builder.append("      ");
    _builder.append("small_icon=\"");
    String _smallIconPath = it.getSmallIconPath();
    _builder.append(_smallIconPath, "      ");
    _builder.append("\">");
    _builder.newLineIfNotEmpty();
    _builder.append("   ");
    _builder.append("<expand");
    _builder.newLine();
    _builder.append("         ");
    _builder.append("force=\"true\">");
    _builder.newLine();
    _builder.append("   ");
    _builder.append("</expand>");
    _builder.newLine();
    _builder.append("</entry>");
    _builder.newLine();
    {
      final Function1<ToolGroupItem, Boolean> _function = new Function1<ToolGroupItem, Boolean>() {
        @Override
        public Boolean apply(final ToolGroupItem e) {
          return Boolean.valueOf((e instanceof ToolEntry));
        }
      };
      Iterable<ToolGroupItem> _filter = IterableExtensions.<ToolGroupItem>filter(it.getEntries(), _function);
      for(final ToolGroupItem entry : _filter) {
        CharSequence _olUsage = this.toolUsage(entry, it);
        _builder.append(_olUsage);
        _builder.newLineIfNotEmpty();
      }
    }
    {
      final Function1<ToolGroupItem, Boolean> _function_1 = new Function1<ToolGroupItem, Boolean>() {
        @Override
        public Boolean apply(final ToolGroupItem e) {
          return Boolean.valueOf((e instanceof ToolGroup));
        }
      };
      Iterable<ToolGroupItem> _filter_1 = IterableExtensions.<ToolGroupItem>filter(it.getEntries(), _function_1);
      for(final ToolGroupItem entry_1 : _filter_1) {
        CharSequence _olUsage_1 = this.toolUsage(entry_1, it);
        _builder.append(_olUsage_1);
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }
  
  private String getPath(final ToolEntry it) {
    return this.buildPath(it.eContainer());
  }
  
  private String getPath(final ToolGroup it) {
    return this.buildPath(it.eContainer());
  }
  
  private String buildPath(final EObject it) {
    StringBuilder path = new StringBuilder();
    EObject container = it;
    while ((container instanceof ToolGroup)) {
      {
        path.insert(0, this._utils_qvto.getToolPath(((ToolGroup) container).getId()));
        container = ((ToolGroup)container).eContainer();
      }
    }
    String _xifexpression = null;
    int _length = path.length();
    boolean _notEquals = (_length != 0);
    if (_notEquals) {
      _xifexpression = path.toString();
    } else {
      _xifexpression = "/";
    }
    return _xifexpression;
  }
  
  protected CharSequence _toolUsage(final ToolEntry it, final ToolGroup group) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("<predefinedEntry");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("id=");
    {
      boolean _isQuoted = this._utils_qvto.isQuoted(it.getId(), "\"");
      if (_isQuoted) {
        String _id = it.getId();
        _builder.append(_id, "        ");
      } else {
        _builder.append("\"");
        String _id_1 = it.getId();
        _builder.append(_id_1, "        ");
        _builder.append("\"");
      }
    }
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("path=\"");
    String _path = this.getPath(it);
    _builder.append(_path, "\t\t");
    _builder.append("\">");
    _builder.newLineIfNotEmpty();
    _builder.append("  ");
    _builder.append("</predefinedEntry>");
    _builder.newLine();
    return _builder;
  }
  
  protected CharSequence _toolUsage(final ToolGroup it, final ToolGroup group) {
    StringConcatenation _builder = new StringConcatenation();
    Object _groupUsage = this.groupUsage(it);
    _builder.append(_groupUsage);
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  public CharSequence predefinedEntryDefinition(final AbstractToolEntry it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("<entry");
    _builder.newLine();
    _builder.append("      ");
    _builder.append("defineOnly=\"true\"");
    _builder.newLine();
    _builder.append("      ");
    _builder.append("description=\"");
    String _description = it.getDescription();
    _builder.append(_description, "      ");
    _builder.append("\"");
    _builder.newLineIfNotEmpty();
    _builder.append("      ");
    _builder.append("id=");
    {
      boolean _isQuoted = this._utils_qvto.isQuoted(it.getId(), "\"");
      if (_isQuoted) {
        String _id = it.getId();
        _builder.append(_id, "      ");
      } else {
        _builder.append("\"");
        String _id_1 = it.getId();
        _builder.append(_id_1, "      ");
        _builder.append("\"");
      }
    }
    _builder.newLineIfNotEmpty();
    _builder.append("      ");
    _builder.append("kind=\"tool\"");
    _builder.newLine();
    _builder.append("      ");
    _builder.append("label=\"");
    String _title = it.getTitle();
    _builder.append(_title, "      ");
    _builder.append("\"");
    _builder.newLineIfNotEmpty();
    _builder.append("      ");
    _builder.append("large_icon=\"");
    String _largeIconPath = it.getLargeIconPath();
    _builder.append(_largeIconPath, "      ");
    _builder.append("\"");
    _builder.newLineIfNotEmpty();
    _builder.append("      ");
    _builder.append("path=\"\"");
    _builder.newLine();
    _builder.append("      ");
    _builder.append("small_icon=\"");
    String _smallIconPath = it.getSmallIconPath();
    _builder.append(_smallIconPath, "      ");
    _builder.append("\">");
    _builder.newLineIfNotEmpty();
    _builder.append("</entry>");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence notationTypesMap(final GenEditorGenerator it) {
    StringConcatenation _builder = new StringConcatenation();
    String _tripleSpace = this._common.tripleSpace(0);
    _builder.append(_tripleSpace);
    _builder.append("<extension point=\"org.eclipse.papyrus.infra.gmfdiag.common.notationTypesMapping\"> ");
    _builder.newLineIfNotEmpty();
    String _tripleSpace_1 = this._common.tripleSpace(1);
    _builder.append(_tripleSpace_1);
    CharSequence _xmlGeneratedTag = this._common.xmlGeneratedTag();
    _builder.append(_xmlGeneratedTag);
    _builder.newLineIfNotEmpty();
    String _tripleSpace_2 = this._common.tripleSpace(1);
    _builder.append(_tripleSpace_2);
    _builder.append("<diagramMappings diagramID=\"");
    String _modelID = it.getModelID();
    _builder.append(_modelID);
    _builder.append("\">");
    _builder.newLineIfNotEmpty();
    String _tripleSpace_3 = this._common.tripleSpace(1);
    _builder.append(_tripleSpace_3);
    _builder.append("\t<mapping type=\"");
    String _modelID_1 = it.getModelID();
    _builder.append(_modelID_1);
    _builder.append("\" humanReadableType=\"");
    String _replaceAll = it.getModelID().replaceAll("Papyrus|UML|Diagram", "");
    _builder.append(_replaceAll);
    _builder.append("Diagram\"/>");
    _builder.newLineIfNotEmpty();
    {
      EList<GenCompartment> _compartments = it.getDiagram().getCompartments();
      for(final GenCompartment compartment : _compartments) {
        _builder.append("\t\t\t");
        CharSequence _compartmentToTypeMap = this.compartmentToTypeMap(compartment);
        _builder.append(_compartmentToTypeMap, "\t\t\t");
        _builder.newLineIfNotEmpty();
      }
    }
    {
      EList<GenLink> _links = it.getDiagram().getLinks();
      for(final GenLink link : _links) {
        _builder.append("\t\t\t");
        CharSequence _linksToTypeMap = this.linksToTypeMap(link);
        _builder.append(_linksToTypeMap, "\t\t\t");
        _builder.newLineIfNotEmpty();
      }
    }
    {
      Iterable<GenExternalNodeLabel> _iterable = IteratorExtensions.<GenExternalNodeLabel>toIterable(Iterators.<GenExternalNodeLabel>filter(it.getDiagram().eResource().getAllContents(), GenExternalNodeLabel.class));
      for(final GenExternalNodeLabel externalLabel : _iterable) {
        _builder.append("\t\t\t");
        CharSequence _floatingLabelToTypeMap = this.floatingLabelToTypeMap(externalLabel);
        _builder.append(_floatingLabelToTypeMap, "\t\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t");
        CharSequence _externalNodeLabelToTypeMap = this.externalNodeLabelToTypeMap(externalLabel);
        _builder.append(_externalNodeLabelToTypeMap, "\t\t\t");
        _builder.newLineIfNotEmpty();
      }
    }
    String _tripleSpace_4 = this._common.tripleSpace(1);
    _builder.append(_tripleSpace_4);
    _builder.append("</diagramMappings>");
    _builder.newLineIfNotEmpty();
    String _tripleSpace_5 = this._common.tripleSpace(0);
    _builder.append(_tripleSpace_5);
    _builder.append("</extension>");
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  public CharSequence compartmentToTypeMap(final GenCompartment it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("<mapping");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("humanReadableType=\"");
    String _replaceAll = it.getTitle().replaceAll("Compartment", "");
    _builder.append(_replaceAll, "\t");
    _builder.append("\"");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("type=\"");
    String _stringVisualID = this._common.stringVisualID(it);
    _builder.append(_stringVisualID, "\t");
    _builder.append("\">");
    _builder.newLineIfNotEmpty();
    _builder.append("</mapping>");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence linksToTypeMap(final GenLink it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      EList<GenLinkLabel> _labels = it.getLabels();
      for(final GenLinkLabel label : _labels) {
        CharSequence _linkLabelToTypeMap = this.linkLabelToTypeMap(label);
        _builder.append(_linkLabelToTypeMap);
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }
  
  public CharSequence linkLabelToTypeMap(final GenLinkLabel it) {
    StringConcatenation _builder = new StringConcatenation();
    final Function1<LabelVisibilityPreference, Boolean> _function = new Function1<LabelVisibilityPreference, Boolean>() {
      @Override
      public Boolean apply(final LabelVisibilityPreference v) {
        return Boolean.valueOf((((!Objects.equal(v.getLinkLabels(), null)) && v.getLinkLabels().contains(it)) && (!Objects.equal(v.getRole(), null))));
      }
    };
    CharSequence _LabelVisibilityPreferenceToTypeMap = this.LabelVisibilityPreferenceToTypeMap(IteratorExtensions.<LabelVisibilityPreference>filter(Iterators.<LabelVisibilityPreference>filter(it.eResource().getAllContents(), LabelVisibilityPreference.class), _function), this._common.stringVisualID(it));
    _builder.append(_LabelVisibilityPreferenceToTypeMap);
    _builder.append("\t");
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  public CharSequence externalNodeLabelToTypeMap(final GenExternalNodeLabel it) {
    StringConcatenation _builder = new StringConcatenation();
    final Function1<LabelVisibilityPreference, Boolean> _function = new Function1<LabelVisibilityPreference, Boolean>() {
      @Override
      public Boolean apply(final LabelVisibilityPreference v) {
        return Boolean.valueOf((((!Objects.equal(v.getExternalNodeLabels(), null)) && v.getExternalNodeLabels().contains(it)) && (!Objects.equal(v.getRole(), null))));
      }
    };
    CharSequence _LabelVisibilityPreferenceToTypeMap = this.LabelVisibilityPreferenceToTypeMap(IteratorExtensions.<LabelVisibilityPreference>filter(Iterators.<LabelVisibilityPreference>filter(it.eResource().getAllContents(), LabelVisibilityPreference.class), _function), this._common.stringVisualID(it));
    _builder.append(_LabelVisibilityPreferenceToTypeMap);
    _builder.append("\t");
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  public CharSequence LabelVisibilityPreferenceToTypeMap(final Iterator<LabelVisibilityPreference> it, final String visualID) {
    StringConcatenation _builder = new StringConcatenation();
    List<LabelVisibilityPreference> links = IteratorExtensions.<LabelVisibilityPreference>toList(it);
    _builder.newLineIfNotEmpty();
    {
      int _size = links.size();
      boolean _notEquals = (_size != 0);
      if (_notEquals) {
        _builder.append("<mapping");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("humanReadableType=\"");
        String _role = links.get(0).getRole();
        _builder.append(_role, "\t");
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("type=\"");
        _builder.append(visualID, "\t");
        _builder.append("\">");
        _builder.newLineIfNotEmpty();
        _builder.append("</mapping>");
        _builder.newLine();
      }
    }
    return _builder;
  }
  
  public CharSequence floatingLabelToTypeMap(final GenExternalNodeLabel it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      final Function1<ExtendedGenView, Boolean> _function = new Function1<ExtendedGenView, Boolean>() {
        @Override
        public Boolean apply(final ExtendedGenView v) {
          return Boolean.valueOf((v.getGenView().contains(it) && (!Objects.equal(v.getSuperOwnedEditPart(), null))));
        }
      };
      int _size = IteratorExtensions.size(IteratorExtensions.<ExtendedGenView>filter(Iterators.<ExtendedGenView>filter(it.eResource().getAllContents(), ExtendedGenView.class), _function));
      boolean _notEquals = (_size != 0);
      if (_notEquals) {
        {
          final Function1<ExtendedGenView, Boolean> _function_1 = new Function1<ExtendedGenView, Boolean>() {
            @Override
            public Boolean apply(final ExtendedGenView v) {
              return Boolean.valueOf((v.getGenView().contains(it) && (!Objects.equal(v.getSuperOwnedEditPart(), null))));
            }
          };
          Iterable<ExtendedGenView> _iterable = IteratorExtensions.<ExtendedGenView>toIterable(IteratorExtensions.<ExtendedGenView>filter(Iterators.<ExtendedGenView>filter(it.eResource().getAllContents(), ExtendedGenView.class), _function_1));
          for(final ExtendedGenView extendedObject : _iterable) {
            {
              boolean _equals = "FloatingLabelEditPart".equals(extendedObject.getName());
              if (_equals) {
                _builder.append("<mapping");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("humanReadableType=\"Floating Label\"");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("type=\"");
                String _stringVisualID = this._common.stringVisualID(it);
                _builder.append(_stringVisualID, "\t");
                _builder.append("\">");
                _builder.newLineIfNotEmpty();
                _builder.append("</mapping>");
                _builder.newLine();
              }
            }
          }
        }
      }
    }
    return _builder;
  }
  
  public CharSequence toolUsage(final EObject it, final ToolGroup group) {
    if (it instanceof ToolEntry) {
      return _toolUsage((ToolEntry)it, group);
    } else if (it instanceof ToolGroup) {
      return _toolUsage((ToolGroup)it, group);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it, group).toString());
    }
  }
}
