/**
 * Copyright (c) 2006, 2017 Borland Software Corporation and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *    Artem Tikhomirov (Borland) - initial API and implementation
 *    Michael Golubev (Montages) - #386838 - migrate to Xtend2
 *    Mickal ADAM (ALL4TEC) - mickael.adam@all4tec.net - Bug 510587
 */
package aspects.xpt.editor.palette;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Singleton;
import java.util.HashMap;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.URIHandlerImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLHelperImpl;
import org.eclipse.gmf.codegen.gmfgen.AbstractToolEntry;
import org.eclipse.gmf.codegen.gmfgen.Palette;
import org.eclipse.gmf.codegen.gmfgen.ToolEntry;
import org.eclipse.gmf.codegen.gmfgen.ToolGroup;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.papyrus.infra.types.ElementTypeConfiguration;
import org.eclipse.papyrus.infra.types.ExternallyRegisteredType;
import org.eclipse.papyrus.infra.types.MetamodelTypeConfiguration;
import org.eclipse.papyrus.infra.types.SpecializationTypeConfiguration;
import org.eclipse.papyrus.infra.types.core.IConfiguredHintedElementType;
import org.eclipse.papyrus.infra.types.core.registries.ElementTypeSetConfigurationRegistry;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@Singleton
@SuppressWarnings("all")
public class Utils_qvto extends xpt.editor.palette.Utils_qvto {
  /**
   * collect all tools availables and valid to generate the palette. A tool is not valid when it does not create either a link or a node
   */
  @Override
  public Iterable<AbstractToolEntry> collectTools(final Palette palette) {
    final Function1<ToolGroup, Iterable<AbstractToolEntry>> _function = new Function1<ToolGroup, Iterable<AbstractToolEntry>>() {
      @Override
      public Iterable<AbstractToolEntry> apply(final ToolGroup g) {
        return Iterables.<AbstractToolEntry>filter(g.getEntries(), AbstractToolEntry.class);
      }
    };
    final Function1<AbstractToolEntry, Boolean> _function_1 = new Function1<AbstractToolEntry, Boolean>() {
      @Override
      public Boolean apply(final AbstractToolEntry tool) {
        return Boolean.valueOf(Utils_qvto.this.isValidTool(tool));
      }
    };
    return IterableExtensions.<AbstractToolEntry>filter(Iterables.<AbstractToolEntry>concat(IterableExtensions.<ToolGroup, Iterable<AbstractToolEntry>>map(this.collectGroups(palette), _function)), _function_1);
  }
  
  public boolean isValidTool(final AbstractToolEntry entry) {
    if ((entry instanceof ToolEntry)) {
      if (((!Objects.equal(null, ((ToolEntry)entry).getQualifiedToolName())) && (!((ToolEntry)entry).getQualifiedToolName().isEmpty()))) {
        return true;
      }
      final int links = ((ToolEntry) entry).getGenLinks().size();
      final int nodes = ((ToolEntry) entry).getGenNodes().size();
      return ((nodes + links) != 0);
    } else {
      return true;
    }
  }
  
  public String getToolPath(final String it) {
    String result = null;
    boolean _isQuoted = this.isQuoted(it, "\"");
    if (_isQuoted) {
      int _length = it.length();
      int _minus = (_length - 1);
      result = it.substring(1, _minus);
    } else {
      result = it;
    }
    return ("/" + result);
  }
  
  public boolean isQuoted(final String source, final String quoteStr) {
    boolean _equals = Objects.equal(quoteStr, null);
    if (_equals) {
      return false;
    }
    return (((source.length() >= (quoteStr.length() * 2)) && source.startsWith(quoteStr)) && source.endsWith(quoteStr));
  }
  
  public String getConstantIDName(final String it) {
    boolean _isQuoted = this.isQuoted(it, "\"");
    if (_isQuoted) {
      int _length = it.length();
      int _minus = (_length - 1);
      return this.getUpperAndUnderscoreString(it.substring(1, _minus));
    } else {
      return this.getUpperAndUnderscoreString(it);
    }
  }
  
  public String getUpperAndUnderscoreString(final String value) {
    return value.toUpperCase().replace(".", "_");
  }
  
  /**
   * The plateform protocol prefix.
   */
  private static String PLUGIN_PROTOCOL = "platform:/plugin/";
  
  /**
   * Retrieve the bundle id of a platform/plug-in path.
   * 
   * @param initialValue
   * 				The initial value from which the bundle has to be retrieved
   * @param defaultValue
   * 				The default bundle id value if bundle id not found
   * @return the bundle id
   */
  public String retrieveBundleId(final String initialValue, final String defaultValue) {
    String result = null;
    boolean _startsWith = initialValue.startsWith(Utils_qvto.PLUGIN_PROTOCOL);
    if (_startsWith) {
      String tmp = initialValue.substring(Utils_qvto.PLUGIN_PROTOCOL.length());
      int bundleIdEndIndex = tmp.indexOf("/");
      result = tmp.substring(0, bundleIdEndIndex);
    } else {
      result = defaultValue;
    }
    return result;
  }
  
  /**
   * Retrieve the local path of a platform/plug-in path.
   * 
   * @param initialValue
   *            the initial value from which the local path has to be retrieved
   * @return the local path
   */
  public String retrieveLocalPath(final String initialValue) {
    String result = "";
    boolean _startsWith = initialValue.startsWith(Utils_qvto.PLUGIN_PROTOCOL);
    if (_startsWith) {
      String tmp = initialValue.substring(Utils_qvto.PLUGIN_PROTOCOL.length());
      int bundleIdEndIndex = tmp.indexOf("/");
      result = tmp.substring(bundleIdEndIndex);
    } else {
      result = initialValue;
    }
    return result;
  }
  
  /**
   * @return The relative path of the model's resource
   * 
   * @param it
   *            the EObject to get the relative path
   */
  public String getRelativePath(final EObject it) {
    String path = null;
    URI resourceURI = it.eResource().getURI();
    boolean _isPlatformResource = resourceURI.isPlatformResource();
    if (_isPlatformResource) {
      String platformString = resourceURI.toPlatformString(true);
      IPath workspacePath = new Path(platformString);
      workspacePath = workspacePath.removeFirstSegments(1);
      workspacePath = workspacePath.removeLastSegments(1);
      path = workspacePath.toString();
    } else {
      path = "model";
    }
    return path;
  }
  
  /**
   * Get the href string for the elementTypeConfiguration model of the unique identifier.
   */
  public String getElementTypeConfHRef(final String uniqueIdentifier, final XMLResource resource) {
    ElementTypeSetConfigurationRegistry.getInstance().getClass();
    String href = null;
    final IElementType type = ElementTypeRegistry.getInstance().getType(uniqueIdentifier);
    if ((type instanceof IConfiguredHintedElementType)) {
      final XMLHelperImpl xmlHelper = new XMLHelperImpl(resource);
      final HashMap<Object, Object> options = new HashMap<Object, Object>();
      URIHandlerImpl.PlatformSchemeAware _platformSchemeAware = new URIHandlerImpl.PlatformSchemeAware();
      options.put(XMLResource.OPTION_URI_HANDLER, _platformSchemeAware);
      xmlHelper.setOptions(options);
      ElementTypeConfiguration _configuration = ((IConfiguredHintedElementType)type).getConfiguration();
      href = xmlHelper.getHREF(((EObject) _configuration));
    }
    return href;
  }
  
  /**
   * Get the href string for the elementTypeConfiguration model of the unique identifier.
   */
  public String getConfigurationXsiType(final String uniqueIdentifier, final XMLResource resource) {
    String type = null;
    final IElementType eltype = ElementTypeRegistry.getInstance().getType(uniqueIdentifier);
    if ((eltype instanceof IConfiguredHintedElementType)) {
      ElementTypeConfiguration configuration = ((IConfiguredHintedElementType)eltype).getConfiguration();
      if ((configuration instanceof SpecializationTypeConfiguration)) {
        type = "elementtypesconfigurations:SpecializationTypeConfiguration";
      } else {
        if ((configuration instanceof MetamodelTypeConfiguration)) {
          type = "elementtypesconfigurations:MetamodelTypeConfiguration";
        } else {
          if ((configuration instanceof ExternallyRegisteredType)) {
            type = "elementtypesconfigurations:ExternallyRegisteredType";
          }
        }
      }
    }
    return type;
  }
}
