package aspects.xpt.editor;

import aspects.xpt.Common;
import aspects.xpt.editor.VisualIDRegistry;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.gmf.codegen.gmfgen.GenContainerBase;
import org.eclipse.gmf.codegen.gmfgen.GenDiagram;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;

@Singleton
@SuppressWarnings("all")
public class DiagramContentInitializer extends xpt.editor.DiagramContentInitializer {
  @Inject
  @Extension
  private Common _common;
  
  @Inject
  private VisualIDRegistry xptVisualIDRegistry;
  
  @Override
  public CharSequence getCompartment(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("private org.eclipse.gmf.runtime.notation.Node getCompartment(org.eclipse.gmf.runtime.notation.View node, String visualID) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("String type = ");
    CharSequence _typeMethodCall = this.xptVisualIDRegistry.typeMethodCall(it, "visualID");
    _builder.append(_typeMethodCall, "\t");
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("for (java.util.Iterator it = node.getChildren().iterator(); it.hasNext();) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("org.eclipse.gmf.runtime.notation.View nextView = (org.eclipse.gmf.runtime.notation.View) it.next();");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("if (nextView instanceof org.eclipse.gmf.runtime.notation.Node && type.equals(nextView.getType())) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("return (org.eclipse.gmf.runtime.notation.Node) nextView;");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return null;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  @Override
  public CharSequence createChildrenMethodName(final GenContainerBase it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("create");
    String _stringUniqueIdentifier = this._common.stringUniqueIdentifier(it);
    _builder.append(_stringUniqueIdentifier);
    _builder.append("_Children");
    return _builder;
  }
}
