/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.referencialgrilling;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.FileModificationValidator;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.CommandUtilities;
import org.eclipse.gmf.runtime.diagram.ui.commands.CreateOrSelectElementCommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateUnspecifiedTypeRequest;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.papyrus.infra.gmfdiag.common.editpolicies.DefaultCreationEditPolicy;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.CombinedFragmentEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.util.SequenceUtil;
import org.eclipse.swt.widgets.Display;

public class CustomInteractionOperandCreationEditPolicy
extends DefaultCreationEditPolicy {
    public Command getCommand(Request request) {
        if (this.understandsRequest(request) && request instanceof CreateUnspecifiedTypeRequest) {
            return this.getUnspecifiedTypeCreateCommand((CreateUnspecifiedTypeRequest)request);
        }
        return super.getCommand(request);
    }

    private Command getUnspecifiedTypeCreateCommand(final CreateUnspecifiedTypeRequest request) {
        final HashMap<IElementType, Command> createCmds = new HashMap<IElementType, Command>();
        ArrayList<IElementType> validTypes = new ArrayList<IElementType>();
        for (IElementType elementType : request.getElementTypes()) {
            Command individualCmd;
            CombinedFragmentEditPart target;
            CreateRequest createRequest = request.getRequestForType(elementType);
            if (createRequest == null || (target = SequenceUtil.getParentCombinedFragmentPart(this.getHost().getTargetEditPart((Request)createRequest))) == null || (individualCmd = target.getCommand((Request)createRequest)) == null || !individualCmd.canExecute()) continue;
            createCmds.put(elementType, individualCmd);
            validTypes.add(elementType);
        }
        if (createCmds.isEmpty()) {
            return null;
        }
        if (createCmds.size() == 1) {
            return (Command)createCmds.values().toArray()[0];
        }
        CreateOrSelectElementCommand selectAndCreateViewCmd = new CreateOrSelectElementCommand(DiagramUIMessages.CreateCommand_Label, Display.getCurrent().getActiveShell(), validTypes){
            private Command _createCmd;

            protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
                CommandResult cmdResult = super.doExecuteWithResult(progressMonitor, info);
                if (!cmdResult.getStatus().isOK()) {
                    return cmdResult;
                }
                IElementType type = (IElementType)cmdResult.getReturnValue();
                this._createCmd = (Command)createCmds.get(type);
                Assert.isTrue((this._createCmd != null && this._createCmd.canExecute() ? 1 : 0) != 0);
                IStatus status = this.validateAffectedFiles(this._createCmd);
                if (!status.isOK()) {
                    return new CommandResult(status);
                }
                this._createCmd.execute();
                CreateRequest createRequest = request.getRequestForType(type);
                Collection newObject = (Collection)createRequest.getNewObject();
                request.setNewObject(newObject);
                return CommandResult.newOKCommandResult((Object)newObject);
            }

            protected CommandResult doUndoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
                if (this._createCmd != null && this._createCmd.canUndo()) {
                    IStatus status = this.validateAffectedFiles(this._createCmd);
                    if (!status.isOK()) {
                        return new CommandResult(status);
                    }
                    this._createCmd.undo();
                }
                return super.doUndoWithResult(progressMonitor, info);
            }

            protected CommandResult doRedoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
                if (this._createCmd != null && CommandUtilities.canRedo((Command)this._createCmd)) {
                    IStatus status = this.validateAffectedFiles(this._createCmd);
                    if (!status.isOK()) {
                        return new CommandResult(status);
                    }
                    this._createCmd.redo();
                }
                return super.doRedoWithResult(progressMonitor, info);
            }

            private IStatus validateAffectedFiles(Command command) {
                Collection affectedFiles = CommandUtilities.getAffectedFiles((Command)command);
                int fileCount = affectedFiles.size();
                if (fileCount > 0) {
                    return FileModificationValidator.approveFileModification((IFile[])affectedFiles.toArray(new IFile[fileCount]));
                }
                return Status.OK_STATUS;
            }
        };
        return new ICommandProxy((ICommand)selectAndCreateViewCmd);
    }
}

