/*****************************************************************************
 * Copyright (c) 2011 CEA LIST.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *  CEA LIST - Initial API and implementation
 *****************************************************************************/
package org.eclipse.papyrus.infra.properties.ui.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.papyrus.infra.properties.environment.CompositeWidgetType;
import org.eclipse.papyrus.infra.properties.ui.CompositeWidget;
import org.eclipse.papyrus.infra.properties.ui.Layout;
import org.eclipse.papyrus.infra.properties.ui.UiPackage;
import org.eclipse.papyrus.infra.properties.ui.Widget;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Composite Widget</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 * <li>{@link org.eclipse.papyrus.infra.properties.ui.impl.CompositeWidgetImpl#getLayout <em>Layout</em>}</li>
 * <li>{@link org.eclipse.papyrus.infra.properties.ui.impl.CompositeWidgetImpl#getWidgets <em>Widgets</em>}</li>
 * <li>{@link org.eclipse.papyrus.infra.properties.ui.impl.CompositeWidgetImpl#getWidgetType <em>Widget Type</em>}</li>
 * </ul>
 *
 * @generated
 */
public class CompositeWidgetImpl extends WidgetImpl implements CompositeWidget {
	/**
	 * The cached value of the '{@link #getLayout() <em>Layout</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @see #getLayout()
	 * @generated
	 * @ordered
	 */
	protected Layout layout;

	/**
	 * The cached value of the '{@link #getWidgets() <em>Widgets</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @see #getWidgets()
	 * @generated
	 * @ordered
	 */
	protected EList<Widget> widgets;

	/**
	 * The cached value of the '{@link #getWidgetType() <em>Widget Type</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @see #getWidgetType()
	 * @generated
	 * @ordered
	 */
	protected CompositeWidgetType widgetType;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	protected CompositeWidgetImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return UiPackage.Literals.COMPOSITE_WIDGET;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public Layout getLayout() {
		return layout;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	public NotificationChain basicSetLayout(Layout newLayout, NotificationChain msgs) {
		Layout oldLayout = layout;
		layout = newLayout;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, UiPackage.COMPOSITE_WIDGET__LAYOUT, oldLayout, newLayout);
			if (msgs == null) {
				msgs = notification;
			} else {
				msgs.add(notification);
			}
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public void setLayout(Layout newLayout) {
		if (newLayout != layout) {
			NotificationChain msgs = null;
			if (layout != null) {
				msgs = ((InternalEObject) layout).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - UiPackage.COMPOSITE_WIDGET__LAYOUT, null, msgs);
			}
			if (newLayout != null) {
				msgs = ((InternalEObject) newLayout).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - UiPackage.COMPOSITE_WIDGET__LAYOUT, null, msgs);
			}
			msgs = basicSetLayout(newLayout, msgs);
			if (msgs != null) {
				msgs.dispatch();
			}
		} else if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.SET, UiPackage.COMPOSITE_WIDGET__LAYOUT, newLayout, newLayout));
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public EList<Widget> getWidgets() {
		if (widgets == null) {
			widgets = new EObjectContainmentEList<>(Widget.class, this, UiPackage.COMPOSITE_WIDGET__WIDGETS);
		}
		return widgets;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public CompositeWidgetType getWidgetType() {
		if (widgetType != null && widgetType.eIsProxy()) {
			InternalEObject oldWidgetType = (InternalEObject) widgetType;
			widgetType = (CompositeWidgetType) eResolveProxy(oldWidgetType);
			if (widgetType != oldWidgetType) {
				if (eNotificationRequired()) {
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, UiPackage.COMPOSITE_WIDGET__WIDGET_TYPE, oldWidgetType, widgetType));
				}
			}
		}
		return widgetType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	public CompositeWidgetType basicGetWidgetType() {
		return widgetType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public void setWidgetType(CompositeWidgetType newWidgetType) {
		CompositeWidgetType oldWidgetType = widgetType;
		widgetType = newWidgetType;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.SET, UiPackage.COMPOSITE_WIDGET__WIDGET_TYPE, oldWidgetType, widgetType));
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
		case UiPackage.COMPOSITE_WIDGET__LAYOUT:
			return basicSetLayout(null, msgs);
		case UiPackage.COMPOSITE_WIDGET__WIDGETS:
			return ((InternalEList<?>) getWidgets()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
		case UiPackage.COMPOSITE_WIDGET__LAYOUT:
			return getLayout();
		case UiPackage.COMPOSITE_WIDGET__WIDGETS:
			return getWidgets();
		case UiPackage.COMPOSITE_WIDGET__WIDGET_TYPE:
			if (resolve) {
				return getWidgetType();
			}
			return basicGetWidgetType();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
		case UiPackage.COMPOSITE_WIDGET__LAYOUT:
			setLayout((Layout) newValue);
			return;
		case UiPackage.COMPOSITE_WIDGET__WIDGETS:
			getWidgets().clear();
			getWidgets().addAll((Collection<? extends Widget>) newValue);
			return;
		case UiPackage.COMPOSITE_WIDGET__WIDGET_TYPE:
			setWidgetType((CompositeWidgetType) newValue);
			return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
		case UiPackage.COMPOSITE_WIDGET__LAYOUT:
			setLayout((Layout) null);
			return;
		case UiPackage.COMPOSITE_WIDGET__WIDGETS:
			getWidgets().clear();
			return;
		case UiPackage.COMPOSITE_WIDGET__WIDGET_TYPE:
			setWidgetType((CompositeWidgetType) null);
			return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
		case UiPackage.COMPOSITE_WIDGET__LAYOUT:
			return layout != null;
		case UiPackage.COMPOSITE_WIDGET__WIDGETS:
			return widgets != null && !widgets.isEmpty();
		case UiPackage.COMPOSITE_WIDGET__WIDGET_TYPE:
			return widgetType != null;
		}
		return super.eIsSet(featureID);
	}

} // CompositeWidgetImpl
