/*****************************************************************************
 * Copyright (c) 2013 CEA LIST.
 *
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *  Vincent Lorenzo (CEA LIST) vincent.lorenzo@cea.fr - Initial API and implementation
 *
 *****************************************************************************/
package org.eclipse.papyrus.infra.nattable.handler;

import java.util.List;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.nebula.widgets.nattable.ui.NatEventData;
import org.eclipse.papyrus.infra.nattable.manager.axis.IAxisManager;

/**
 * The handler used to destroy the element represented by the selected rows
 *
 * @author Vincent Lorenzo
 *
 */
public class RowDestroyAxisElementHandler extends AbstractTableHandler {

	/**
	 *
	 * @see org.eclipse.core.commands.AbstractHandler#execute(org.eclipse.core.commands.ExecutionEvent)
	 *
	 * @param event
	 * @return
	 * @throws ExecutionException
	 */
	@Override
	public Object execute(ExecutionEvent event) throws ExecutionException {
		final IAxisManager axisManager = getRowAxisManager();
		NatEventData eventData = getNatEventData();
		if (axisManager != null && eventData != null) {
			axisManager.destroyAxisElement(getFullSelectedRowsIndex(eventData));
		}
		return null;
	}

	/**
	 *
	 * @see org.eclipse.core.commands.AbstractHandler#setEnabled(java.lang.Object)
	 *
	 * @param evaluationContext
	 */
	@Override
	public void setEnabled(Object evaluationContext) {
		super.setEnabled(evaluationContext);
		boolean enabled = false;
		NatEventData eventData = getNatEventData();
		final IAxisManager axisManager = getRowAxisManager();
		if (isEnabled() && axisManager != null && eventData != null) {
			final List<Integer> rows = getFullSelectedRowsIndex(eventData);
			enabled = axisManager.canDestroyAxisElement(rows);
		}
		setBaseEnabled(enabled);
	}
}
