/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.statemachine.custom.commands;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.papyrus.infra.emf.gmf.util.GMFUnsafe;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Pseudostate;
import org.eclipse.uml2.uml.PseudostateKind;
import org.eclipse.uml2.uml.Region;
import org.eclipse.uml2.uml.State;
import org.eclipse.uml2.uml.StateMachine;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.Vertex;

public class EMFCustomTransitionRetargetContainerCommand
extends GMFUnsafe.UnsafeCommand {
    protected Transition transition;
    protected Region oldRegion;
    protected Region newRegion;

    public EMFCustomTransitionRetargetContainerCommand(Transition transition) {
        super(TransactionUtil.getEditingDomain((EObject)transition));
        this.transition = transition;
    }

    public static boolean changeContainer(Transition transition) {
        Region region = EMFCustomTransitionRetargetContainerCommand.deduceContainer((EObject)transition.getSource(), (EObject)transition.getTarget());
        if (region == null) {
            return false;
        }
        if (region != transition.getOwner()) {
            region.getTransitions().add((Object)transition);
        }
        return true;
    }

    public static boolean isValid(EObject sourceE, EObject targetE) {
        if (targetE == null) {
            return true;
        }
        NamedElement source = EMFCustomTransitionRetargetContainerCommand.getNearestStateOrSM(sourceE);
        NamedElement target = EMFCustomTransitionRetargetContainerCommand.getNearestStateOrSM(targetE);
        Region sourceRegion = EMFCustomTransitionRetargetContainerCommand.getNearestRegion((EObject)source);
        Region targetRegion = EMFCustomTransitionRetargetContainerCommand.getNearestRegion((EObject)target);
        if (EMFCustomTransitionRetargetContainerCommand.isChild((EObject)source, (EObject)targetRegion)) {
            if (EMFCustomTransitionRetargetContainerCommand.isExitPoint(sourceE)) {
                return false;
            }
            return !EMFCustomTransitionRetargetContainerCommand.isExitPoint(targetE);
        }
        if (EMFCustomTransitionRetargetContainerCommand.isChild((EObject)target, (EObject)sourceRegion)) {
            if (EMFCustomTransitionRetargetContainerCommand.isEntryPoint(sourceE)) {
                return false;
            }
            return !EMFCustomTransitionRetargetContainerCommand.isEntryPoint(targetE);
        }
        if (source == target) {
            return (!EMFCustomTransitionRetargetContainerCommand.isEntryPoint(sourceE) || !EMFCustomTransitionRetargetContainerCommand.isEntryPoint(targetE)) && (!EMFCustomTransitionRetargetContainerCommand.isExitPoint(sourceE) || !EMFCustomTransitionRetargetContainerCommand.isExitPoint(targetE));
        }
        if (EMFCustomTransitionRetargetContainerCommand.isEntryPoint(sourceE)) {
            return false;
        }
        return !EMFCustomTransitionRetargetContainerCommand.isExitPoint(targetE);
    }

    public static Region deduceContainer(EObject sourceE, EObject targetE) {
        NamedElement source = EMFCustomTransitionRetargetContainerCommand.getNearestStateOrSM(sourceE);
        if (targetE == null) {
            if (EMFCustomTransitionRetargetContainerCommand.getNearestRegion((EObject)source) != null) {
                return EMFCustomTransitionRetargetContainerCommand.getNearestRegion((EObject)source);
            }
            return EMFCustomTransitionRetargetContainerCommand.firstRegion((EObject)source);
        }
        NamedElement target = EMFCustomTransitionRetargetContainerCommand.getNearestStateOrSM(targetE);
        Region sourceRegion = EMFCustomTransitionRetargetContainerCommand.getNearestRegion((EObject)source);
        Region targetRegion = EMFCustomTransitionRetargetContainerCommand.getNearestRegion((EObject)target);
        if (EMFCustomTransitionRetargetContainerCommand.isChild((EObject)source, (EObject)targetRegion)) {
            return EMFCustomTransitionRetargetContainerCommand.childRegion(sourceRegion, source, targetRegion, target);
        }
        if (EMFCustomTransitionRetargetContainerCommand.isChild((EObject)target, (EObject)sourceRegion)) {
            return EMFCustomTransitionRetargetContainerCommand.childRegion(targetRegion, target, sourceRegion, source);
        }
        if (source == target) {
            if (EMFCustomTransitionRetargetContainerCommand.isEntryPoint(sourceE) || EMFCustomTransitionRetargetContainerCommand.isExitPoint(targetE)) {
                return EMFCustomTransitionRetargetContainerCommand.firstRegion((EObject)source);
            }
            return sourceRegion;
        }
        if (EMFCustomTransitionRetargetContainerCommand.isChild((EObject)targetRegion, (EObject)sourceRegion)) {
            return targetRegion;
        }
        return sourceRegion;
    }

    public static Region childRegion(Region sourceRegion, NamedElement source, Region targetRegion, NamedElement target) {
        EList regions = null;
        if (source instanceof State) {
            regions = ((State)source).getRegions();
        } else if (source instanceof StateMachine) {
            regions = ((StateMachine)source).getRegions();
        }
        if (regions != null) {
            for (Region region : regions) {
                if (!EMFCustomTransitionRetargetContainerCommand.isChild((EObject)region, (EObject)targetRegion)) continue;
                return region;
            }
        }
        return null;
    }

    public static Region firstRegion(EObject source) {
        EList regions = null;
        if (source instanceof State) {
            regions = ((State)source).getRegions();
        } else if (source instanceof StateMachine) {
            regions = ((StateMachine)source).getRegions();
        }
        if (regions != null && regions.size() > 0) {
            return (Region)regions.get(0);
        }
        return null;
    }

    public static boolean isChild(EObject parent, EObject child) {
        EObject element = child;
        while (element != null) {
            if (element == parent) {
                return true;
            }
            element = element.eContainer();
        }
        return false;
    }

    public static boolean isEntryPoint(EObject vertex) {
        Pseudostate ps;
        return vertex instanceof Pseudostate && (ps = (Pseudostate)vertex).getKind() == PseudostateKind.ENTRY_POINT_LITERAL;
    }

    public static boolean isExitPoint(EObject vertex) {
        Pseudostate ps;
        return vertex instanceof Pseudostate && (ps = (Pseudostate)vertex).getKind() == PseudostateKind.EXIT_POINT_LITERAL;
    }

    public static Region getNearestRegion(EObject startFrom) {
        EObject element = startFrom;
        while (element != null) {
            if (element instanceof Region) {
                return (Region)element;
            }
            element = element.eContainer();
        }
        return null;
    }

    public static NamedElement getNearestStateOrSM(EObject vertex) {
        Pseudostate ps;
        if (vertex instanceof Pseudostate && ((ps = (Pseudostate)vertex).getKind() == PseudostateKind.ENTRY_POINT_LITERAL || ps.getKind() == PseudostateKind.EXIT_POINT_LITERAL)) {
            State state = ps.getState();
            if (state != null) {
                return state;
            }
            StateMachine sm = ps.getStateMachine();
            if (sm != null) {
                return sm;
            }
        }
        if (vertex instanceof Vertex) {
            return (Vertex)vertex;
        }
        return null;
    }

    protected void doExecute() {
        this.oldRegion = (Region)this.transition.getOwner();
        EMFCustomTransitionRetargetContainerCommand.changeContainer(this.transition);
        this.newRegion = (Region)this.transition.getOwner();
    }

    protected void doUndo() {
        if (this.oldRegion != this.transition.getOwner()) {
            this.oldRegion.getTransitions().add((Object)this.transition);
        }
    }

    protected void doRedo() {
        if (this.newRegion != this.transition.getOwner()) {
            this.newRegion.getTransitions().add((Object)this.transition);
        }
    }

    protected boolean prepare() {
        return true;
    }
}

