/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.model.nattable.nattablestyle;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum DisplayStyle implements Enumerator
{
    NORMAL(0, "NORMAL", "NORMAL"),
    HIERARCHIC_SINGLE_TREE_COLUMN(1, "HIERARCHIC_SINGLE_TREE_COLUMN", "HIERARCHIC_SINGLE_TREE_COLUMN"),
    HIERARCHIC_MULTI_TREE_COLUMN(2, "HIERARCHIC_MULTI_TREE_COLUMN", "HIERARCHIC_MULTI_TREE_COLUMN");

    public static final int NORMAL_VALUE = 0;
    public static final int HIERARCHIC_SINGLE_TREE_COLUMN_VALUE = 1;
    public static final int HIERARCHIC_MULTI_TREE_COLUMN_VALUE = 2;
    private static final DisplayStyle[] VALUES_ARRAY;
    public static final List<DisplayStyle> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new DisplayStyle[]{NORMAL, HIERARCHIC_SINGLE_TREE_COLUMN, HIERARCHIC_MULTI_TREE_COLUMN};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static DisplayStyle get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            DisplayStyle result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static DisplayStyle getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            DisplayStyle result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static DisplayStyle get(int value) {
        switch (value) {
            case 0: {
                return NORMAL;
            }
            case 1: {
                return HIERARCHIC_SINGLE_TREE_COLUMN;
            }
            case 2: {
                return HIERARCHIC_MULTI_TREE_COLUMN;
            }
        }
        return null;
    }

    private DisplayStyle(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

