/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.validation.common.utils;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.papyrus.toolsmiths.validation.common.Activator;
import org.eclipse.papyrus.toolsmiths.validation.common.checkers.IPluginChecker2;
import org.eclipse.papyrus.toolsmiths.validation.common.internal.utils.MarkersManagementUtils;

public class MarkersService {
    public static IMarker createMarker(IResource resource, String type, String message, int severity) {
        return MarkersManagementUtils.createMarker(resource, type, message, severity);
    }

    public static IMarker createMarker(IResource resource, String type) {
        return MarkersManagementUtils.createMarker(resource, type);
    }

    public static IMarker createMarker(IResource resource, String type, Diagnostic diagnostic) {
        int severity = diagnostic.getSeverity() == 1 ? 0 : (diagnostic.getSeverity() == 2 ? 1 : 2);
        IMarker result = MarkersService.createMarker(resource, type, IPluginChecker2.getMessage(diagnostic), severity);
        String target = null;
        StringBuilder related = null;
        for (Object next : diagnostic.getData()) {
            if (next instanceof EObject) {
                String uri = String.valueOf(EcoreUtil.getURI((EObject)((EObject)next)));
                if (target == null) {
                    target = uri;
                    continue;
                }
                if (related == null) {
                    related = new StringBuilder();
                } else {
                    related.append(' ');
                }
                related.append(URI.encodeFragment((String)uri, (boolean)false));
                continue;
            }
            if (!(next instanceof IPluginChecker2.MarkerAttribute)) continue;
            IPluginChecker2.MarkerAttribute attr = (IPluginChecker2.MarkerAttribute)next;
            attr.applyTo(result);
        }
        try {
            if (diagnostic.getSource() != null && !diagnostic.getSource().isBlank()) {
                result.setAttribute("source", (Object)diagnostic.getSource());
            }
            if (target != null) {
                result.setAttribute("uri", target);
            }
            if (related != null) {
                result.setAttribute("relatedURIs", (Object)related.toString());
            }
        }
        catch (CoreException e) {
            Activator.log.error("Failed to set attributes of problem marker.", (Throwable)e);
        }
        return result;
    }

    public static void deleteMarkers(IResource resource, String type) {
        MarkersManagementUtils.deleteMarkers(resource, type);
    }
}

