/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.formula;

import org.eclipse.nebula.widgets.nattable.command.LayerCommandUtil;
import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.coordinate.ColumnPositionCoordinate;
import org.eclipse.nebula.widgets.nattable.coordinate.RowPositionCoordinate;
import org.eclipse.nebula.widgets.nattable.copy.InternalCellClipboard;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.painter.cell.BorderPainter;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayerPainter;
import org.eclipse.nebula.widgets.nattable.style.BorderStyle;
import org.eclipse.nebula.widgets.nattable.style.CellStyleAttributes;
import org.eclipse.nebula.widgets.nattable.style.DisplayMode;
import org.eclipse.nebula.widgets.nattable.style.IStyle;
import org.eclipse.nebula.widgets.nattable.util.GUIHelper;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;

public class CopySelectionLayerPainter
extends SelectionLayerPainter {
    protected InternalCellClipboard clipboard;

    public CopySelectionLayerPainter(InternalCellClipboard clipboard) {
        this.clipboard = clipboard;
    }

    public CopySelectionLayerPainter(InternalCellClipboard clipboard, Color gridColor) {
        this.clipboard = clipboard;
    }

    public CopySelectionLayerPainter(InternalCellClipboard clipboard, Color gridColor, boolean clipLeft, boolean clipTop) {
        super(gridColor, clipLeft, clipTop);
        this.clipboard = clipboard;
    }

    public CopySelectionLayerPainter(InternalCellClipboard clipboard, boolean clipLeft, boolean clipTop) {
        this(clipboard, GUIHelper.COLOR_GRAY, clipLeft, clipTop);
    }

    @Override
    public void paintLayer(ILayer natLayer, GC gc, int xOffset, int yOffset, Rectangle pixelRectangle, IConfigRegistry configRegistry) {
        super.paintLayer(natLayer, gc, xOffset, yOffset, pixelRectangle, configRegistry);
        if (this.clipboard.getCopiedCells() != null) {
            Rectangle positionRectangle = this.getPositionRectangleFromPixelRectangle(natLayer, pixelRectangle);
            if (positionRectangle.width <= 0 || positionRectangle.height <= 0) {
                return;
            }
            BorderPainter.BorderCell[][] borderCells = this.getBorderCells(natLayer, xOffset, yOffset, positionRectangle, cell -> {
                if (cell.getColumnIndex() >= 0 && cell.getRowIndex() >= 0) {
                    ColumnPositionCoordinate convertedColumn = null;
                    RowPositionCoordinate convertedRow = null;
                    ILayerCell convertedCell = null;
                    boolean convertedCalculated = false;
                    ILayerCell[][] iLayerCellArray = this.clipboard.getCopiedCells();
                    int n = iLayerCellArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ILayerCell[] cells;
                        ILayerCell[] iLayerCellArray2 = cells = iLayerCellArray[n2];
                        int n3 = cells.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            ILayerCell copyCell = iLayerCellArray2[n4];
                            if (copyCell != null) {
                                if (!convertedCalculated) {
                                    convertedColumn = LayerCommandUtil.convertColumnPositionToTargetContext(new ColumnPositionCoordinate(cell.getLayer(), cell.getColumnPosition()), copyCell.getLayer());
                                    convertedRow = LayerCommandUtil.convertRowPositionToTargetContext(new RowPositionCoordinate(cell.getLayer(), cell.getRowPosition()), copyCell.getLayer());
                                    if (convertedColumn != null && convertedRow != null) {
                                        convertedCell = convertedColumn.getLayer().getCellByPosition(convertedColumn.getColumnPosition(), convertedRow.getRowPosition());
                                    }
                                    convertedCalculated = true;
                                }
                                if (convertedCell != null && convertedCell.getOriginColumnPosition() == copyCell.getOriginColumnPosition() && convertedCell.getOriginRowPosition() == copyCell.getOriginRowPosition()) {
                                    return true;
                                }
                            }
                            ++n4;
                        }
                        ++n2;
                    }
                }
                return false;
            });
            if (borderCells != null) {
                int originalLineStyle = gc.getLineStyle();
                int originalLineWidth = gc.getLineWidth();
                Color originalForeground = gc.getForeground();
                BorderStyle borderStyle = this.getCopyBorderStyle(configRegistry);
                BorderPainter.PaintModeEnum paintMode = positionRectangle.width <= 2 && positionRectangle.height <= 2 ? BorderPainter.PaintModeEnum.NO_EXTERNAL_BORDERS : BorderPainter.PaintModeEnum.ALL;
                BorderPainter borderPainter = new BorderPainter(borderCells, borderStyle, paintMode);
                borderPainter.paintBorder(gc);
                gc.setLineStyle(originalLineStyle);
                gc.setLineWidth(originalLineWidth);
                gc.setForeground(originalForeground);
            }
        }
    }

    protected BorderStyle getCopyBorderStyle(IConfigRegistry configRegistry) {
        BorderStyle borderStyle;
        IStyle cellStyle = configRegistry.getConfigAttribute(CellConfigAttributes.CELL_STYLE, DisplayMode.NORMAL, "copyBorderStyle");
        BorderStyle borderStyle2 = borderStyle = cellStyle != null ? cellStyle.getAttributeValue(CellStyleAttributes.BORDER_STYLE) : null;
        if (borderStyle == null) {
            borderStyle = new BorderStyle(1, GUIHelper.COLOR_BLACK, BorderStyle.LineStyleEnum.DASHED, BorderStyle.BorderModeEnum.CENTERED);
        }
        return borderStyle;
    }
}

