/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.parser;

import prefuse.data.parser.DataParseException;
import prefuse.data.parser.DataParser;

public class ByteParser
implements DataParser {
    public Class getType() {
        return Byte.TYPE;
    }

    public String format(Object value) {
        if (value == null) {
            return null;
        }
        if (!(value instanceof Number)) {
            throw new IllegalArgumentException("This class can only format Objects of type Number.");
        }
        return String.valueOf(((Number)value).byteValue());
    }

    public boolean canParse(String text) {
        try {
            Byte.parseByte(text);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public Object parse(String text) throws DataParseException {
        return new Byte(ByteParser.parseByte(text));
    }

    public static byte parseByte(String text) throws DataParseException {
        try {
            return Byte.parseByte(text);
        }
        catch (NumberFormatException e) {
            throw new DataParseException(e);
        }
    }
}

