/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.column;

import java.util.Date;
import prefuse.data.DataTypeException;
import prefuse.data.Table;
import prefuse.data.column.BooleanColumn;
import prefuse.data.column.ByteColumn;
import prefuse.data.column.Column;
import prefuse.data.column.ConstantColumn;
import prefuse.data.column.DateColumn;
import prefuse.data.column.DoubleColumn;
import prefuse.data.column.ExpressionColumn;
import prefuse.data.column.FloatColumn;
import prefuse.data.column.IntColumn;
import prefuse.data.column.LongColumn;
import prefuse.data.column.ObjectColumn;
import prefuse.data.expression.Expression;

public class ColumnFactory {
    public static final Column getColumn(Class type) {
        return ColumnFactory.getColumn(type, 0, 0, null);
    }

    public static final Column getColumn(Class type, int nrows) {
        return ColumnFactory.getColumn(type, nrows, nrows, null);
    }

    public static final Column getColumn(Class type, int nrows, Object defaultValue) {
        return ColumnFactory.getColumn(type, nrows, nrows, defaultValue);
    }

    public static final Column getColumn(Class type, int nrows, int nnz, Object defaultValue) {
        if (type == Byte.TYPE) {
            if (defaultValue == null) {
                return new ByteColumn(nrows);
            }
            byte def = ((Number)defaultValue).byteValue();
            return new ByteColumn(nrows, nrows, def);
        }
        if (type == Integer.TYPE) {
            if (defaultValue == null) {
                return new IntColumn(nrows);
            }
            int def = ((Number)defaultValue).intValue();
            return new IntColumn(nrows, nrows, def);
        }
        if (type == Long.TYPE) {
            if (defaultValue == null) {
                return new LongColumn(nrows);
            }
            long def = ((Number)defaultValue).longValue();
            return new LongColumn(nrows, nrows, def);
        }
        if (type == Float.TYPE) {
            if (defaultValue == null) {
                return new FloatColumn(nrows);
            }
            float def = ((Number)defaultValue).floatValue();
            return new FloatColumn(nrows, nrows, def);
        }
        if (type == Double.TYPE) {
            if (defaultValue == null) {
                return new DoubleColumn(nrows);
            }
            double def = ((Number)defaultValue).doubleValue();
            return new DoubleColumn(nrows, nrows, def);
        }
        if (type == Boolean.TYPE) {
            if (defaultValue == null) {
                return new BooleanColumn(nrows);
            }
            boolean def = (Boolean)defaultValue;
            return new BooleanColumn(nrows, nrows, def);
        }
        if (Date.class.isAssignableFrom(type)) {
            if (defaultValue == null) {
                return new DateColumn(type, nrows);
            }
            Date d = (Date)defaultValue;
            return new DateColumn(type, nrows, nrows, d.getTime());
        }
        if (type == Byte.TYPE || type == Short.TYPE || type == Character.TYPE || type == Void.TYPE) {
            throw new DataTypeException(type);
        }
        return new ObjectColumn(type, nrows, nrows, defaultValue);
    }

    public static final Column getColumn(Table t, Expression expr) {
        return new ExpressionColumn(t, expr);
    }

    public static final Column getConstantColumn(Class type, Object dflt) {
        return new ConstantColumn(type, dflt);
    }
}

