/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.infra.browser.editors;

import org.eclipse.gmt.modisco.infra.browser.core.MetaclassList;
import org.eclipse.gmt.modisco.infra.browser.core.SearchResults;
import org.eclipse.gmt.modisco.infra.browser.editors.EcoreBrowser;
import org.eclipse.gmt.modisco.infra.browser.editors.NonBlockingElementComputation;
import org.eclipse.gmt.modisco.infra.browser.uicore.internal.model.ITreeElement;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;

public class BrowserContentProvider
implements ITreeContentProvider {
    private final EcoreBrowser browser;
    private final ElementsComputation elementsComputation;
    private final ChildrenComputation childrenComputation;
    private final HasChildrenComputation hasChildrenComputation;

    public BrowserContentProvider(EcoreBrowser browser) {
        this.browser = browser;
        this.childrenComputation = new ChildrenComputation();
        this.hasChildrenComputation = new HasChildrenComputation();
        this.elementsComputation = new ElementsComputation();
    }

    public IWorkbenchSiteProgressService getProgressService() {
        return this.browser.getProgressService();
    }

    protected void refreshBrowser() {
        this.browser.refreshDelayed(false);
    }

    public Object[] getElements(Object inputElement) {
        return (Object[])this.elementsComputation.computeValue(inputElement);
    }

    public Object[] getChildren(Object parentElement) {
        return (Object[])this.childrenComputation.computeValue(parentElement);
    }

    public Object getParent(Object element) {
        if (element instanceof ITreeElement) {
            ITreeElement treeElement = (ITreeElement)element;
            return treeElement.getTreeParent();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return (Boolean)this.hasChildrenComputation.computeValue(element);
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public boolean isComputing() {
        return this.childrenComputation.isComputing() || this.hasChildrenComputation.isComputing();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ChildrenComputation
    extends NonBlockingElementComputation<Object[]> {
        public ChildrenComputation() {
            super(BrowserContentProvider.this.getProgressService());
        }

        @Override
        protected Object[] basicCompute(Object element) {
            if (element instanceof ITreeElement) {
                ITreeElement treeElement = (ITreeElement)element;
                return treeElement.getChildren().toArray();
            }
            return new Object[0];
        }

        @Override
        protected Object[] getTemporaryDefaultValue() {
            return new Object[]{EcoreBrowser.LOADING_MESSAGE};
        }

        @Override
        protected void computationFinished() {
            BrowserContentProvider.this.refreshBrowser();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ElementsComputation
    extends NonBlockingElementComputation<Object[]> {
        public ElementsComputation() {
            super(BrowserContentProvider.this.getProgressService());
        }

        @Override
        protected Object[] basicCompute(Object inputElement) {
            if (inputElement instanceof MetaclassList) {
                MetaclassList metaclassList = (MetaclassList)inputElement;
                return metaclassList.getElements().toArray();
            }
            if (inputElement instanceof SearchResults) {
                SearchResults searchResults = (SearchResults)inputElement;
                return searchResults.getElements().toArray();
            }
            if (inputElement == EcoreBrowser.LOADING_MESSAGE) {
                return new Object[]{EcoreBrowser.LOADING_MESSAGE};
            }
            return null;
        }

        @Override
        protected Object[] getTemporaryDefaultValue() {
            return new Object[]{EcoreBrowser.LOADING_MESSAGE};
        }

        @Override
        protected void computationFinished() {
            BrowserContentProvider.this.refreshBrowser();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class HasChildrenComputation
    extends NonBlockingElementComputation<Boolean> {
        public HasChildrenComputation() {
            super(BrowserContentProvider.this.getProgressService());
        }

        @Override
        protected Boolean basicCompute(Object element) {
            if (element instanceof ITreeElement) {
                ITreeElement treeElement = (ITreeElement)element;
                return treeElement.hasChildren();
            }
            return Boolean.FALSE;
        }

        @Override
        protected Boolean getTemporaryDefaultValue() {
            return Boolean.FALSE;
        }

        @Override
        protected void computationFinished() {
            BrowserContentProvider.this.refreshBrowser();
        }
    }
}

