/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.gen;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.codegen.ecore.genmodel.GenClass;
import org.eclipse.emf.codegen.ecore.genmodel.GenFeature;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenModelFactory;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.codegen.util.CodeGenUtil;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gmf.codegen.gmfgen.Behaviour;
import org.eclipse.gmf.codegen.gmfgen.ElementType;
import org.eclipse.gmf.codegen.gmfgen.FeatureLabelModelFacet;
import org.eclipse.gmf.codegen.gmfgen.FeatureLinkModelFacet;
import org.eclipse.gmf.codegen.gmfgen.FigureViewmap;
import org.eclipse.gmf.codegen.gmfgen.GMFGenFactory;
import org.eclipse.gmf.codegen.gmfgen.GMFGenPackage;
import org.eclipse.gmf.codegen.gmfgen.GenApplication;
import org.eclipse.gmf.codegen.gmfgen.GenAuditContainer;
import org.eclipse.gmf.codegen.gmfgen.GenAuditContext;
import org.eclipse.gmf.codegen.gmfgen.GenAuditRoot;
import org.eclipse.gmf.codegen.gmfgen.GenAuditRule;
import org.eclipse.gmf.codegen.gmfgen.GenAuditable;
import org.eclipse.gmf.codegen.gmfgen.GenChildContainer;
import org.eclipse.gmf.codegen.gmfgen.GenChildLabelNode;
import org.eclipse.gmf.codegen.gmfgen.GenChildNode;
import org.eclipse.gmf.codegen.gmfgen.GenCommonBase;
import org.eclipse.gmf.codegen.gmfgen.GenCompartment;
import org.eclipse.gmf.codegen.gmfgen.GenCustomPreferencePage;
import org.eclipse.gmf.codegen.gmfgen.GenDiagram;
import org.eclipse.gmf.codegen.gmfgen.GenDiagramUpdater;
import org.eclipse.gmf.codegen.gmfgen.GenEditorGenerator;
import org.eclipse.gmf.codegen.gmfgen.GenEditorView;
import org.eclipse.gmf.codegen.gmfgen.GenExpressionInterpreter;
import org.eclipse.gmf.codegen.gmfgen.GenExpressionProviderContainer;
import org.eclipse.gmf.codegen.gmfgen.GenExternalNodeLabel;
import org.eclipse.gmf.codegen.gmfgen.GenLabel;
import org.eclipse.gmf.codegen.gmfgen.GenLink;
import org.eclipse.gmf.codegen.gmfgen.GenLinkLabel;
import org.eclipse.gmf.codegen.gmfgen.GenNavigator;
import org.eclipse.gmf.codegen.gmfgen.GenNode;
import org.eclipse.gmf.codegen.gmfgen.GenNodeLabel;
import org.eclipse.gmf.codegen.gmfgen.GenParsers;
import org.eclipse.gmf.codegen.gmfgen.GenPlugin;
import org.eclipse.gmf.codegen.gmfgen.GenPropertySheet;
import org.eclipse.gmf.codegen.gmfgen.GenStandardPreferencePage;
import org.eclipse.gmf.codegen.gmfgen.GenTopLevelNode;
import org.eclipse.gmf.codegen.gmfgen.LabelModelFacet;
import org.eclipse.gmf.codegen.gmfgen.LinkModelFacet;
import org.eclipse.gmf.codegen.gmfgen.MetamodelType;
import org.eclipse.gmf.codegen.gmfgen.Palette;
import org.eclipse.gmf.codegen.gmfgen.ProviderPriority;
import org.eclipse.gmf.codegen.gmfgen.SpecializationType;
import org.eclipse.gmf.codegen.gmfgen.StandardPreferencePages;
import org.eclipse.gmf.codegen.gmfgen.TypeLinkModelFacet;
import org.eclipse.gmf.codegen.gmfgen.TypeModelFacet;
import org.eclipse.gmf.codegen.gmfgen.Viewmap;
import org.eclipse.gmf.codegen.gmfgen.ViewmapLayoutType;
import org.eclipse.gmf.tests.ConfiguredTestCase;
import org.eclipse.gmf.tests.setup.SessionSetup;
import org.eclipse.jdt.core.JavaConventions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HandcodedImplTest
extends ConfiguredTestCase {
    private static final String INVALID_JAVA_CHARS = "<>?#!. =\"'\n\t\\";
    private static final Random RANDOM_GENERATOR = new Random();
    private GenDiagram myGenModel;
    private final String javaLevel = "1.4";

    public HandcodedImplTest(String name) {
        super(name);
        this.myDefaultSetup = SessionSetup.newInstance();
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.myGenModel = this.getSetup().getGenModel().getGenDiagram();
        if (this.myGenModel.getEditorGen().getAudits() == null) {
            GenAuditRoot root = GMFGenFactory.eINSTANCE.createGenAuditRoot();
            this.myGenModel.getEditorGen().setAudits(root);
            GenAuditContainer cat = GMFGenFactory.eINSTANCE.createGenAuditContainer();
            root.getCategories().add((Object)cat);
            GenAuditRule rule = GMFGenFactory.eINSTANCE.createGenAuditRule();
            root.getRules().add((Object)rule);
            rule.setCategory(cat);
            rule.setTarget((GenAuditable)GMFGenFactory.eINSTANCE.createGenDomainElementTarget());
        }
    }

    public void testUniqueIdentifier_IsUnique() {
        HashSet<String> allIds = new HashSet<String>(128);
        GenCommonBaseIterator it = new GenCommonBaseIterator(this.myGenModel);
        while (it.hasNext()) {
            GenCommonBase next = it.next();
            HandcodedImplTest.assertFalse((String)"There should be no two same 'unique' identifiers in GMFGen", (boolean)allIds.contains(next.getUniqueIdentifier()));
            allIds.add(next.getUniqueIdentifier());
        }
        HandcodedImplTest.assertTrue((String)"Test is not valid unless few elements were checked", (allIds.size() > 1 ? 1 : 0) != 0);
        allIds.clear();
    }

    public void testUniqueIdentifier_IsConstant() {
        LinkedList<String> allIdsOrdered = new LinkedList<String>();
        GenCommonBaseIterator it = new GenCommonBaseIterator(this.myGenModel);
        while (it.hasNext()) {
            GenCommonBase next = it.next();
            allIdsOrdered.add(next.getUniqueIdentifier());
        }
        HandcodedImplTest.assertTrue((String)"Test is not valid unless there are few elements to check", (allIdsOrdered.size() > 1 ? 1 : 0) != 0);
        Iterator itSaved = allIdsOrdered.iterator();
        GenCommonBaseIterator it2 = new GenCommonBaseIterator(this.myGenModel);
        while (it2.hasNext() && itSaved.hasNext()) {
            GenCommonBase next = it2.next();
            String savedID = ((String)itSaved.next()).toString();
            HandcodedImplTest.assertEquals((String)"Subsequent invocations of getUniqueIdentifier produce different results", (String)savedID, (String)next.getUniqueIdentifier());
        }
        HandcodedImplTest.assertEquals((String)"Lists are not equal in size", (boolean)itSaved.hasNext(), (boolean)it2.hasNext());
        allIdsOrdered.clear();
    }

    public void testGenEditorGenerator_DomainFileExtension() {
        GenEditorGenerator generator = GMFGenFactory.eINSTANCE.createGenEditorGenerator();
        generator.setDomainFileExtension("AAA");
        HandcodedImplTest.assertEquals((String)"AAA", (String)generator.getDomainFileExtension());
        generator.setDomainFileExtension(null);
        HandcodedImplTest.assertNotNull((Object)generator.getDomainFileExtension());
        GenModel genModel = GenModelFactory.eINSTANCE.createGenModel();
        GenPackage genPackage = GenModelFactory.eINSTANCE.createGenPackage();
        genPackage.setPrefix("CBA");
        genModel.getGenPackages().add((Object)genPackage);
        generator.setDomainGenModel(genModel);
        HandcodedImplTest.assertNotNull((Object)generator.getDomainFileExtension());
        HandcodedImplTest.assertEquals((String)"cba", (String)generator.getDomainFileExtension());
        generator.setDomainFileExtension("");
        HandcodedImplTest.assertNotNull((Object)generator.getDomainFileExtension());
        HandcodedImplTest.assertEquals((String)"cba", (String)generator.getDomainFileExtension());
        generator.setDomainFileExtension(" ");
        HandcodedImplTest.assertNotNull((Object)generator.getDomainFileExtension());
        HandcodedImplTest.assertEquals((String)"cba", (String)generator.getDomainFileExtension());
    }

    public void testGenEditorGenerator_DiagramFileExtension() {
        GenEditorGenerator generator = GMFGenFactory.eINSTANCE.createGenEditorGenerator();
        generator.setDomainFileExtension("AAA");
        this.checkStringPropertyWithDefault((EObject)generator, GMFGenPackage.eINSTANCE.getGenEditorGenerator_DiagramFileExtension());
    }

    public void testGenEditorGenerator_ModelId() {
        GenEditorGenerator generator = GMFGenFactory.eINSTANCE.createGenEditorGenerator();
        this.checkStringPropertyWithDefault((EObject)generator, GMFGenPackage.eINSTANCE.getGenEditorGenerator_ModelID());
        generator = GMFGenFactory.eINSTANCE.createGenEditorGenerator();
        GenModel mockGenModel = GenModelFactory.eINSTANCE.createGenModel();
        mockGenModel.setModelName("CBA");
        generator.setDomainGenModel(mockGenModel);
        HandcodedImplTest.assertEquals((String)"CBA", (String)generator.getModelID());
    }

    public void testGenEditorGenerator_PackageNamePrefix() {
        GenEditorGenerator generator = GMFGenFactory.eINSTANCE.createGenEditorGenerator();
        generator.setPackageNamePrefix(null);
        HandcodedImplTest.assertNotNull((Object)generator.getPackageNamePrefix());
        generator.setPackageNamePrefix("ABC");
        HandcodedImplTest.assertEquals((String)"ABC", (String)generator.getPackageNamePrefix());
        GenModel genModel = GenModelFactory.eINSTANCE.createGenModel();
        GenPackage genPackage = GenModelFactory.eINSTANCE.createGenPackage();
        genPackage.setBasePackage("CBA");
        genModel.getGenPackages().add((Object)genPackage);
        EPackage ePackage = EcoreFactory.eINSTANCE.createEPackage();
        ePackage.setName("DEF");
        genPackage.setEcorePackage(ePackage);
        generator.setDomainGenModel(genModel);
        HandcodedImplTest.assertEquals((String)"ABC", (String)generator.getPackageNamePrefix());
        this.checkStringPropertyWithDefault((EObject)generator, GMFGenPackage.eINSTANCE.getGenEditorGenerator_PackageNamePrefix());
    }

    public void testGenEditorGenerator_getAllDomainGenPackages() {
        GenModel genModel = GenModelFactory.eINSTANCE.createGenModel();
        genModel.setModelPluginID("plugin1");
        genModel.setModelDirectory("modelDir1");
        genModel.setEditDirectory("dir1");
        genModel.setEditPluginClass("EditPluginClassName");
        GenPackage genPackage1 = GenModelFactory.eINSTANCE.createGenPackage();
        GenClass genClass = GenModelFactory.eINSTANCE.createGenClass();
        genPackage1.getGenClasses().add((Object)genClass);
        genModel.getGenPackages().add((Object)genPackage1);
        GenPackage genPackage2 = GenModelFactory.eINSTANCE.createGenPackage();
        genModel.getGenPackages().add((Object)genPackage2);
        GenEditorGenerator generator = GMFGenFactory.eINSTANCE.createGenEditorGenerator();
        generator.setDomainGenModel(genModel);
        HandcodedImplTest.assertTrue((generator.getAllDomainGenPackages(false).size() == 1 ? 1 : 0) != 0);
        HandcodedImplTest.assertEquals((Object)genPackage1, (Object)generator.getAllDomainGenPackages(false).get(0));
        GenModel genModel2 = GenModelFactory.eINSTANCE.createGenModel();
        genModel2.setModelPluginID("plugin2");
        genModel2.setModelDirectory("modelDir2");
        genModel2.setEditDirectory("dir2");
        genModel2.setEditPluginClass("EditPluginClassName2");
        GenPackage genPackage3 = GenModelFactory.eINSTANCE.createGenPackage();
        genClass = GenModelFactory.eINSTANCE.createGenClass();
        genPackage3.getGenClasses().add((Object)genClass);
        genModel2.getGenPackages().add((Object)genPackage3);
        GenPackage genPackage4 = GenModelFactory.eINSTANCE.createGenPackage();
        genModel2.getGenPackages().add((Object)genPackage4);
        genModel.getUsedGenPackages().add((Object)genPackage3);
        genModel.getUsedGenPackages().add((Object)genPackage4);
        HandcodedImplTest.assertTrue((generator.getAllDomainGenPackages(false).size() == 1 ? 1 : 0) != 0);
        HandcodedImplTest.assertEquals((Object)genPackage1, (Object)generator.getAllDomainGenPackages(false).get(0));
        HandcodedImplTest.assertTrue((generator.getAllDomainGenPackages(true).size() == 2 ? 1 : 0) != 0);
        HandcodedImplTest.assertTrue((boolean)generator.getAllDomainGenPackages(true).contains((Object)genPackage1));
        HandcodedImplTest.assertTrue((boolean)generator.getAllDomainGenPackages(true).contains((Object)genPackage3));
    }

    public void testGenPlugin_RequiredPluginIds() {
        String[] BUNDLE_VIEWMAPS_MANY = new String[]{"com.mycompany.viewmapsA", "com.mycompany.viewmapsB"};
        GenEditorGenerator mockGenerator = GMFGenFactory.eINSTANCE.createGenEditorGenerator();
        GenExpressionProviderContainer expressionProviderContainer = GMFGenFactory.eINSTANCE.createGenExpressionProviderContainer();
        mockGenerator.setExpressionProviders(expressionProviderContainer);
        GenExpressionInterpreter expressionProvider = GMFGenFactory.eINSTANCE.createGenExpressionInterpreter();
        expressionProviderContainer.getProviders().add((Object)expressionProvider);
        GenPlugin mockPlugin = GMFGenFactory.eINSTANCE.createGenPlugin();
        mockPlugin.getRequiredPlugins().add((Object)"com.mycompany.expressions");
        mockGenerator.setPlugin(mockPlugin);
        GenDiagram mockDiagram = GMFGenFactory.eINSTANCE.createGenDiagram();
        mockGenerator.setDiagram(mockDiagram);
        GenTopLevelNode mockNodeA = GMFGenFactory.eINSTANCE.createGenTopLevelNode();
        mockDiagram.getTopLevelNodes().add((Object)mockNodeA);
        FigureViewmap mockViewmapA = GMFGenFactory.eINSTANCE.createFigureViewmap();
        mockViewmapA.getRequiredPluginIDs().add((Object)"com.mycompany.viewmapsC");
        mockNodeA.setViewmap((Viewmap)mockViewmapA);
        GenTopLevelNode mockNodeB = GMFGenFactory.eINSTANCE.createGenTopLevelNode();
        mockDiagram.getTopLevelNodes().add((Object)mockNodeB);
        FigureViewmap mockViewmapB = GMFGenFactory.eINSTANCE.createFigureViewmap();
        mockViewmapB.getRequiredPluginIDs().addAll(Arrays.asList(BUNDLE_VIEWMAPS_MANY));
        mockNodeB.setViewmap((Viewmap)mockViewmapB);
        EList allRequired = mockPlugin.getAllRequiredPlugins();
        HandcodedImplTest.assertTrue((boolean)allRequired.contains("com.mycompany.expressions"));
        HandcodedImplTest.assertTrue((boolean)allRequired.contains("com.mycompany.viewmapsC"));
        HandcodedImplTest.assertTrue((boolean)allRequired.containsAll(Arrays.asList(BUNDLE_VIEWMAPS_MANY)));
    }

    public void testGenPlugin_ID() {
        GenPlugin genPlugin = GMFGenFactory.eINSTANCE.createGenPlugin();
        GenEditorGenerator editorGen = GMFGenFactory.eINSTANCE.createGenEditorGenerator();
        editorGen.setPlugin(genPlugin);
        this.checkStringPropertyWithDefault((EObject)genPlugin, GMFGenPackage.eINSTANCE.getGenPlugin_ID());
    }

    public void testGenPlugin_Name() {
        GenEditorGenerator genEditorGenerator = GMFGenFactory.eINSTANCE.createGenEditorGenerator();
        GenPlugin genPlugin = GMFGenFactory.eINSTANCE.createGenPlugin();
        genEditorGenerator.setPlugin(genPlugin);
        this.checkStringPropertyWithDefault((EObject)genPlugin, GMFGenPackage.eINSTANCE.getGenPlugin_Name());
    }

    public void testGenDiagram_EditingDomainID() {
        GenDiagram genDiagram = GMFGenFactory.eINSTANCE.createGenDiagram();
        GenEditorGenerator editorGen = GMFGenFactory.eINSTANCE.createGenEditorGenerator();
        editorGen.setDiagram(genDiagram);
        editorGen.setPlugin(GMFGenFactory.eINSTANCE.createGenPlugin());
        this.checkStringPropertyWithDefault((EObject)genDiagram, GMFGenPackage.eINSTANCE.getEditorCandies_EditingDomainID());
    }

    public void testGenDiagram_generateCreateShortcutAction() {
        GenDiagram genDiagram = GMFGenFactory.eINSTANCE.createGenDiagram();
        genDiagram.getContainsShortcutsTo().clear();
        HandcodedImplTest.assertFalse((boolean)genDiagram.generateCreateShortcutAction());
        genDiagram.getContainsShortcutsTo().add((Object)"ecore");
        HandcodedImplTest.assertTrue((boolean)genDiagram.generateCreateShortcutAction());
    }

    public void testGenDiagram_generateShortcutIcon() {
        GenDiagram genDiagram = GMFGenFactory.eINSTANCE.createGenDiagram();
        genDiagram.getShortcutsProvidedFor().clear();
        HandcodedImplTest.assertFalse((boolean)genDiagram.generateShortcutIcon());
        genDiagram.getShortcutsProvidedFor().add((Object)"Ecore");
        HandcodedImplTest.assertTrue((boolean)genDiagram.generateShortcutIcon());
    }

    public void testGenDiagram_generateInitDiagramAction() {
        GenDiagram genDiagram = GMFGenFactory.eINSTANCE.createGenDiagram();
        HandcodedImplTest.assertFalse((boolean)genDiagram.generateInitDiagramAction());
        genDiagram.setDomainDiagramElement(GenModelFactory.eINSTANCE.createGenClass());
        HandcodedImplTest.assertTrue((boolean)genDiagram.generateInitDiagramAction());
    }

    public void testGenDiagram_hasLinkCreationConstraints() {
        GenDiagram genDiagram = GMFGenFactory.eINSTANCE.createGenDiagram();
        GenLink link = GMFGenFactory.eINSTANCE.createGenLink();
        genDiagram.getLinks().add((Object)link);
        HandcodedImplTest.assertFalse((boolean)genDiagram.hasLinkCreationConstraints());
        link = GMFGenFactory.eINSTANCE.createGenLink();
        genDiagram.getLinks().add((Object)link);
        link.setCreationConstraints(GMFGenFactory.eINSTANCE.createGenLinkConstraints());
        HandcodedImplTest.assertTrue((boolean)genDiagram.hasLinkCreationConstraints());
    }

    public void testGenDiagram_getAllNodes() {
        GenDiagram genDiagram = GMFGenFactory.eINSTANCE.createGenDiagram();
        GenTopLevelNode topLevelNode = GMFGenFactory.eINSTANCE.createGenTopLevelNode();
        genDiagram.getTopLevelNodes().add((Object)topLevelNode);
        GenChildNode childNode = GMFGenFactory.eINSTANCE.createGenChildNode();
        genDiagram.getChildNodes().add((Object)childNode);
        GenCompartment genCompartment = GMFGenFactory.eINSTANCE.createGenCompartment();
        genDiagram.getCompartments().add((Object)genCompartment);
        EList nodes = genDiagram.getAllNodes();
        HandcodedImplTest.assertTrue((boolean)nodes.contains(topLevelNode));
        HandcodedImplTest.assertTrue((boolean)nodes.contains(childNode));
        HandcodedImplTest.assertFalse((boolean)nodes.contains(genCompartment));
        HandcodedImplTest.assertFalse((boolean)nodes.contains(genDiagram));
    }

    public void testGenDiagram_getAllChildContainers() {
        GenDiagram genDiagram = GMFGenFactory.eINSTANCE.createGenDiagram();
        GenTopLevelNode topLevelNode = GMFGenFactory.eINSTANCE.createGenTopLevelNode();
        genDiagram.getTopLevelNodes().add((Object)topLevelNode);
        GenChildNode childNode = GMFGenFactory.eINSTANCE.createGenChildNode();
        genDiagram.getChildNodes().add((Object)childNode);
        GenCompartment genCompartment = GMFGenFactory.eINSTANCE.createGenCompartment();
        genDiagram.getCompartments().add((Object)genCompartment);
        EList nodes = genDiagram.getAllChildContainers();
        HandcodedImplTest.assertTrue((boolean)nodes.contains(topLevelNode));
        HandcodedImplTest.assertTrue((boolean)nodes.contains(childNode));
        HandcodedImplTest.assertTrue((boolean)nodes.contains(genCompartment));
        HandcodedImplTest.assertFalse((boolean)nodes.contains(genDiagram));
    }

    public void testGenDiagram_getAllContainers() {
        GenDiagram genDiagram = GMFGenFactory.eINSTANCE.createGenDiagram();
        GenTopLevelNode topLevelNode = GMFGenFactory.eINSTANCE.createGenTopLevelNode();
        genDiagram.getTopLevelNodes().add((Object)topLevelNode);
        GenChildNode childNode = GMFGenFactory.eINSTANCE.createGenChildNode();
        genDiagram.getChildNodes().add((Object)childNode);
        GenCompartment genCompartment = GMFGenFactory.eINSTANCE.createGenCompartment();
        genDiagram.getCompartments().add((Object)genCompartment);
        EList nodes = genDiagram.getAllContainers();
        HandcodedImplTest.assertTrue((boolean)nodes.contains(topLevelNode));
        HandcodedImplTest.assertTrue((boolean)nodes.contains(childNode));
        HandcodedImplTest.assertTrue((boolean)nodes.contains(genCompartment));
        HandcodedImplTest.assertTrue((boolean)nodes.contains(genDiagram));
    }

    public void testGenDiagram_getCreationWizardIconPathX() {
        GenDiagram genDiagram = GMFGenFactory.eINSTANCE.createGenDiagram();
        genDiagram.setCreationWizardIconPath(null);
        HandcodedImplTest.assertNotNull((Object)genDiagram.getCreationWizardIconPathX());
        HandcodedImplTest.assertTrue((genDiagram.getCreationWizardIconPathX().length() > 0 ? 1 : 0) != 0);
        genDiagram.setCreationWizardIconPath("");
        HandcodedImplTest.assertNotNull((Object)genDiagram.getCreationWizardIconPathX());
        HandcodedImplTest.assertTrue((genDiagram.getCreationWizardIconPathX().length() > 0 ? 1 : 0) != 0);
        genDiagram.setCreationWizardIconPath("myPath");
        HandcodedImplTest.assertNotNull((Object)genDiagram.getCreationWizardIconPathX());
        HandcodedImplTest.assertEquals((String)"myPath", (String)genDiagram.getCreationWizardIconPathX());
        genDiagram.setCreationWizardIconPath("{reuseEMFIcon}");
        HandcodedImplTest.assertNotNull((Object)genDiagram.getCreationWizardIconPathX());
        HandcodedImplTest.assertFalse((boolean)"{reuseEMFIcon}".equals(genDiagram.getCreationWizardIconPathX()));
        HandcodedImplTest.assertTrue((genDiagram.getCreationWizardIconPathX().length() > 0 ? 1 : 0) != 0);
    }

    public void testGenEditorView_ID() {
        GenEditorView editorView = GMFGenFactory.eINSTANCE.createGenEditorView();
        editorView.setPackageName("myPackage");
        editorView.setClassName("MyClass");
        this.checkStringPropertyWithDefault((EObject)editorView, GMFGenPackage.eINSTANCE.getGenEditorView_ID());
    }

    private void checkStringPropertyWithDefault(EObject propertyHolder, EAttribute property) {
        propertyHolder.eSet((EStructuralFeature)property, null);
        HandcodedImplTest.assertNotNull((Object)propertyHolder.eGet((EStructuralFeature)property));
        HandcodedImplTest.assertTrue((((String)propertyHolder.eGet((EStructuralFeature)property)).trim().length() > 0 ? 1 : 0) != 0);
        propertyHolder.eSet((EStructuralFeature)property, (Object)"");
        HandcodedImplTest.assertNotNull((Object)propertyHolder.eGet((EStructuralFeature)property));
        HandcodedImplTest.assertTrue((((String)propertyHolder.eGet((EStructuralFeature)property)).trim().length() > 0 ? 1 : 0) != 0);
        propertyHolder.eSet((EStructuralFeature)property, (Object)" ");
        HandcodedImplTest.assertNotNull((Object)propertyHolder.eGet((EStructuralFeature)property));
        HandcodedImplTest.assertTrue((((String)propertyHolder.eGet((EStructuralFeature)property)).trim().length() > 0 ? 1 : 0) != 0);
        String value = "Value_" + String.valueOf(RANDOM_GENERATOR.nextInt());
        propertyHolder.eSet((EStructuralFeature)property, (Object)value);
        HandcodedImplTest.assertNotNull((Object)propertyHolder.eGet((EStructuralFeature)property));
        HandcodedImplTest.assertEquals((Object)value, (Object)propertyHolder.eGet((EStructuralFeature)property));
    }

    public void testGenEditorView_getIconPathX() {
        GenEditorView editorView = GMFGenFactory.eINSTANCE.createGenEditorView();
        GenEditorGenerator genEditorGenerator = GMFGenFactory.eINSTANCE.createGenEditorGenerator();
        genEditorGenerator.setEditor(editorView);
        editorView.setIconPath(null);
        HandcodedImplTest.assertNotNull((Object)editorView.getIconPathX());
        HandcodedImplTest.assertTrue((editorView.getIconPathX().length() > 0 ? 1 : 0) != 0);
        editorView.setIconPath("");
        HandcodedImplTest.assertNotNull((Object)editorView.getIconPathX());
        HandcodedImplTest.assertTrue((editorView.getIconPathX().length() > 0 ? 1 : 0) != 0);
        editorView.setIconPath("myPath");
        HandcodedImplTest.assertNotNull((Object)editorView.getIconPathX());
        HandcodedImplTest.assertEquals((String)"myPath", (String)editorView.getIconPathX());
        editorView.setIconPath("{reuseEMFIcon}");
        HandcodedImplTest.assertNotNull((Object)editorView.getIconPathX());
        HandcodedImplTest.assertFalse((boolean)"{reuseEMFIcon}".equals(editorView.getIconPathX()));
        HandcodedImplTest.assertTrue((editorView.getIconPathX().length() > 0 ? 1 : 0) != 0);
    }

    public void testGenCommonBase_ClassNameSuffux() {
        this.assertClassNameSuffix((GenCommonBase)GMFGenFactory.eINSTANCE.createGenDiagram());
        this.assertClassNameSuffix((GenCommonBase)GMFGenFactory.eINSTANCE.createGenChildNode());
        this.assertClassNameSuffix((GenCommonBase)GMFGenFactory.eINSTANCE.createGenChildLabelNode());
        this.assertClassNameSuffix((GenCommonBase)GMFGenFactory.eINSTANCE.createGenTopLevelNode());
        this.assertClassNameSuffix((GenCommonBase)GMFGenFactory.eINSTANCE.createGenCompartment());
        this.assertClassNameSuffix((GenCommonBase)GMFGenFactory.eINSTANCE.createGenLinkLabel());
        this.assertClassNameSuffix((GenCommonBase)GMFGenFactory.eINSTANCE.createGenNodeLabel());
        this.assertClassNameSuffix((GenCommonBase)GMFGenFactory.eINSTANCE.createGenExternalNodeLabel());
        this.assertClassNameSuffix((GenCommonBase)GMFGenFactory.eINSTANCE.createGenLink());
    }

    private void assertClassNameSuffix(GenCommonBase commonBase) {
        HandcodedImplTest.assertNotNull((Object)commonBase.getClassNameSuffux());
        HandcodedImplTest.assertTrue((commonBase.getClassNameSuffux().length() == 0 ? 1 : 0) != 0);
    }

    public void testGenCommonBase_ClassNamePrefix() {
        GenModel genModel = GenModelFactory.eINSTANCE.createGenModel();
        genModel.safeName("genModel");
        GenPackage genPackage = GenModelFactory.eINSTANCE.createGenPackage();
        EPackage ePackage = EcoreFactory.eINSTANCE.createEPackage();
        ePackage.setName("container");
        genPackage.setEcorePackage(ePackage);
        genModel.getGenPackages().add((Object)genPackage);
        GenClass domainElement = GenModelFactory.eINSTANCE.createGenClass();
        EClass eClass = EcoreFactory.eINSTANCE.createEClass();
        eClass.setName("DomainModelClassName<>?#!. =\"'\n\t\\");
        ePackage.getEClassifiers().add((Object)eClass);
        domainElement.setEcoreClass(eClass);
        genPackage.getGenClasses().add((Object)domainElement);
        TypeModelFacet typeModelFacet = GMFGenFactory.eINSTANCE.createTypeModelFacet();
        typeModelFacet.setMetaClass(domainElement);
        TypeLinkModelFacet typeLinkModelFacet = GMFGenFactory.eINSTANCE.createTypeLinkModelFacet();
        typeLinkModelFacet.setMetaClass(domainElement);
        EReference reference = EcoreFactory.eINSTANCE.createEReference();
        reference.setName("Reference<>?#!. =\"'\n\t\\");
        eClass.getEStructuralFeatures().add((Object)reference);
        GenFeature genFeature = GenModelFactory.eINSTANCE.createGenFeature();
        genFeature.setEcoreFeature((EStructuralFeature)reference);
        domainElement.getGenFeatures().add((Object)genFeature);
        FeatureLinkModelFacet featureLinkModelFacet = GMFGenFactory.eINSTANCE.createFeatureLinkModelFacet();
        featureLinkModelFacet.setMetaFeature(genFeature);
        GenDiagram diagram = GMFGenFactory.eINSTANCE.createGenDiagram();
        this.assertClassNamePrefix((GenCommonBase)diagram);
        diagram.setDomainDiagramElement(domainElement);
        this.assertClassNamePrefix((GenCommonBase)diagram);
        GenChildNode genChildNode = GMFGenFactory.eINSTANCE.createGenChildNode();
        this.assertClassNamePrefix((GenCommonBase)genChildNode);
        genChildNode.setModelFacet(typeModelFacet);
        this.assertClassNamePrefix((GenCommonBase)genChildNode);
        GenChildLabelNode genChildLabelNode = GMFGenFactory.eINSTANCE.createGenChildLabelNode();
        this.assertClassNamePrefix((GenCommonBase)genChildLabelNode);
        genChildLabelNode.setModelFacet(typeModelFacet);
        this.assertClassNamePrefix((GenCommonBase)genChildLabelNode);
        GenTopLevelNode genTopLevelNode = GMFGenFactory.eINSTANCE.createGenTopLevelNode();
        this.assertClassNamePrefix((GenCommonBase)genTopLevelNode);
        genTopLevelNode.setModelFacet(typeModelFacet);
        this.assertClassNamePrefix((GenCommonBase)genTopLevelNode);
        GenCompartment compartment = GMFGenFactory.eINSTANCE.createGenCompartment();
        genTopLevelNode.getCompartments().add((Object)compartment);
        this.assertClassNamePrefix((GenCommonBase)compartment);
        compartment.setTitle("Title:<>?#!. =\"'\n\t\\");
        this.assertClassNamePrefix((GenCommonBase)compartment);
        GenLink genLink = GMFGenFactory.eINSTANCE.createGenLink();
        this.assertClassNamePrefix((GenCommonBase)genLink);
        genLink.setModelFacet((LinkModelFacet)typeLinkModelFacet);
        this.assertClassNamePrefix((GenCommonBase)genLink);
        genLink.setModelFacet((LinkModelFacet)featureLinkModelFacet);
        this.assertClassNamePrefix((GenCommonBase)genLink);
        GenLinkLabel genLinkLabel = GMFGenFactory.eINSTANCE.createGenLinkLabel();
        genLink.getLabels().add((Object)genLinkLabel);
        this.assertClassNamePrefix((GenCommonBase)genLinkLabel);
        genLinkLabel.getMetaFeatures().add((Object)genFeature);
        this.assertClassNamePrefix((GenCommonBase)genLinkLabel);
        GenNodeLabel genNodeLabel = GMFGenFactory.eINSTANCE.createGenNodeLabel();
        genTopLevelNode.getLabels().add((Object)genNodeLabel);
        this.assertClassNamePrefix((GenCommonBase)genNodeLabel);
        genNodeLabel.getMetaFeatures().add((Object)genFeature);
        this.assertClassNamePrefix((GenCommonBase)genNodeLabel);
        GenExternalNodeLabel genExternalNodeLabel = GMFGenFactory.eINSTANCE.createGenExternalNodeLabel();
        genTopLevelNode.getLabels().add((Object)genExternalNodeLabel);
        this.assertClassNamePrefix((GenCommonBase)genExternalNodeLabel);
        genExternalNodeLabel.getMetaFeatures().add((Object)genFeature);
        this.assertClassNamePrefix((GenCommonBase)genExternalNodeLabel);
    }

    private void assertClassNamePrefix(GenCommonBase commonBase) {
        HandcodedImplTest.assertNotNull((Object)commonBase.getClassNamePrefix());
        HandcodedImplTest.assertTrue((commonBase.getClassNamePrefix().length() > 0 ? 1 : 0) != 0);
        IStatus s = JavaConventions.validateJavaTypeName((String)commonBase.getClassNamePrefix(), (String)"1.4", (String)"1.4");
        HandcodedImplTest.assertTrue((String)("Default prefix: " + s.getMessage()), (s.getSeverity() != 4 ? 1 : 0) != 0);
    }

    public void testGenCommonBase_getLayoutType() {
        this.checkLayoutType((GenCommonBase)GMFGenFactory.eINSTANCE.createGenDiagram());
        this.checkLayoutType((GenCommonBase)GMFGenFactory.eINSTANCE.createGenChildNode());
        this.checkLayoutType((GenCommonBase)GMFGenFactory.eINSTANCE.createGenChildLabelNode());
        this.checkLayoutType((GenCommonBase)GMFGenFactory.eINSTANCE.createGenTopLevelNode());
        this.checkLayoutType((GenCommonBase)GMFGenFactory.eINSTANCE.createGenCompartment());
        this.checkLayoutType((GenCommonBase)GMFGenFactory.eINSTANCE.createGenLinkLabel());
        this.checkLayoutType((GenCommonBase)GMFGenFactory.eINSTANCE.createGenNodeLabel());
        this.checkLayoutType((GenCommonBase)GMFGenFactory.eINSTANCE.createGenExternalNodeLabel());
        this.checkLayoutType((GenCommonBase)GMFGenFactory.eINSTANCE.createGenLink());
    }

    private void checkLayoutType(GenCommonBase commonBase) {
        HandcodedImplTest.assertEquals((Object)ViewmapLayoutType.UNKNOWN_LITERAL, (Object)commonBase.getLayoutType());
        FigureViewmap viewmap = GMFGenFactory.eINSTANCE.createFigureViewmap();
        ViewmapLayoutType layoutType = ViewmapLayoutType.get((int)RANDOM_GENERATOR.nextInt(3));
        viewmap.setLayoutType(layoutType);
        commonBase.setViewmap((Viewmap)viewmap);
        HandcodedImplTest.assertEquals((Object)layoutType, (Object)commonBase.getLayoutType());
    }

    public void testGenCommonBase_getDiagram() {
        GenDiagram diagram = GMFGenFactory.eINSTANCE.createGenDiagram();
        HandcodedImplTest.assertEquals((Object)diagram, (Object)diagram.getDiagram());
        HandcodedImplTest.assertEquals((Object)GMFGenPackage.eINSTANCE.getGenChildNode().getEStructuralFeature("diagram"), (Object)GMFGenPackage.eINSTANCE.getGenDiagram_ChildNodes().getEOpposite());
        HandcodedImplTest.assertEquals((Object)GMFGenPackage.eINSTANCE.getGenChildLabelNode().getEStructuralFeature("diagram"), (Object)GMFGenPackage.eINSTANCE.getGenDiagram_ChildNodes().getEOpposite());
        HandcodedImplTest.assertEquals((Object)GMFGenPackage.eINSTANCE.getGenTopLevelNode().getEStructuralFeature("diagram"), (Object)GMFGenPackage.eINSTANCE.getGenDiagram_TopLevelNodes().getEOpposite());
        HandcodedImplTest.assertEquals((Object)GMFGenPackage.eINSTANCE.getGenCompartment().getEStructuralFeature("diagram"), (Object)GMFGenPackage.eINSTANCE.getGenDiagram_Compartments().getEOpposite());
        GenLinkLabel genLinkLabel = GMFGenFactory.eINSTANCE.createGenLinkLabel();
        GenLink genLink = GMFGenFactory.eINSTANCE.createGenLink();
        diagram.getLinks().add((Object)genLink);
        genLink.getLabels().add((Object)genLinkLabel);
        HandcodedImplTest.assertEquals((Object)diagram, (Object)genLinkLabel.getDiagram());
        GenNodeLabel genNodeLabel = GMFGenFactory.eINSTANCE.createGenNodeLabel();
        GenTopLevelNode genNode = GMFGenFactory.eINSTANCE.createGenTopLevelNode();
        diagram.getTopLevelNodes().add((Object)genNode);
        genNode.getLabels().add((Object)genNodeLabel);
        HandcodedImplTest.assertEquals((Object)diagram, (Object)genNodeLabel.getDiagram());
        GenExternalNodeLabel genExternalNodeLabel = GMFGenFactory.eINSTANCE.createGenExternalNodeLabel();
        genNode.getLabels().add((Object)genExternalNodeLabel);
        HandcodedImplTest.assertEquals((Object)diagram, (Object)genExternalNodeLabel.getDiagram());
        HandcodedImplTest.assertEquals((Object)GMFGenPackage.eINSTANCE.getGenLink().getEStructuralFeature("diagram"), (Object)GMFGenPackage.eINSTANCE.getGenDiagram_Links().getEOpposite());
    }

    public void testGenContainerBase_getContainedNodes() {
        GenDiagram diagram = GMFGenFactory.eINSTANCE.createGenDiagram();
        HandcodedImplTest.assertTrue((boolean)diagram.getContainedNodes().isEmpty());
        GenTopLevelNode genTopLevelNode = GMFGenFactory.eINSTANCE.createGenTopLevelNode();
        diagram.getTopLevelNodes().add((Object)genTopLevelNode);
        GenChildNode genChildNode = GMFGenFactory.eINSTANCE.createGenChildNode();
        diagram.getChildNodes().add((Object)genChildNode);
        GenChildLabelNode genChildLabelNode = GMFGenFactory.eINSTANCE.createGenChildLabelNode();
        diagram.getChildNodes().add((Object)genChildLabelNode);
        GenCompartment genCompartment = GMFGenFactory.eINSTANCE.createGenCompartment();
        diagram.getCompartments().add((Object)genCompartment);
        GenChildNode commonChild = GMFGenFactory.eINSTANCE.createGenChildNode();
        diagram.getChildNodes().add((Object)commonChild);
        HandcodedImplTest.assertTrue((diagram.getContainedNodes().size() == 1 ? 1 : 0) != 0);
        HandcodedImplTest.assertEquals((Object)genTopLevelNode, (Object)diagram.getContainedNodes().get(0));
        HandcodedImplTest.assertTrue((genTopLevelNode.getContainedNodes().size() == 0 ? 1 : 0) != 0);
        HandcodedImplTest.assertTrue((genChildNode.getContainedNodes().size() == 0 ? 1 : 0) != 0);
        HandcodedImplTest.assertTrue((genChildLabelNode.getContainedNodes().size() == 0 ? 1 : 0) != 0);
        HandcodedImplTest.assertTrue((genCompartment.getContainedNodes().size() == 0 ? 1 : 0) != 0);
        genTopLevelNode.getChildNodes().add((Object)commonChild);
        HandcodedImplTest.assertTrue((genTopLevelNode.getContainedNodes().size() == 1 ? 1 : 0) != 0);
        HandcodedImplTest.assertEquals((Object)commonChild, (Object)genTopLevelNode.getContainedNodes().get(0));
        genChildNode.getChildNodes().add((Object)commonChild);
        HandcodedImplTest.assertTrue((genChildNode.getContainedNodes().size() == 1 ? 1 : 0) != 0);
        HandcodedImplTest.assertEquals((Object)commonChild, (Object)genChildNode.getContainedNodes().get(0));
        genChildLabelNode.getChildNodes().add((Object)commonChild);
        HandcodedImplTest.assertTrue((genChildLabelNode.getContainedNodes().size() == 1 ? 1 : 0) != 0);
        HandcodedImplTest.assertEquals((Object)commonChild, (Object)genChildLabelNode.getContainedNodes().get(0));
        genCompartment.getChildNodes().add((Object)commonChild);
        HandcodedImplTest.assertTrue((genCompartment.getContainedNodes().size() == 1 ? 1 : 0) != 0);
        HandcodedImplTest.assertEquals((Object)commonChild, (Object)genCompartment.getContainedNodes().get(0));
    }

    public void testGenNode_getDomainMetaClass() {
        TypeModelFacet modelFacet = GMFGenFactory.eINSTANCE.createTypeModelFacet();
        GenClass genClass = GenModelFactory.eINSTANCE.createGenClass();
        modelFacet.setMetaClass(genClass);
        GenTopLevelNode topLevelNode = GMFGenFactory.eINSTANCE.createGenTopLevelNode();
        HandcodedImplTest.assertNull((Object)topLevelNode.getDomainMetaClass());
        topLevelNode.setModelFacet(modelFacet);
        HandcodedImplTest.assertEquals((Object)genClass, (Object)topLevelNode.getDomainMetaClass());
        GenChildNode childNode = GMFGenFactory.eINSTANCE.createGenChildNode();
        HandcodedImplTest.assertNull((Object)childNode.getDomainMetaClass());
        childNode.setModelFacet(modelFacet);
        HandcodedImplTest.assertEquals((Object)genClass, (Object)childNode.getDomainMetaClass());
        GenChildLabelNode childLabelNode = GMFGenFactory.eINSTANCE.createGenChildLabelNode();
        HandcodedImplTest.assertNull((Object)childLabelNode.getDomainMetaClass());
        childLabelNode.setModelFacet(modelFacet);
        HandcodedImplTest.assertEquals((Object)genClass, (Object)childLabelNode.getDomainMetaClass());
    }

    public void testGenChildLabelNode_getLabelMetaFeatures() {
        GenChildLabelNode childLabelNode = GMFGenFactory.eINSTANCE.createGenChildLabelNode();
        HandcodedImplTest.assertTrue((childLabelNode.getLabelMetaFeatures().size() == 0 ? 1 : 0) != 0);
        GenFeature genFeature = GenModelFactory.eINSTANCE.createGenFeature();
        FeatureLabelModelFacet compositeModelFacet = GMFGenFactory.eINSTANCE.createFeatureLabelModelFacet();
        childLabelNode.setLabelModelFacet((LabelModelFacet)compositeModelFacet);
        HandcodedImplTest.assertTrue((childLabelNode.getLabelMetaFeatures().size() == 0 ? 1 : 0) != 0);
        compositeModelFacet.getMetaFeatures().add((Object)genFeature);
        HandcodedImplTest.assertTrue((childLabelNode.getLabelMetaFeatures().size() == 1 ? 1 : 0) != 0);
        HandcodedImplTest.assertEquals((Object)genFeature, (Object)childLabelNode.getLabelMetaFeatures().get(0));
        GenFeature nextGenFeature = GenModelFactory.eINSTANCE.createGenFeature();
        compositeModelFacet.getMetaFeatures().add((Object)nextGenFeature);
        HandcodedImplTest.assertTrue((childLabelNode.getLabelMetaFeatures().size() == 2 ? 1 : 0) != 0);
        HandcodedImplTest.assertTrue((boolean)childLabelNode.getLabelMetaFeatures().contains((Object)genFeature));
        HandcodedImplTest.assertTrue((boolean)childLabelNode.getLabelMetaFeatures().contains((Object)nextGenFeature));
    }

    public void testGenLink_getSources_getTargets() {
        GenDiagram genDiagram = GMFGenFactory.eINSTANCE.createGenDiagram();
        GenLink genLink = GMFGenFactory.eINSTANCE.createGenLink();
        genDiagram.getLinks().add((Object)genLink);
        GenTopLevelNode topLevelNode = GMFGenFactory.eINSTANCE.createGenTopLevelNode();
        genDiagram.getTopLevelNodes().add((Object)topLevelNode);
        TypeModelFacet typeModelFacet = GMFGenFactory.eINSTANCE.createTypeModelFacet();
        topLevelNode.setModelFacet(typeModelFacet);
        GenClass genClass1 = GenModelFactory.eINSTANCE.createGenClass();
        genClass1.setEcoreClass(EcoreFactory.eINSTANCE.createEClass());
        typeModelFacet.setMetaClass(genClass1);
        GenChildNode childNode = GMFGenFactory.eINSTANCE.createGenChildNode();
        genDiagram.getChildNodes().add((Object)childNode);
        typeModelFacet = GMFGenFactory.eINSTANCE.createTypeModelFacet();
        childNode.setModelFacet(typeModelFacet);
        GenClass genClass2 = GenModelFactory.eINSTANCE.createGenClass();
        genClass2.setEcoreClass(EcoreFactory.eINSTANCE.createEClass());
        typeModelFacet.setMetaClass(genClass2);
        HandcodedImplTest.assertTrue((genLink.getAssistantSources().size() == 0 ? 1 : 0) != 0);
        HandcodedImplTest.assertTrue((genLink.getAssistantTargets().size() == 0 ? 1 : 0) != 0);
        genLink.setModelFacet((LinkModelFacet)new CustomLinkModelFacet(new GenClass[]{genClass1, genClass2, GenModelFactory.eINSTANCE.createGenClass()}));
        HandcodedImplTest.assertTrue((genLink.getAssistantSources().size() == 2 ? 1 : 0) != 0);
        HandcodedImplTest.assertTrue((boolean)genLink.getAssistantSources().contains((Object)topLevelNode));
        HandcodedImplTest.assertTrue((boolean)genLink.getAssistantSources().contains((Object)childNode));
        HandcodedImplTest.assertTrue((genLink.getAssistantTargets().size() == 2 ? 1 : 0) != 0);
        HandcodedImplTest.assertTrue((boolean)genLink.getAssistantTargets().contains((Object)topLevelNode));
        HandcodedImplTest.assertTrue((boolean)genLink.getAssistantTargets().contains((Object)childNode));
    }

    public void testGenLabel_getMetaFeatures() {
        this.checkMetaFeatures((GenLabel)GMFGenFactory.eINSTANCE.createGenLinkLabel());
        this.checkMetaFeatures((GenLabel)GMFGenFactory.eINSTANCE.createGenNodeLabel());
        this.checkMetaFeatures((GenLabel)GMFGenFactory.eINSTANCE.createGenExternalNodeLabel());
    }

    private void checkMetaFeatures(GenLabel genLabel) {
        HandcodedImplTest.assertTrue((genLabel.getMetaFeatures().size() == 0 ? 1 : 0) != 0);
        GenFeature genFeature = GenModelFactory.eINSTANCE.createGenFeature();
        FeatureLabelModelFacet compositeModelFacet = GMFGenFactory.eINSTANCE.createFeatureLabelModelFacet();
        genLabel.setModelFacet((LabelModelFacet)compositeModelFacet);
        HandcodedImplTest.assertTrue((genLabel.getMetaFeatures().size() == 0 ? 1 : 0) != 0);
        compositeModelFacet.getMetaFeatures().add((Object)genFeature);
        HandcodedImplTest.assertTrue((genLabel.getMetaFeatures().size() == 1 ? 1 : 0) != 0);
        HandcodedImplTest.assertEquals((Object)genFeature, (Object)genLabel.getMetaFeatures().get(0));
        GenFeature nextGenFeature = GenModelFactory.eINSTANCE.createGenFeature();
        compositeModelFacet.getMetaFeatures().add((Object)nextGenFeature);
        HandcodedImplTest.assertTrue((genLabel.getMetaFeatures().size() == 2 ? 1 : 0) != 0);
        HandcodedImplTest.assertTrue((boolean)genLabel.getMetaFeatures().contains((Object)genFeature));
        HandcodedImplTest.assertTrue((boolean)genLabel.getMetaFeatures().contains((Object)nextGenFeature));
    }

    public void testMetamodelType_getMetaClass() {
        MetamodelType metamodelType = GMFGenFactory.eINSTANCE.createMetamodelType();
        HandcodedImplTest.assertNull((Object)metamodelType.getMetaClass());
        GenTopLevelNode genNode = GMFGenFactory.eINSTANCE.createGenTopLevelNode();
        TypeModelFacet typeModelFacet = GMFGenFactory.eINSTANCE.createTypeModelFacet();
        genNode.setModelFacet(typeModelFacet);
        GenClass genClass = GenModelFactory.eINSTANCE.createGenClass();
        typeModelFacet.setMetaClass(genClass);
        metamodelType.setDiagramElement((GenCommonBase)genNode);
        HandcodedImplTest.assertEquals((Object)genClass, (Object)metamodelType.getMetaClass());
        GenLink genLink = GMFGenFactory.eINSTANCE.createGenLink();
        TypeLinkModelFacet typeLinkModelFacet = GMFGenFactory.eINSTANCE.createTypeLinkModelFacet();
        genLink.setModelFacet((LinkModelFacet)typeLinkModelFacet);
        typeLinkModelFacet.setMetaClass(genClass);
        metamodelType.setDiagramElement((GenCommonBase)genLink);
        HandcodedImplTest.assertEquals((Object)genClass, (Object)metamodelType.getMetaClass());
        GenDiagram genDiagram = GMFGenFactory.eINSTANCE.createGenDiagram();
        genDiagram.setDomainDiagramElement(genClass);
        metamodelType.setDiagramElement((GenCommonBase)genDiagram);
        HandcodedImplTest.assertEquals((Object)genClass, (Object)metamodelType.getMetaClass());
    }

    public void testLinkModelFacet_getSourceType_getTargetType() {
        GenModel genModel = GenModelFactory.eINSTANCE.createGenModel();
        GenPackage genPackage = GenModelFactory.eINSTANCE.createGenPackage();
        EPackage ePackage = EcoreFactory.eINSTANCE.createEPackage();
        genPackage.setEcorePackage(ePackage);
        genModel.getGenPackages().add((Object)genPackage);
        TypeLinkModelFacet typeLinkModelFacet = GMFGenFactory.eINSTANCE.createTypeLinkModelFacet();
        HandcodedImplTest.assertTrue((typeLinkModelFacet.getSourceType() == null ? 1 : 0) != 0);
        GenClass genClass1 = GenModelFactory.eINSTANCE.createGenClass();
        EClass eClass1 = EcoreFactory.eINSTANCE.createEClass();
        genClass1.setEcoreClass(eClass1);
        genPackage.getGenClasses().add((Object)genClass1);
        GenFeature genFeature1 = GenModelFactory.eINSTANCE.createGenFeature();
        genClass1.getGenFeatures().add((Object)genFeature1);
        typeLinkModelFacet.setContainmentMetaFeature(genFeature1);
        HandcodedImplTest.assertEquals((Object)genClass1, (Object)typeLinkModelFacet.getSourceType());
        GenFeature genFeature2 = GenModelFactory.eINSTANCE.createGenFeature();
        genClass1.getGenFeatures().add((Object)genFeature2);
        GenClass genClass2 = GenModelFactory.eINSTANCE.createGenClass();
        EClass eClass2 = EcoreFactory.eINSTANCE.createEClass();
        eClass2.setName("ClassName");
        genClass2.setEcoreClass(eClass2);
        genPackage.getGenClasses().add((Object)genClass2);
        ePackage.getEClassifiers().add((Object)eClass2);
        EReference eReference = EcoreFactory.eINSTANCE.createEReference();
        eReference.setEType((EClassifier)eClass2);
        genFeature2.setEcoreFeature((EStructuralFeature)eReference);
        typeLinkModelFacet.setSourceMetaFeature(genFeature2);
        HandcodedImplTest.assertEquals((Object)genClass2, (Object)typeLinkModelFacet.getSourceType());
        HandcodedImplTest.assertTrue((typeLinkModelFacet.getTargetType() == null ? 1 : 0) != 0);
        typeLinkModelFacet.setTargetMetaFeature(genFeature2);
        HandcodedImplTest.assertEquals((Object)genClass2, (Object)typeLinkModelFacet.getTargetType());
        FeatureLinkModelFacet featureLinkModelFacet = GMFGenFactory.eINSTANCE.createFeatureLinkModelFacet();
        HandcodedImplTest.assertTrue((featureLinkModelFacet.getSourceType() == null ? 1 : 0) != 0);
        HandcodedImplTest.assertTrue((featureLinkModelFacet.getTargetType() == null ? 1 : 0) != 0);
        featureLinkModelFacet.setMetaFeature(genFeature2);
        HandcodedImplTest.assertEquals((Object)genClass1, (Object)featureLinkModelFacet.getSourceType());
        HandcodedImplTest.assertEquals((Object)genClass2, (Object)featureLinkModelFacet.getTargetType());
    }

    public void testTypeModelFacet_isPhantomElement() {
        GenTopLevelNode topLevelNode = GMFGenFactory.eINSTANCE.createGenTopLevelNode();
        GenChildNode childNode = GMFGenFactory.eINSTANCE.createGenChildNode();
        TypeModelFacet typeModelFacet = GMFGenFactory.eINSTANCE.createTypeModelFacet();
        childNode.setModelFacet(typeModelFacet);
        HandcodedImplTest.assertFalse((boolean)typeModelFacet.isPhantomElement());
        topLevelNode.setModelFacet(typeModelFacet);
        HandcodedImplTest.assertTrue((boolean)typeModelFacet.isPhantomElement());
        typeModelFacet.setContainmentMetaFeature(GenModelFactory.eINSTANCE.createGenFeature());
        HandcodedImplTest.assertFalse((boolean)typeModelFacet.isPhantomElement());
        GenLink genLink = GMFGenFactory.eINSTANCE.createGenLink();
        TypeLinkModelFacet typeLinkModelFacet = GMFGenFactory.eINSTANCE.createTypeLinkModelFacet();
        genLink.setModelFacet((LinkModelFacet)typeLinkModelFacet);
        HandcodedImplTest.assertFalse((boolean)typeLinkModelFacet.isPhantomElement());
        typeLinkModelFacet.setContainmentMetaFeature(GenModelFactory.eINSTANCE.createGenFeature());
        HandcodedImplTest.assertFalse((boolean)typeModelFacet.isPhantomElement());
    }

    public void testPackageNames() {
        GenApplication application;
        GenDiagram genDiagram = this.myGenModel;
        HashSet<String> state = new HashSet<String>();
        this.checkPackageName(state, "PackageNames:editCommands", genDiagram.getEditCommandsPackageName());
        this.checkPackageName(state, "PackageNames:editHelpers", genDiagram.getEditHelpersPackageName());
        this.checkPackageName(state, "PackageNames:editParts", genDiagram.getEditPartsPackageName());
        this.checkPackageName(state, "PackageNames:editPolicies", genDiagram.getEditPoliciesPackageName());
        this.checkPackageName(state, "GenEditorView:packageName", genDiagram.getEditorGen().getEditor().getPackageName());
        this.checkPackageName(state, "PackageNames:providers", genDiagram.getProvidersPackageName());
        this.checkPackageName(state, "PackageNames:parsers", genDiagram.getParsersPackageName());
        this.checkPackageName(state, "PackageNames:preferences", genDiagram.getPreferencesPackageName());
        this.checkPackageName(state, "PackageNames:notationViewFactories", genDiagram.getNotationViewFactoriesPackageName());
        if (genDiagram.getEditorGen().getLabelParsers() != null) {
            this.checkPackageName(state, "GenParsers:impl", genDiagram.getEditorGen().getLabelParsers().getImplPackageName());
        }
        if ((application = genDiagram.getEditorGen().getApplication()) != null) {
            this.checkPackageName(state, "GenApplication:application", application.getPackageName());
        } else {
            state.add("GenApplication:application");
        }
        if (genDiagram.getEditorGen().getExpressionProviders() != null) {
            GenExpressionProviderContainer providers = genDiagram.getEditorGen().getExpressionProviders();
            this.checkPackageName(state, "GenExpressionProviderContainer:expressions", providers.getExpressionsPackageName());
        } else {
            state.add("GenExpressionProviderContainer:expressions");
        }
        for (Object next : GMFGenPackage.eINSTANCE.getEClassifiers()) {
            if (!(next instanceof EClass)) continue;
            this.checkPackageNamesCoverage(state, (EClass)next);
        }
    }

    public void testGenParsers_delegatesToOld() {
        GenParsers gp = GMFGenFactory.eINSTANCE.createGenParsers();
        this.myGenModel.getEditorGen().setLabelParsers(gp);
        HandcodedImplTest.assertNotNull((Object)gp.getClassName());
        HandcodedImplTest.assertNotNull((Object)gp.getPackageName());
        HandcodedImplTest.assertNotNull((Object)gp.getQualifiedClassName());
        HandcodedImplTest.assertEquals((String)this.myGenModel.getParserProviderQualifiedClassName(), (String)gp.getQualifiedClassName());
        this.myGenModel.setParserProviderPriority(ProviderPriority.HIGH_LITERAL);
        HandcodedImplTest.assertEquals((Object)this.myGenModel.getParserProviderPriority(), (Object)gp.getProviderPriority());
        gp.setProviderPriority(ProviderPriority.MEDIUM_LITERAL);
        HandcodedImplTest.assertNotSame((Object)this.myGenModel.getParserProviderPriority(), (Object)gp.getProviderPriority());
        HandcodedImplTest.assertEquals((Object)ProviderPriority.MEDIUM_LITERAL, (Object)gp.getProviderPriority());
    }

    public void testGenParsers_qualifiedName() {
        GenParsers gp = GMFGenFactory.eINSTANCE.createGenParsers();
        gp.setClassName("GenParsersClassName");
        gp.setPackageName("org.sample.test");
        HandcodedImplTest.assertEquals((String)"org.sample.test.GenParsersClassName", (String)gp.getQualifiedClassName());
    }

    public void testGenCustomPreferencePage() {
        GenCustomPreferencePage cp = GMFGenFactory.eINSTANCE.createGenCustomPreferencePage();
        HandcodedImplTest.assertNull((String)"ClassName shouldn't fail if qualifiedClassName is not set", (Object)cp.getClassName());
        cp.setQualifiedClassName("org.sample.CustomPrefPage");
        HandcodedImplTest.assertEquals((String)"org.sample.CustomPrefPage", (String)cp.getQualifiedClassName());
        HandcodedImplTest.assertEquals((String)"CustomPrefPage", (String)cp.getClassName());
    }

    public void testGenStandardPreferencePage() {
        GenStandardPreferencePage sp = GMFGenFactory.eINSTANCE.createGenStandardPreferencePage();
        HandcodedImplTest.assertNotNull((Object)sp.getClassName());
        HashSet<String> cn = new HashSet<String>();
        sp.setKind(StandardPreferencePages.APPEARANCE_LITERAL);
        HandcodedImplTest.assertNotNull((Object)sp.getClassName());
        HandcodedImplTest.assertTrue((boolean)cn.add(sp.getClassName()));
        sp.setKind(StandardPreferencePages.GENERAL_LITERAL);
        HandcodedImplTest.assertNotNull((Object)sp.getClassName());
        HandcodedImplTest.assertTrue((boolean)cn.add(sp.getClassName()));
        sp.setKind(StandardPreferencePages.PRINTING_LITERAL);
        HandcodedImplTest.assertNotNull((Object)sp.getClassName());
        HandcodedImplTest.assertTrue((boolean)cn.add(sp.getClassName()));
        sp.setKind(StandardPreferencePages.PATHMAPS_LITERAL);
        HandcodedImplTest.assertNotNull((Object)sp.getClassName());
        HandcodedImplTest.assertTrue((boolean)cn.add(sp.getClassName()));
        sp.setKind(StandardPreferencePages.RULERS_AND_GRID_LITERAL);
        HandcodedImplTest.assertNotNull((Object)sp.getClassName());
        HandcodedImplTest.assertTrue((boolean)cn.add(sp.getClassName()));
        sp.setKind(StandardPreferencePages.CONNECTIONS_LITERAL);
        HandcodedImplTest.assertNotNull((Object)sp.getClassName());
        HandcodedImplTest.assertTrue((boolean)cn.add(sp.getClassName()));
        HandcodedImplTest.assertEquals((int)StandardPreferencePages.values().length, (int)cn.size());
        sp.setClassName("TestAnotherClassName");
        sp.setKind(StandardPreferencePages.GENERAL_LITERAL);
        HandcodedImplTest.assertEquals((String)"TestAnotherClassName", (String)sp.getClassName());
        HandcodedImplTest.assertEquals((String)sp.getClassName(), (String)sp.getQualifiedClassName());
        this.myGenModel.getPreferencePages().add((Object)sp);
        HandcodedImplTest.assertNotNull((String)"sanity", (Object)this.myGenModel.getPreferencesPackageName());
        HandcodedImplTest.assertEquals((String)(String.valueOf(this.myGenModel.getPreferencesPackageName()) + '.' + sp.getClassName()), (String)sp.getQualifiedClassName());
    }

    public void testClassNames() {
        GenDiagram genDiagram = this.myGenModel;
        HashSet<String> state = new HashSet<String>();
        GenEditorView genEditor = this.myGenModel.getEditorGen().getEditor();
        this.checkClassName(state, "EditPartCandies:ReorientConnectionViewCommand", genDiagram.getReorientConnectionViewCommandClassName(), genDiagram.getReorientConnectionViewCommandQualifiedClassName());
        this.checkClassName(state, "EditPartCandies:BaseEditHelper", genDiagram.getBaseEditHelperClassName(), genDiagram.getBaseEditHelperQualifiedClassName());
        this.checkClassName(state, "EditPartCandies:EditPartFactory", genDiagram.getEditPartFactoryClassName(), genDiagram.getEditPartFactoryQualifiedClassName());
        this.checkClassName(state, "EditPartCandies:BaseExternalNodeLabelEditPart", genDiagram.getBaseExternalNodeLabelEditPartClassName(), genDiagram.getBaseExternalNodeLabelEditPartQualifiedClassName());
        this.checkClassName(state, "EditPartCandies:BaseItemSemanticEditPolicy", genDiagram.getBaseItemSemanticEditPolicyClassName(), genDiagram.getBaseItemSemanticEditPolicyQualifiedClassName());
        this.checkClassName(state, "EditPartCandies:BaseGraphicalNodeEditPolicy", genDiagram.getBaseGraphicalNodeEditPolicyClassName(), genDiagram.getBaseGraphicalNodeEditPolicyQualifiedClassName());
        this.checkClassName(state, "GenContainerBase:CanonicalEditPolicy", genDiagram.getCanonicalEditPolicyClassName(), genDiagram.getCanonicalEditPolicyQualifiedClassName());
        this.checkClassName(state, "EditPartCandies:TextSelectionEditPolicy", genDiagram.getTextSelectionEditPolicyClassName(), genDiagram.getTextSelectionEditPolicyQualifiedClassName());
        this.checkClassName(state, "EditPartCandies:TextNonResizableEditPolicy", genDiagram.getTextNonResizableEditPolicyClassName(), genDiagram.getTextNonResizableEditPolicyQualifiedClassName());
        this.checkClassName(state, "ProviderClassNames:ElementTypes", genDiagram.getElementTypesClassName(), genDiagram.getElementTypesQualifiedClassName());
        this.checkClassName(state, "ProviderClassNames:NotationViewProvider", genDiagram.getNotationViewProviderClassName(), genDiagram.getNotationViewProviderQualifiedClassName());
        this.checkClassName(state, "ProviderClassNames:EditPartProvider", genDiagram.getEditPartProviderClassName(), genDiagram.getEditPartProviderQualifiedClassName());
        this.checkClassName(state, "ProviderClassNames:ModelingAssistantProvider", genDiagram.getModelingAssistantProviderClassName(), genDiagram.getModelingAssistantProviderQualifiedClassName());
        this.checkClassName(state, "ProviderClassNames:IconProvider", genDiagram.getIconProviderClassName(), genDiagram.getIconProviderQualifiedClassName());
        this.checkClassName(state, "ProviderClassNames:ParserProvider", genDiagram.getParserProviderClassName(), genDiagram.getParserProviderQualifiedClassName());
        this.checkClassName(state, "ProviderClassNames:ContributionItemProvider", genDiagram.getContributionItemProviderClassName(), genDiagram.getContributionItemProviderQualifiedClassName());
        this.checkClassName(state, "GenEditorView:ActionBarContributor", genEditor.getActionBarContributorClassName(), genEditor.getActionBarContributorQualifiedClassName());
        this.checkClassName(state, "EditorCandies:CreationWizard", genDiagram.getCreationWizardClassName(), genDiagram.getCreationWizardQualifiedClassName());
        this.checkClassName(state, "EditorCandies:CreationWizardPage", genDiagram.getCreationWizardPageClassName(), genDiagram.getCreationWizardPageQualifiedClassName());
        this.checkClassName(state, "EditorCandies:DiagramEditorUtil", genDiagram.getDiagramEditorUtilClassName(), genDiagram.getDiagramEditorUtilQualifiedClassName());
        this.checkClassName(state, "EditorCandies:DocumentProvider", genDiagram.getDocumentProviderClassName(), genDiagram.getDocumentProviderQualifiedClassName());
        this.checkClassName(state, "GenEditorView:className", genEditor.getClassName(), genEditor.getQualifiedClassName());
        this.checkClassName(state, "EditorCandies:InitDiagramFileAction", genDiagram.getInitDiagramFileActionClassName(), genDiagram.getInitDiagramFileActionQualifiedClassName());
        this.checkClassName(state, "EditorCandies:NewDiagramFileWizard", genDiagram.getNewDiagramFileWizardClassName(), genDiagram.getNewDiagramFileWizardQualifiedClassName());
        this.checkClassName(state, "EditorCandies:DiagramContentInitializer", genDiagram.getDiagramContentInitializerClassName(), genDiagram.getDiagramContentInitializerQualifiedClassName());
        this.checkClassName(state, "EditorCandies:MatchingStrategy", genDiagram.getMatchingStrategyClassName(), genDiagram.getMatchingStrategyQualifiedClassName());
        this.checkClassName(state, "EditorCandies:VisualIDRegistry", genDiagram.getVisualIDRegistryClassName(), genDiagram.getVisualIDRegistryQualifiedClassName());
        this.checkClassName(state, "EditorCandies:LoadResourceAction", genDiagram.getLoadResourceActionClassName(), genDiagram.getLoadResourceActionQualifiedClassName());
        this.checkClassName(state, "LinkConstraints:LinkCreationConstraints", genDiagram.getLinkCreationConstraintsClassName(), genDiagram.getLinkCreationConstraintsQualifiedClassName());
        this.checkClassName(state, "Shortcuts:CreateShortcutAction", genDiagram.getCreateShortcutActionClassName(), genDiagram.getCreateShortcutActionQualifiedClassName());
        this.checkClassName(state, "Shortcuts:ShortcutsDecoratorProvider", genDiagram.getShortcutsDecoratorProviderClassName(), genDiagram.getShortcutsDecoratorProviderQualifiedClassName());
        this.checkClassName(state, "Shortcuts:CreateShortcutDecorationsCommand", genDiagram.getCreateShortcutDecorationsCommandClassName(), genDiagram.getCreateShortcutDecorationsCommandQualifiedClassName());
        this.checkClassName(state, "Shortcuts:ShortcutPropertyTester", genDiagram.getShortcutPropertyTesterClassName(), genDiagram.getShortcutPropertyTesterQualifiedClassName());
        this.checkClassName(state, "EditorCandies:ElementChooser", genDiagram.getElementChooserClassName(), genDiagram.getElementChooserQualifiedClassName());
        this.checkClassName(state, "BatchValidation:ValidationProvider", genDiagram.getValidationProviderClassName(), genDiagram.getValidationProviderQualifiedClassName());
        this.checkClassName(state, "BatchValidation:ValidationDecoratorProvider", genDiagram.getValidationDecoratorProviderClassName(), genDiagram.getValidationDecoratorProviderQualifiedClassName());
        this.checkClassName(state, "BatchValidation:MarkerNavigationProvider", genDiagram.getMarkerNavigationProviderClassName(), genDiagram.getMarkerNavigationProviderQualifiedClassName());
        this.checkClassName(state, "BatchValidation:MetricProvider", genDiagram.getMetricProviderClassName(), genDiagram.getMetricProviderQualifiedClassName());
        GenApplication application = genDiagram.getEditorGen().getApplication();
        if (application != null) {
            this.checkClassName(state, "GenApplication:Application", application.getClassName(), application.getQualifiedClassName());
            this.checkClassName(state, "GenApplication:WorkbenchAdvisor", application.getWorkbenchAdvisorClassName(), application.getWorkbenchAdvisorQualifiedClassName());
            this.checkClassName(state, "GenApplication:WorkbenchWindowAdvisor", application.getWorkbenchWindowAdvisorClassName(), application.getWorkbenchWindowAdvisorQualifiedClassName());
            this.checkClassName(state, "GenApplication:ActionBarAdvisor", application.getActionBarAdvisorClassName(), application.getActionBarAdvisorQualifiedClassName());
            this.checkClassName(state, "GenApplication:Perspective", application.getPerspectiveClassName(), application.getPerspectiveQualifiedClassName());
        } else {
            state.add("GenApplication:Application");
            state.add("GenApplication:WorkbenchAdvisor");
            state.add("GenApplication:WorkbenchWindowAdvisor");
            state.add("GenApplication:ActionBarAdvisor");
            state.add("GenApplication:Perspective");
        }
        if (genDiagram.getEditorGen().getExpressionProviders() != null) {
            GenExpressionProviderContainer providers = genDiagram.getEditorGen().getExpressionProviders();
            this.checkClassName(state, "GenExpressionProviderContainer:AbstractExpression", providers.getAbstractExpressionClassName(), providers.getAbstractExpressionQualifiedClassName());
        } else {
            state.add("GenExpressionProviderContainer:AbstractExpression");
        }
        Palette palette = genDiagram.getPalette();
        if (palette != null) {
            this.checkClassName(state, "Palette:Factory", palette.getFactoryClassName(), palette.getFactoryQualifiedClassName());
        } else {
            state.add("Palette:Factory");
        }
        GenNavigator navigator = genDiagram.getEditorGen().getNavigator();
        if (navigator != null) {
            this.checkClassName(state, "GenNavigator:ContentProvider", navigator.getContentProviderClassName(), navigator.getContentProviderQualifiedClassName());
            this.checkClassName(state, "GenNavigator:LabelProvider", navigator.getLabelProviderClassName(), navigator.getLabelProviderQualifiedClassName());
            this.checkClassName(state, "GenNavigator:Sorter", navigator.getSorterClassName(), navigator.getSorterQualifiedClassName());
            this.checkClassName(state, "GenNavigator:ActionProvider", navigator.getActionProviderClassName(), navigator.getActionProviderQualifiedClassName());
            this.checkClassName(state, "GenNavigator:LinkHelper", navigator.getLinkHelperClassName(), navigator.getLinkHelperQualifiedClassName());
            this.checkClassName(state, "GenNavigator:AbstractNavigatorItem", navigator.getAbstractNavigatorItemClassName(), navigator.getAbstractNavigatorItemQualifiedClassName());
            this.checkClassName(state, "GenNavigator:NavigatorGroup", navigator.getNavigatorGroupClassName(), navigator.getNavigatorGroupQualifiedClassName());
            this.checkClassName(state, "GenNavigator:NavigatorItem", navigator.getNavigatorItemClassName(), navigator.getNavigatorItemQualifiedClassName());
            this.checkClassName(state, "GenNavigator:UriInputTester", navigator.getUriInputTesterClassName(), navigator.getUriInputTesterQualifiedClassName());
            this.checkClassName(state, "GenDomainModelNavigator:DomainContentProvider", navigator.getDomainContentProviderClassName(), navigator.getDomainContentProviderQualifiedClassName());
            this.checkClassName(state, "GenDomainModelNavigator:DomainLabelProvider", navigator.getDomainLabelProviderClassName(), navigator.getDomainLabelProviderQualifiedClassName());
            this.checkClassName(state, "GenDomainModelNavigator:DomainModelElementTester", navigator.getDomainModelElementTesterClassName(), navigator.getDomainModelElementTesterQualifiedClassName());
            this.checkClassName(state, "GenDomainModelNavigator:DomainNavigatorItem", navigator.getDomainNavigatorItemClassName(), navigator.getDomainNavigatorItemQualifiedClassName());
        } else {
            state.add("GenNavigator:ContentProvider");
            state.add("GenNavigator:LabelProvider");
            state.add("GenNavigator:GroupWrapper");
        }
        GenDiagramUpdater updater = genDiagram.getEditorGen().getDiagramUpdater();
        if (updater != null) {
            this.checkClassName(state, "GenDiagramUpdater:DiagramUpdater", updater.getDiagramUpdaterClassName(), updater.getDiagramUpdaterQualifiedClassName());
            this.checkClassName(state, "GenDiagramUpdater:NodeDescriptor", updater.getNodeDescriptorClassName(), updater.getNodeDescriptorQualifiedClassName());
            this.checkClassName(state, "GenDiagramUpdater:LinkDescriptor", updater.getLinkDescriptorClassName(), updater.getLinkDescriptorQualifiedClassName());
            this.checkClassName(state, "GenDiagramUpdater:UpdateCommand", updater.getUpdateCommandClassName(), updater.getUpdateCommandQualifiedClassName());
        } else {
            state.add("GenDiagramUpdater:DiagramUpdater");
            state.add("GenDiagramUpdater:NodeDescriptor");
            state.add("GenDiagramUpdater:LinkDescriptor");
            state.add("GenDiagramUpdater:UpdateCommand");
        }
        GenPropertySheet propSheet = genDiagram.getEditorGen().getPropertySheet();
        if (propSheet != null) {
            this.checkPackageName(state, "GenPropertySheet:packageName", propSheet.getPackageName());
            this.checkClassName(state, "GenPropertySheet:LabelProvider", propSheet.getLabelProviderClassName(), propSheet.getLabelProviderQualifiedClassName());
        } else {
            state.add("GenPropertySheet:LabelProvider");
        }
        GenPlugin genPlugin = genDiagram.getEditorGen().getPlugin();
        this.checkClassName(state, "GenPlugin:Activator", genPlugin.getActivatorClassName(), genPlugin.getActivatorQualifiedClassName());
        GenCommonBaseIterator entities = new GenCommonBaseIterator(genDiagram);
        while (entities.hasNext()) {
            GenCommonBase nextEntity = entities.next();
            this.checkClassName(state, "GenCommonBase:EditPart", nextEntity.getEditPartClassName(), nextEntity.getEditPartQualifiedClassName());
            this.checkClassName(state, "GenCommonBase:ItemSemanticEditPolicy", nextEntity.getItemSemanticEditPolicyClassName(), nextEntity.getItemSemanticEditPolicyQualifiedClassName());
            this.checkEditSupport(state, nextEntity);
            if (nextEntity instanceof GenChildContainer) {
                GenChildContainer genContainer = (GenChildContainer)nextEntity;
                this.checkClassName(state, "GenContainerBase:CanonicalEditPolicy", genContainer.getCanonicalEditPolicyClassName(), genContainer.getCanonicalEditPolicyQualifiedClassName());
            }
            if (nextEntity instanceof GenNode) {
                GenNode genNode = (GenNode)nextEntity;
                this.checkClassName(state, "GenNode:GraphicalNodeEditPolicy", genNode.getGraphicalNodeEditPolicyClassName(), genNode.getGraphicalNodeEditPolicyQualifiedClassName());
                this.checkClassName(state, "GenNode:CreateCommand", genNode.getCreateCommandClassName(), genNode.getCreateCommandQualifiedClassName());
            }
            if (nextEntity instanceof GenLink) {
                GenLink genLink = (GenLink)nextEntity;
                this.checkClassName(state, "GenLink:CreateCommand", genLink.getCreateCommandClassName(), genLink.getCreateCommandQualifiedClassName());
                this.checkClassName(state, "GenLink:ReorientCommand", genLink.getReorientCommandClassName(), genLink.getReorientCommandQualifiedClassName());
            }
            for (Behaviour nextB : nextEntity.getBehaviour()) {
                String epClassName = CodeGenUtil.getSimpleClassName((String)nextB.getEditPolicyQualifiedClassName());
                this.checkClassName(state, "Behaviour:EditPolicy", epClassName, nextB.getEditPolicyQualifiedClassName());
            }
        }
        GenAuditRoot audits = genDiagram.getEditorGen().getAudits();
        HandcodedImplTest.assertTrue((String)"Need AuditRoot instance with rules to check handcoded methods", (audits != null && audits.getRules().size() > 0 ? 1 : 0) != 0);
        HashSet<String> checkedContexts = new HashSet<String>();
        for (GenAuditContext nextCtx : audits.getClientContexts()) {
            if (checkedContexts.contains(nextCtx.getQualifiedClassName())) continue;
            this.checkClassName(state, "GenAuditContext:className", nextCtx.getClassName(), nextCtx.getQualifiedClassName());
            checkedContexts.add(nextCtx.getQualifiedClassName());
        }
        for (GenAuditRule nextAudit : audits.getRules()) {
            this.checkClassName(state, "GenAuditRule:ConstraintAdapter", nextAudit.getConstraintAdapterClassName(), nextAudit.getConstraintAdapterQualifiedClassName());
        }
        state.add("GenCommonBase:EditPart");
        state.add("GenCommonBase:ItemSemanticEditPolicy");
        state.add("GenCommonBase:NotationViewFactory");
        state.add("GenContainer:CanonicalEditPolicy");
        state.add("GenNode:GraphicalNodeEditPolicy");
        state.add("GenNode:CreateCommand");
        state.add("TypeLinkModelFacet:CreateCommand");
        state.add("MetamodelType:EditHelper");
        state.add("SpecializationType:EditHelperAdvice");
        state.add("Behaviour:EditPolicy");
        state.add("OpenDiagramBehaviour:EditPolicy");
        state.add("ElementType:EditHelper");
        state.add("ElementType:EditHelper");
        state.add("FigureViewmap:Figure");
        state.add("ExternalLabel:TextEditPart");
        state.add("ExternalLabel:TextNotationViewFactory");
        state.add("GenCustomPreferencePage:Qualified");
        state.add("GenCustomAction:Qualified");
        state.add("GenAction:Qualified");
        for (Object next : GMFGenPackage.eINSTANCE.getEClassifiers()) {
            if (!(next instanceof EClass)) continue;
            this.checkClassNamesCoverage(state, (EClass)next);
        }
    }

    protected void checkEditSupport(Set<String> state, GenCommonBase diagramElement) {
        SpecializationType specializationType;
        ElementType genType = diagramElement.getElementType();
        if (genType instanceof MetamodelType) {
            MetamodelType metamodelType = (MetamodelType)genType;
            this.checkClassName(state, "MetamodelType:EditHelper", metamodelType.getEditHelperClassName(), metamodelType.getEditHelperQualifiedClassName());
        } else if (genType instanceof SpecializationType && (specializationType = (SpecializationType)genType).getEditHelperAdviceClassName() != null) {
            this.checkClassName(state, "SpecializationType:EditHelperAdvice", specializationType.getEditHelperAdviceClassName(), specializationType.getEditHelperAdviceQualifiedClassName());
        }
    }

    protected void checkPackageName(Set<String> state, String id, String packageName) {
        IStatus s = JavaConventions.validatePackageName((String)packageName, (String)"1.4", (String)"1.4");
        HandcodedImplTest.assertTrue((String)(String.valueOf(id) + " package name is not valid : " + s.getMessage()), (s.getSeverity() != 4 ? 1 : 0) != 0);
        state.add(packageName);
        state.add(id);
    }

    protected void checkClassName(Set<String> state, String id, String simpleClassName, String qualifiedClassName) {
        IStatus s = JavaConventions.validateJavaTypeName((String)simpleClassName, (String)"1.4", (String)"1.4");
        HandcodedImplTest.assertTrue((String)(String.valueOf(id) + " simple class name is not valid : " + s.getMessage()), (s.getSeverity() != 4 ? 1 : 0) != 0);
        s = JavaConventions.validateJavaTypeName((String)qualifiedClassName, (String)"1.4", (String)"1.4");
        HandcodedImplTest.assertTrue((String)(String.valueOf(id) + " qualified class name is not valid : " + s.getMessage()), (s.getSeverity() != 4 ? 1 : 0) != 0);
        HandcodedImplTest.assertTrue((String)(String.valueOf(id) + " simple class name does not match the qualified one : '" + simpleClassName + "', '" + qualifiedClassName + "'"), (qualifiedClassName.endsWith(String.valueOf('.') + simpleClassName) || qualifiedClassName.endsWith(String.valueOf('$') + simpleClassName) ? 1 : 0) != 0);
        HandcodedImplTest.assertFalse((String)(String.valueOf(qualifiedClassName) + " is not unique"), (boolean)state.contains(qualifiedClassName));
        state.add(qualifiedClassName);
        state.add(id);
    }

    protected void checkPackageNamesCoverage(Set<String> state, EClass eClass) {
        for (EAttribute attribute : eClass.getEAttributes()) {
            if (!attribute.getName().endsWith("PackageName") || attribute.getName().length() <= "PackageName".length()) continue;
            String packageName = attribute.getName();
            packageName = packageName.substring(0, packageName.length() - "PackageName".length());
            String id = String.valueOf(eClass.getName()) + ':' + packageName;
            HandcodedImplTest.assertTrue((String)(String.valueOf(id) + " package name is not checked"), (boolean)state.contains(id));
        }
    }

    protected void checkClassNamesCoverage(Set<String> state, EClass eClass) {
        String id;
        String className;
        for (EAttribute attribute : eClass.getEAttributes()) {
            if (attribute.getName().endsWith("QualifiedClassName") && attribute.getName().length() > "QualifiedClassName".length() || !attribute.getName().endsWith("ClassName") || attribute.getName().length() <= "ClassName".length()) continue;
            className = attribute.getName();
            className = className.substring(0, className.length() - "ClassName".length());
            className = String.valueOf(Character.toUpperCase(className.charAt(0))) + className.substring(1);
            id = String.valueOf(eClass.getName()) + ':' + className;
            HandcodedImplTest.assertTrue((String)(String.valueOf(id) + " simple class name is not checked"), (boolean)state.contains(id));
        }
        for (EOperation operation : eClass.getEOperations()) {
            if (!operation.getName().startsWith("get") || !operation.getName().endsWith("QualifiedClassName") || operation.getName().length() <= "get".length() + "QualifiedClassName".length()) continue;
            className = operation.getName();
            className = className.substring("get".length(), className.length() - "QualifiedClassName".length());
            id = String.valueOf(eClass.getName()) + ':' + className;
            HandcodedImplTest.assertTrue((String)(String.valueOf(id) + " qualified class name is not checked"), (boolean)state.contains(id));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CustomLinkModelFacet
    extends EObjectImpl
    implements LinkModelFacet {
        private EList<GenClass> myTypes;

        protected CustomLinkModelFacet(GenClass[] types) {
            this.myTypes = new BasicEList.UnmodifiableEList(types.length, (Object[])types);
        }

        public EList<GenClass> getAssistantSourceTypes() {
            return this.myTypes;
        }

        public EList<GenClass> getAssistantTargetTypes() {
            return this.myTypes;
        }

        public GenClass getSourceType() {
            return null;
        }

        public GenClass getTargetType() {
            return null;
        }

        public TreeIterator<EObject> eAllContents() {
            return null;
        }

        public EClass eClass() {
            return null;
        }

        public EObject eContainer() {
            return null;
        }

        public EStructuralFeature eContainingFeature() {
            return null;
        }

        public EReference eContainmentFeature() {
            return null;
        }

        public EList<EObject> eContents() {
            return null;
        }

        public EList<EObject> eCrossReferences() {
            return null;
        }

        public Object eGet(EStructuralFeature feature) {
            return null;
        }

        public Object eGet(EStructuralFeature feature, boolean resolve) {
            return null;
        }

        public boolean eIsProxy() {
            return false;
        }

        public boolean eIsSet(EStructuralFeature feature) {
            return false;
        }

        public Resource eResource() {
            return null;
        }

        public void eSet(EStructuralFeature feature, Object newValue) {
        }

        public void eUnset(EStructuralFeature feature) {
        }

        public EList<Adapter> eAdapters() {
            return null;
        }

        public boolean eDeliver() {
            return false;
        }

        public void eNotify(Notification notification) {
        }

        public void eSetDeliver(boolean deliver) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GenCommonBaseIterator
    implements Iterator<GenCommonBase> {
        private GenCommonBase nextBase;
        private Iterator<?> wrappedIterator;

        public GenCommonBaseIterator(GenDiagram genDiagram) {
            assert (genDiagram != null);
            this.nextBase = genDiagram;
            this.wrappedIterator = genDiagram.eAllContents();
        }

        @Override
        public boolean hasNext() {
            return this.nextBase != null;
        }

        @Override
        public GenCommonBase next() {
            if (this.nextBase == null) {
                throw new NoSuchElementException();
            }
            GenCommonBase rv = this.nextBase;
            this.advance();
            return rv;
        }

        private void advance() {
            this.nextBase = null;
            while (this.wrappedIterator.hasNext()) {
                Object next = this.wrappedIterator.next();
                if (!(next instanceof GenCommonBase)) continue;
                this.nextBase = (GenCommonBase)next;
                break;
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

