/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.runtime.diagram.ui.services;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gmf.examples.runtime.diagram.logic.internal.editparts.CircuitEditPart;
import org.eclipse.gmf.examples.runtime.diagram.logic.internal.editparts.LEDEditPart;
import org.eclipse.gmf.examples.runtime.diagram.logic.internal.editparts.LogicGateEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.tests.runtime.diagram.ui.AbstractTestBase;
import org.eclipse.gmf.tests.runtime.diagram.ui.logic.LogicTestFixture;
import org.eclipse.gmf.tests.runtime.diagram.ui.services.LogicDiagramEventBroker;

public class DiagramEventBrokerServiceTests
extends AbstractTestBase {
    public DiagramEventBrokerServiceTests() {
        super("Diagram Event Broker Service Test Suite");
    }

    protected void setTestFixture() {
        this.testFixture = new LogicTestFixture();
    }

    public static Test suite() {
        TestSuite s = new TestSuite(DiagramEventBrokerServiceTests.class);
        return s;
    }

    protected LogicTestFixture getLogicTestFixture() {
        return (LogicTestFixture)this.getTestFixture();
    }

    public void test_DiagramEventBrokerProvider() {
        Rectangle rect = new Rectangle(this.getDiagramEditPart().getFigure().getBounds());
        this.getDiagramEditPart().getFigure().translateToAbsolute((Translatable)rect);
        IElementType typeLED = ElementTypeRegistry.getInstance().getType("logic.led");
        IElementType typeCircuit = ElementTypeRegistry.getInstance().getType("logic.circuit");
        IElementType typeAndGate = ElementTypeRegistry.getInstance().getType("logic.andgate");
        IElementType typeXorGate = ElementTypeRegistry.getInstance().getType("logic.xorgate");
        IElementType typeFlowContainer = ElementTypeRegistry.getInstance().getType("logic.flowcontainer");
        IElementType typeOrGate = ElementTypeRegistry.getInstance().getType("logic.orgate");
        Point createPt = new Point(100, 100);
        LEDEditPart ledEP = (LEDEditPart)this.getLogicTestFixture().createShapeUsingTool(typeLED, createPt, (IGraphicalEditPart)this.getDiagramEditPart());
        createPt.getTranslated(ledEP.getFigure().getSize().getExpanded(100, 100));
        CircuitEditPart circuitEP = (CircuitEditPart)this.getLogicTestFixture().createShapeUsingTool(typeCircuit, createPt, (IGraphicalEditPart)this.getDiagramEditPart());
        createPt.getTranslated(circuitEP.getFigure().getSize().getExpanded(100, 100));
        LogicGateEditPart andGateEP = (LogicGateEditPart)this.getLogicTestFixture().createShapeUsingTool(typeAndGate, createPt, (IGraphicalEditPart)this.getDiagramEditPart());
        createPt.getTranslated(andGateEP.getFigure().getSize().getExpanded(100, 100));
        LogicGateEditPart orGateEP = (LogicGateEditPart)this.getLogicTestFixture().createShapeUsingTool(typeOrGate, createPt, (IGraphicalEditPart)this.getDiagramEditPart());
        createPt.getTranslated(orGateEP.getFigure().getSize().getExpanded(100, 100));
        LogicGateEditPart xorGateEP = (LogicGateEditPart)this.getLogicTestFixture().createShapeUsingTool(typeXorGate, createPt, (IGraphicalEditPart)this.getDiagramEditPart());
        createPt.getTranslated(xorGateEP.getFigure().getSize().getExpanded(100, 100));
        this.getLogicTestFixture().createShapeUsingTool(typeFlowContainer, createPt, (IGraphicalEditPart)this.getDiagramEditPart());
        DiagramEventBrokerServiceTests.assertTrue((boolean)LogicDiagramEventBroker.isCreated());
        DiagramEventBrokerServiceTests.assertTrue((boolean)LogicDiagramEventBroker.isMethodInvoked());
    }
}

