/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.bridge.trace.impl;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.gmf.internal.bridge.trace.AbstractTrace;
import org.eclipse.gmf.internal.bridge.trace.GenChildNodeTrace;
import org.eclipse.gmf.internal.bridge.trace.GenLinkTrace;
import org.eclipse.gmf.internal.bridge.trace.GenNodeTrace;
import org.eclipse.gmf.internal.bridge.trace.GmfTracePlugin;
import org.eclipse.gmf.internal.bridge.trace.ToolGroupTrace;
import org.eclipse.gmf.internal.bridge.trace.TraceModel;
import org.eclipse.gmf.internal.bridge.trace.TracePackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TraceModelImpl
extends EObjectImpl
implements TraceModel {
    protected EList<GenNodeTrace> nodeTraces;
    protected EList<GenChildNodeTrace> childNodeTraces;
    protected EList<GenLinkTrace> linkTraces;
    protected EList<ToolGroupTrace> toolGroupTraces;

    protected TraceModelImpl() {
    }

    protected EClass eStaticClass() {
        return TracePackage.Literals.TRACE_MODEL;
    }

    @Override
    public EList<GenNodeTrace> getNodeTraces() {
        if (this.nodeTraces == null) {
            this.nodeTraces = new EObjectContainmentEList(GenNodeTrace.class, (InternalEObject)this, 0);
        }
        return this.nodeTraces;
    }

    @Override
    public EList<GenChildNodeTrace> getChildNodeTraces() {
        if (this.childNodeTraces == null) {
            this.childNodeTraces = new EObjectContainmentEList(GenChildNodeTrace.class, (InternalEObject)this, 1);
        }
        return this.childNodeTraces;
    }

    @Override
    public EList<GenLinkTrace> getLinkTraces() {
        if (this.linkTraces == null) {
            this.linkTraces = new EObjectContainmentEList(GenLinkTrace.class, (InternalEObject)this, 2);
        }
        return this.linkTraces;
    }

    @Override
    public EList<ToolGroupTrace> getToolGroupTraces() {
        if (this.toolGroupTraces == null) {
            this.toolGroupTraces = new EObjectContainmentEList(ToolGroupTrace.class, (InternalEObject)this, 3);
        }
        return this.toolGroupTraces;
    }

    @Override
    public GenNodeTrace getNodeTrace(int visualID) {
        for (GenNodeTrace trace : this.getNodeTraces()) {
            if (trace.getVisualID() != visualID) continue;
            return trace;
        }
        for (GenNodeTrace trace : this.getChildNodeTraces()) {
            if (trace.getVisualID() != visualID) continue;
            return trace;
        }
        throw new IllegalArgumentException("Node trace with id = " + visualID + " was not found");
    }

    @Override
    public GenLinkTrace getLinkTrace(int visualID) {
        for (GenLinkTrace trace : this.getLinkTraces()) {
            if (trace.getVisualID() != visualID) continue;
            return trace;
        }
        throw new IllegalArgumentException("Link trace with id = " + visualID + " was not found");
    }

    @Override
    public EList<AbstractTrace> getAllAbstractTraces() {
        ArrayList<AbstractTrace> result = new ArrayList<AbstractTrace>();
        result.addAll((Collection<AbstractTrace>)this.getNodeTraces());
        this.addNodeChildTraces((Collection<AbstractTrace>)result, (Collection<? extends GenNodeTrace>)this.getNodeTraces());
        result.addAll((Collection<AbstractTrace>)this.getChildNodeTraces());
        this.addNodeChildTraces((Collection<AbstractTrace>)result, (Collection<? extends GenNodeTrace>)this.getChildNodeTraces());
        result.addAll((Collection<AbstractTrace>)this.getLinkTraces());
        for (GenLinkTrace trace : this.getLinkTraces()) {
            result.addAll((Collection<AbstractTrace>)trace.getLinkLabelTraces());
        }
        result.addAll((Collection<AbstractTrace>)this.getToolGroupTraces());
        return new BasicEList.UnmodifiableEList(result.size(), result.toArray());
    }

    private void addNodeChildTraces(Collection<AbstractTrace> collection, Collection<? extends GenNodeTrace> nodeTraces) {
        for (GenNodeTrace genNodeTrace : nodeTraces) {
            collection.addAll((Collection<AbstractTrace>)genNodeTrace.getCompartmentTraces());
            collection.addAll((Collection<AbstractTrace>)genNodeTrace.getNodeLabelTraces());
        }
    }

    @Override
    public void purgeUnprocessedTraces() {
        for (AbstractTrace trace : this.getAllAbstractTraces()) {
            if (trace.isProcessed()) continue;
            GmfTracePlugin.getInstance().logDebugInfo("Removing unused trace with visual ID = " + trace.getVisualID());
            switch (trace.eClass().getClassifierID()) {
                case 3: {
                    this.getNodeTraces().remove((Object)trace);
                    break;
                }
                case 4: {
                    this.getChildNodeTraces().remove((Object)trace);
                    break;
                }
                case 6: {
                    this.getLinkTraces().remove((Object)trace);
                    break;
                }
                case 9: {
                    this.getToolGroupTraces().remove((Object)trace);
                    break;
                }
                case 5: {
                    ((GenNodeTrace)trace.eContainer()).getNodeLabelTraces().remove((Object)trace);
                    break;
                }
                case 7: {
                    ((GenNodeTrace)trace.eContainer()).getCompartmentTraces().remove((Object)trace);
                    break;
                }
                case 8: {
                    ((GenLinkTrace)trace.eContainer()).getLinkLabelTraces().remove((Object)trace);
                }
            }
        }
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 0: {
                return ((InternalEList)this.getNodeTraces()).basicRemove((Object)otherEnd, msgs);
            }
            case 1: {
                return ((InternalEList)this.getChildNodeTraces()).basicRemove((Object)otherEnd, msgs);
            }
            case 2: {
                return ((InternalEList)this.getLinkTraces()).basicRemove((Object)otherEnd, msgs);
            }
            case 3: {
                return ((InternalEList)this.getToolGroupTraces()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getNodeTraces();
            }
            case 1: {
                return this.getChildNodeTraces();
            }
            case 2: {
                return this.getLinkTraces();
            }
            case 3: {
                return this.getToolGroupTraces();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.getNodeTraces().clear();
                this.getNodeTraces().addAll((Collection)newValue);
                return;
            }
            case 1: {
                this.getChildNodeTraces().clear();
                this.getChildNodeTraces().addAll((Collection)newValue);
                return;
            }
            case 2: {
                this.getLinkTraces().clear();
                this.getLinkTraces().addAll((Collection)newValue);
                return;
            }
            case 3: {
                this.getToolGroupTraces().clear();
                this.getToolGroupTraces().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.getNodeTraces().clear();
                return;
            }
            case 1: {
                this.getChildNodeTraces().clear();
                return;
            }
            case 2: {
                this.getLinkTraces().clear();
                return;
            }
            case 3: {
                this.getToolGroupTraces().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return this.nodeTraces != null && !this.nodeTraces.isEmpty();
            }
            case 1: {
                return this.childNodeTraces != null && !this.childNodeTraces.isEmpty();
            }
            case 2: {
                return this.linkTraces != null && !this.linkTraces.isEmpty();
            }
            case 3: {
                return this.toolGroupTraces != null && !this.toolGroupTraces.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }
}

