/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.validate;

import java.util.List;
import junit.framework.TestCase;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.gmf.internal.validate.StatusCodes;
import org.eclipse.gmf.validate.GMFValidator;

public class ConstraintSeverityTest
extends TestCase {
    EClass targetMetaElement;
    EObject targetInstance;

    public ConstraintSeverityTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        EPackage ePackage = EcoreFactory.eINSTANCE.createEPackage();
        this.targetMetaElement = EcoreFactory.eINSTANCE.createEClass();
        ePackage.getEClassifiers().add((Object)this.targetMetaElement);
        this.targetInstance = this.targetMetaElement.getEPackage().getEFactoryInstance().create(this.targetMetaElement);
    }

    public void testDefaultSeverity() throws Exception {
        ConstraintSeverityTest.attachOCLConstraint((EModelElement)this.targetMetaElement, "false", null);
        ConstraintSeverityTest.assertEquals((String)"error severity expected as default", (int)4, (int)ConstraintSeverityTest.getValidationStatus(this.targetInstance).getSeverity());
    }

    public void testInfoExplicitSeverity() throws Exception {
        ConstraintSeverityTest.attachOCLConstraint((EModelElement)this.targetMetaElement, "false", "info");
        ConstraintSeverityTest.assertEquals((String)"info severity expected", (int)1, (int)ConstraintSeverityTest.getValidationStatus(this.targetInstance).getSeverity());
    }

    public void testWarnExplicitSeverity() throws Exception {
        ConstraintSeverityTest.attachOCLConstraint((EModelElement)this.targetMetaElement, "false", "warn");
        ConstraintSeverityTest.assertEquals((String)"warn severity expected", (int)2, (int)ConstraintSeverityTest.getValidationStatus(this.targetInstance).getSeverity());
    }

    public void testErrorExplicitSeverity() throws Exception {
        ConstraintSeverityTest.attachOCLConstraint((EModelElement)this.targetMetaElement, "false", "error");
        ConstraintSeverityTest.assertEquals((String)"error severity expected", (int)4, (int)ConstraintSeverityTest.getValidationStatus(this.targetInstance).getSeverity());
    }

    public void testInvalidSeverity() throws Exception {
        String invalidValue = "foo";
        ConstraintSeverityTest.attachOCLConstraint((EModelElement)this.targetMetaElement, "true", invalidValue);
        Diagnostic[] diagnostics = new Diagnostic[]{GMFValidator.validate((EObject)this.targetMetaElement), GMFValidator.validate((EObject)this.targetInstance)};
        int i = 0;
        while (i < diagnostics.length) {
            Diagnostic diagnostic = ConstraintSeverityTest.getDiagnosticForDestination(diagnostics[i], invalidValue);
            ConstraintSeverityTest.assertEquals((String)"Expected 'Invalid Constraint Severity' status code", (int)StatusCodes.INVALID_CONSTRAINT_SEVERITY, (int)diagnostic.getCode());
            ConstraintSeverityTest.assertEquals((String)"Expected 'error' severity", (int)4, (int)diagnostic.getSeverity());
            ConstraintSeverityTest.assertSame((Object)invalidValue, (Object)ConstraintSeverityTest.getDiagnosticDestination(diagnostic));
            ++i;
        }
    }

    static Diagnostic getValidationStatus(EObject target) {
        Diagnostic diagnostic = GMFValidator.validate((EObject)target);
        Diagnostic targetDiagnostic = ConstraintSeverityTest.getDiagnosticForDestination(diagnostic, target);
        ConstraintSeverityTest.assertNotNull((String)"No validation diagnostic produced for target", (Object)targetDiagnostic);
        return targetDiagnostic;
    }

    static Object getDiagnosticDestination(Diagnostic diagnostic) {
        if (diagnostic.getData() == null || diagnostic.getData().isEmpty()) {
            return null;
        }
        return diagnostic.getData().get(0);
    }

    static Diagnostic getDiagnosticForDestination(Diagnostic diagnostic, Object validatedObject) {
        List data = diagnostic.getData();
        if (data != null) {
            for (Object element : data) {
                if (element != validatedObject) continue;
                return diagnostic;
            }
        }
        for (Diagnostic childDiagnostic : diagnostic.getChildren()) {
            Diagnostic result = ConstraintSeverityTest.getDiagnosticForDestination(childDiagnostic, validatedObject);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    static EAnnotation attachOCLConstraint(EModelElement constrainedElement, String body, String severity) {
        EAnnotation annotation = EcoreFactory.eINSTANCE.createEAnnotation();
        annotation.setSource("http://www.eclipse.org/gmf/2005/constraints");
        annotation.getDetails().put((Object)"ocl", (Object)body);
        if (severity != null) {
            annotation.getDetails().put((Object)"severity", (Object)severity);
        }
        constrainedElement.getEAnnotations().add((Object)annotation);
        return annotation;
    }
}

