/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.tr;

import junit.framework.TestCase;
import org.eclipse.gmf.internal.common.codegen.TaggedTextMerger;

public abstract class TaggedTextMergerTest
extends TestCase {
    public TaggedTextMergerTest(String name) {
        super(name);
    }

    protected abstract TaggedTextMerger getTextMerger();

    protected abstract String getOldHeader();

    protected abstract String getOldPart1();

    protected abstract String getOldTail();

    protected abstract String getNewHeader();

    protected abstract String getNewPart1();

    protected abstract String getNewTail();

    protected abstract String getRegion1();

    protected abstract String getRegion2();

    public void testOneRegionMerge() throws Exception {
        TaggedTextMerger merger = this.getTextMerger();
        String oldText = String.valueOf(this.getOldHeader()) + merger.getBeginTag() + this.getRegion1() + merger.getEndTag() + this.getOldTail();
        String newText = String.valueOf(this.getNewHeader()) + merger.getBeginTag() + merger.getEndTag() + this.getNewTail();
        String mergedText = merger.process(oldText, newText);
        String expectedText = String.valueOf(this.getNewHeader()) + merger.getBeginTag() + this.getRegion1() + merger.getEndTag() + this.getNewTail();
        TaggedTextMergerTest.assertEquals((String)mergedText, (String)expectedText);
    }

    public void testTwoRegionsMerge() throws Exception {
        TaggedTextMerger merger = this.getTextMerger();
        String oldText = String.valueOf(this.getOldHeader()) + merger.getBeginTag() + this.getRegion1() + merger.getEndTag() + this.getOldPart1() + merger.getBeginTag() + this.getRegion2() + merger.getEndTag() + this.getOldTail();
        String newText = String.valueOf(this.getNewHeader()) + this.getNewPart1() + merger.getBeginTag() + merger.getEndTag() + this.getNewTail();
        String mergedText = merger.process(oldText, newText);
        String expectedText = String.valueOf(this.getNewHeader()) + this.getNewPart1() + merger.getBeginTag() + this.getRegion1() + this.getRegion2() + merger.getEndTag() + this.getNewTail();
        TaggedTextMergerTest.assertEquals((String)mergedText, (String)expectedText);
    }

    public void testIdentityMerge() throws Exception {
        TaggedTextMerger merger = this.getTextMerger();
        String newText = String.valueOf(this.getNewHeader()) + this.getNewPart1() + merger.getBeginTag() + merger.getEndTag() + this.getNewTail();
        String mergedText = merger.process(newText, newText);
        TaggedTextMergerTest.assertEquals((String)mergedText, (String)newText);
    }

    public void testAnchorTextPreservation() throws Exception {
        TaggedTextMerger merger = this.getTextMerger();
        String oldText = String.valueOf(this.getOldHeader()) + this.getOldTail();
        String newText = String.valueOf(this.getNewHeader()) + merger.getBeginTag() + "\n" + merger.getEndTag() + this.getNewTail();
        String mergedText = merger.process(oldText, newText);
        TaggedTextMergerTest.assertEquals((String)mergedText, (String)newText);
    }
}

