/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.gen;

import java.lang.reflect.Method;
import junit.framework.Assert;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gmf.gmfgraph.ChildAccess;
import org.eclipse.gmf.gmfgraph.FigureDescriptor;
import org.eclipse.gmf.tests.gen.FigureCodegenTestBase;
import org.eclipse.gmf.tests.setup.figures.FigureCheck;
import org.eclipse.gmf.tests.setup.figures.GenericFigureCheck;
import org.eclipse.gmf.tests.setup.figures.LabelSupportSetup;

public class LabelSupportTest
extends FigureCodegenTestBase {
    public LabelSupportTest(String name) {
        super(name);
    }

    private LabelSupportSetup getSessionSetup() {
        Assert.assertTrue((String)("Incorrect session setup was used, use FigureCodegenSetup instead of: " + this.mySessionSetup), (boolean)(this.mySessionSetup instanceof LabelSupportSetup));
        return (LabelSupportSetup)this.mySessionSetup;
    }

    public void testCustomFigureWithLabel() {
        this.doPerformTests(this.getSessionSetup().getCustom());
    }

    public void testRectangleWithLabel() {
        this.doPerformTests(this.getSessionSetup().getSimple());
    }

    public void testLabeledContainer() {
        this.doPerformTests(this.getSessionSetup().getLabeledContainer());
    }

    public void testDeepLabelGraphdefOnly() {
        this.doPerformTests(this.getSessionSetup().getRoot());
    }

    protected void doPerformTests(FigureDescriptor fd) {
        this.performTests(fd, new GenericFigureCheck(fd.getActualFigure()).chain(new LabelAccessorCheck((ChildAccess)fd.getAccessors().get(0))));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LabelAccessorCheck
    extends FigureCheck {
        private final ChildAccess myLabelAccess;

        public LabelAccessorCheck(ChildAccess labelAccess) {
            this.myLabelAccess = labelAccess;
        }

        @Override
        protected void checkFigure(IFigure figure) {
            LabelAccessorCheck.assertNotNull((Object)figure);
            LabelAccessorCheck.assertTrue((String)"NodeEditPart requires this method in the inner figure class", (boolean)LabelAccessorCheck.hasMethod(figure, this.myLabelAccess.getAccessor(), null));
        }

        private static boolean hasMethod(Object instance, String methodName, Class<?>[] params) {
            try {
                Method method = instance.getClass().getMethod(methodName, params);
                return method != null;
            }
            catch (Exception exception) {
                return false;
            }
        }
    }
}

