/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.codegen.dispatch;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.gmf.internal.codegen.dispatch.TemplateRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StaticTemplateRegistry
implements TemplateRegistry {
    private final Map<Object, String> pathMap = new HashMap<Object, String>();
    private final Map<Object, Class<?>> classMap = new HashMap();
    private final Map<Object, ClassLoader> classLoaderMap = new HashMap<Object, ClassLoader>();
    private final ClassLoader myDefaultClassLoader;

    public StaticTemplateRegistry(ClassLoader defaultClassLoader) {
        assert (defaultClassLoader != null);
        this.myDefaultClassLoader = defaultClassLoader;
    }

    public void put(Object key, String templatePath, Class<?> generatorClass) {
        this.put(key, templatePath, generatorClass, null);
    }

    public void put(Object key, String templatePath, Class<?> generatorClass, ClassLoader templateClassLoader) {
        assert (key != null && templatePath != null);
        this.pathMap.put(key, templatePath);
        if (generatorClass != null) {
            this.classMap.put(key, generatorClass);
        }
        if (templateClassLoader != null) {
            this.classLoaderMap.put(key, templateClassLoader);
        }
    }

    @Override
    public String getTemplatePath(Object key) {
        return this.pathMap.get(key);
    }

    @Override
    public ClassLoader getTemplateClassLoader(Object key) {
        if (this.classLoaderMap.containsKey(key)) {
            return this.classLoaderMap.get(key);
        }
        return this.myDefaultClassLoader;
    }

    @Override
    public boolean hasGeneratorClass(Object key) {
        return this.classMap.containsKey(key);
    }

    @Override
    public Class<?> getGeneratorClass(Object key) {
        return this.classMap.get(key);
    }

    @Override
    public void clean() {
        this.pathMap.clear();
        this.classMap.clear();
        this.classLoaderMap.clear();
    }
}

