/*******************************************************************************
 * Copyright (c) 2008 Ecliptical Software Inc. and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Ecliptical Software Inc. - initial API and implementation
 *******************************************************************************/
package org.eclipse.emf.mint.internal.genmodel;

import java.util.Arrays;
import java.util.List;

import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenModelPackage;
import org.eclipse.emf.codegen.ecore.genmodel.GenOperation;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.mint.IItemJavaElementDescriptor;
import org.eclipse.emf.mint.IItemJavaElementSource;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;

public class GenOperationItemProvider extends JavaElementItemProviderAdapter
		implements IItemJavaElementSource {

	protected static final List<EReference> GROUP_REFERENCES = Arrays
			.asList(GenModelPackage.Literals.GEN_OPERATION__ECORE_OPERATION);

	protected static final List<EStructuralFeature> OBSERVED_FEATURES = Arrays
			.asList(
					(EStructuralFeature) GenModelPackage.Literals.GEN_OPERATION__GEN_PARAMETERS,
					GenModelPackage.Literals.GEN_OPERATION__GEN_TYPE_PARAMETERS);

	public GenOperationItemProvider(AdapterFactory adapterFactory) {
		super(adapterFactory);
	}

	@Override
	public List<IItemJavaElementDescriptor> getJavaElementDescriptors(
			Object object) {
		GenOperation genOperation = (GenOperation) object;
		UniqueEList<IItemJavaElementDescriptor> list = new UniqueEList<IItemJavaElementDescriptor>();

		IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
		GenModel genModel = genOperation.getGenModel();
		String modelDir = genModel.getModelDirectory();

		if (!genOperation.isSuppressedVisibility())
			addMethod(
					modelDir,
					genOperation.getGenClass().getQualifiedInterfaceName(),
					genOperation.getName(),
					genOperation.getGenParameters(),
					CAT_INTERFACE,
					Messages.GenOperationItemProvider_MethodInterfaceLabel,
					Messages.GenOperationItemProvider_MethodInterfaceDescription,
					GenModelPackage.Literals.GEN_OPERATION__ECORE_OPERATION,
					list);

		if (!genOperation.getGenClass().isDynamic())
			addMethod(
					modelDir,
					genOperation.getGenClass().getQualifiedClassName(),
					genOperation.getName(),
					genOperation.getGenParameters(),
					CAT_IMPLEMENTATION,
					Messages.GenOperationItemProvider_MethodImplementationLabel,
					Messages.GenOperationItemProvider_MethodImplementationDescription,
					GenModelPackage.Literals.GEN_OPERATION__ECORE_OPERATION,
					list);

		IPath path = new Path(genModel.getModelProjectDirectory());
		IJavaProject ctx = JavaCore.create(root.getProject(path.segment(0)));

		if (!genOperation.isVoid() && !genOperation.isPrimitiveType()) {
			String typeName = genOperation.getQualifiedListItemType(null);
			addType(ctx, typeName, CAT_INTERFACE,
					Messages.GenOperationItemProvider_ReturnTypeLabel,
					Messages.GenOperationItemProvider_ReturnTypeDescription,
					GenModelPackage.Literals.GEN_OPERATION__ECORE_OPERATION,
					list);
		}

		// TODO add list, map entry types, parameters, and exceptions

		return list;
	}

	@Override
	protected GroupReferenceGenModelSwitch createGroupReferenceGenModelSwitch() {
		return new GroupReferenceGenModelSwitch() {
			@Override
			public List<EReference> caseGenOperation(GenOperation object) {
				return GROUP_REFERENCES;
			}
		};
	}

	@Override
	protected ObservedFeatureGenModelSwitch createObservedFeatureGenModelSwitch() {
		return new ObservedFeatureGenModelSwitch() {
			@Override
			public List<EStructuralFeature> caseGenOperation(GenOperation object) {
				return OBSERVED_FEATURES;
			}
		};
	}
}
